/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.enums;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class EnumUtility {
    public static <E extends Enum<E>> Set<String> getEnumNames(Class<E> enumClass) {
        Asserts.assertNonNullOrThrow(enumClass, ExceptionsMessagesUtility.invalidAttribute("enumClass"));
        return EnumSet.allOf(enumClass).stream().map(Enum::name).collect(Collectors.toSet());
    }

    @Generated
    private EnumUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

