/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.exceptions;

import io.tech1.framework.domain.exceptions.ThrowableTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.Generated;

public final class ThrowableUtility {
    public static ThrowableTrace getTrace(Throwable throwable) {
        return ThrowableUtility.getTrace(throwable, 3000);
    }

    public static ThrowableTrace getTrace(Throwable throwable, int length) {
        return ThrowableTrace.of(ThrowableUtility.getTracedText(throwable, length));
    }

    private static String getTracedText(Throwable throwable, int length) {
        if (length < 200) {
            length = 200;
        }
        Object message = "Throwable occurred! Please take required actions!\n\n";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String throwableMessage = sw.toString();
        int maxLength = Math.min(throwableMessage.length(), length);
        message = (String)message + throwableMessage.substring(0, maxLength);
        return message;
    }

    @Generated
    private ThrowableUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

