/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.http;

import io.tech1.framework.domain.exceptions.cookie.CookieNotFoundException;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;

public final class HttpCookieUtility {
    public static Cookie createCookie(String cookieKey, String cookieValue, String domain, boolean httpOnly, int maxAge) {
        Cookie cookie = new Cookie(cookieKey, cookieValue);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setHttpOnly(httpOnly);
        cookie.setMaxAge(maxAge);
        return cookie;
    }

    public static Cookie createNullCookie(String cookieKey, String domain) {
        return HttpCookieUtility.createCookie(cookieKey, null, domain, true, 0);
    }

    public static String readCookie(HttpServletRequest request, String cookieKey) throws CookieNotFoundException {
        Optional<Cookie> cookieOpt;
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies) && (cookieOpt = Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(cookieKey)).findFirst()).isPresent()) {
            return cookieOpt.get().getValue();
        }
        throw new CookieNotFoundException(ExceptionsMessagesUtility.entityNotFound("CookieKey", cookieKey));
    }

    @Generated
    private HttpCookieUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

