/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.http;

import com.blueconic.browscap.BrowsCapField;
import com.blueconic.browscap.Capabilities;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import io.tech1.framework.domain.http.requests.IPAddress;
import io.tech1.framework.domain.http.requests.UserAgentDetails;
import io.tech1.framework.domain.http.requests.UserAgentHeader;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.strings.StringUtility;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;

public final class HttpServletRequestUtility {
    public static String getBaseURL(String url) {
        int index = url.indexOf("?");
        return index != -1 ? url.substring(0, index) : url;
    }

    public static String getFullURL(HttpServletRequest request) {
        if (Objects.isNull(request)) {
            throw new IllegalArgumentException(ExceptionsMessagesUtility.invalidAttribute("request"));
        }
        StringBuffer requestURL = request.getRequestURL();
        if (Objects.isNull(requestURL)) {
            throw new IllegalArgumentException(ExceptionsMessagesUtility.invalidAttribute("request.requestURL"));
        }
        String queryString = request.getQueryString();
        return Objects.isNull(queryString) ? requestURL.toString() : requestURL.append("?").append(queryString).toString();
    }

    public static IPAddress getClientIpAddr(HttpServletRequest request) {
        String unknown = "unknown";
        String ip = request.getHeader("X-Forwarded-For");
        if (!StringUtility.hasLength(ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (!StringUtility.hasLength(ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (!StringUtility.hasLength(ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (!StringUtility.hasLength(ip) || unknown.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (!StringUtility.hasLength(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return new IPAddress(ip);
    }

    public static UserAgentDetails getUserAgentDetails(UserAgentHeader userAgentHeader) {
        try {
            UserAgentParser userAgentParser = new UserAgentService().loadParser(List.of(BrowsCapField.BROWSER, BrowsCapField.PLATFORM, BrowsCapField.DEVICE_TYPE));
            Capabilities capabilities = userAgentParser.parse(userAgentHeader.getValue());
            return UserAgentDetails.processed(capabilities.getBrowser(), capabilities.getPlatform(), capabilities.getDeviceType());
        }
        catch (ParseException | IOException ex) {
            return UserAgentDetails.unknown(ex.getMessage());
        }
    }

    @Generated
    private HttpServletRequestUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

