/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.numbers;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.constants.BigDecimalConstants;
import io.tech1.framework.domain.tuples.TupleRange;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.Generated;

public final class BigDecimalUtility {
    private static final String NUMBER1_PARAM = "number1";
    private static final String NUMBER2_PARAM = "number2";

    public static boolean areValuesEquals(BigDecimal number1, BigDecimal number2) {
        if (Objects.isNull(number1) && Objects.isNull(number2)) {
            return true;
        }
        if (Objects.isNull(number1) || Objects.isNull(number2)) {
            return false;
        }
        return number1.compareTo(number2) == 0;
    }

    public static boolean isFirstValueGreater(BigDecimal number1, BigDecimal number2) {
        Asserts.assertNonNullOrThrow(number1, ExceptionsMessagesUtility.invalidAttribute(NUMBER1_PARAM));
        Asserts.assertNonNullOrThrow(number2, ExceptionsMessagesUtility.invalidAttribute(NUMBER2_PARAM));
        return number1.compareTo(number2) > 0;
    }

    public static boolean isFirstValueGreaterOrEqual(BigDecimal number1, BigDecimal number2) {
        Asserts.assertNonNullOrThrow(number1, ExceptionsMessagesUtility.invalidAttribute(NUMBER1_PARAM));
        Asserts.assertNonNullOrThrow(number2, ExceptionsMessagesUtility.invalidAttribute(NUMBER2_PARAM));
        return number1.compareTo(number2) >= 0;
    }

    public static boolean isFirstValueLesser(BigDecimal number1, BigDecimal number2) {
        Asserts.assertNonNullOrThrow(number1, ExceptionsMessagesUtility.invalidAttribute(NUMBER1_PARAM));
        Asserts.assertNonNullOrThrow(number2, ExceptionsMessagesUtility.invalidAttribute(NUMBER2_PARAM));
        return number1.compareTo(number2) < 0;
    }

    public static boolean isFirstValueLesserOrEqual(BigDecimal number1, BigDecimal number2) {
        Asserts.assertNonNullOrThrow(number1, ExceptionsMessagesUtility.invalidAttribute(NUMBER1_PARAM));
        Asserts.assertNonNullOrThrow(number2, ExceptionsMessagesUtility.invalidAttribute(NUMBER2_PARAM));
        return number1.compareTo(number2) <= 0;
    }

    public static boolean inRange(BigDecimal number, TupleRange<BigDecimal> range) {
        Asserts.assertNonNullOrThrow(number, ExceptionsMessagesUtility.invalidAttribute("number"));
        Asserts.assertNonNullOrThrow(range, ExceptionsMessagesUtility.invalidAttribute("range"));
        return BigDecimalUtility.isFirstValueGreater(number, range.getFrom()) && BigDecimalUtility.isFirstValueLesser(number, range.getTo());
    }

    public static boolean inRangeClosed(BigDecimal number, TupleRange<BigDecimal> range) {
        Asserts.assertNonNullOrThrow(number, ExceptionsMessagesUtility.invalidAttribute("number"));
        Asserts.assertNonNullOrThrow(range, ExceptionsMessagesUtility.invalidAttribute("range"));
        return BigDecimalUtility.isFirstValueGreaterOrEqual(number, range.getFrom()) && BigDecimalUtility.isFirstValueLesserOrEqual(number, range.getTo());
    }

    public static boolean isZero(BigDecimal number) {
        return BigDecimalUtility.areValuesEquals(number, BigDecimal.ZERO);
    }

    public static boolean isNullOrZero(BigDecimal number) {
        return Objects.isNull(number) || BigDecimalUtility.isZero(number);
    }

    public static boolean isOneHundred(BigDecimal number) {
        return BigDecimalUtility.areValuesEquals(number, BigDecimalConstants.ONE_HUNDRED);
    }

    public static boolean isPositive(BigDecimal number) {
        return BigDecimalUtility.isFirstValueGreater(number, BigDecimal.ZERO);
    }

    public static boolean isPositiveOrZero(BigDecimal number) {
        return BigDecimalUtility.isFirstValueGreaterOrEqual(number, BigDecimal.ZERO);
    }

    public static boolean isNegative(BigDecimal number) {
        return BigDecimalUtility.isFirstValueLesser(number, BigDecimal.ZERO);
    }

    public static boolean isNegativeOrZero(BigDecimal number) {
        return BigDecimalUtility.isFirstValueLesserOrEqual(number, BigDecimal.ZERO);
    }

    public static BigDecimal absOrZero(BigDecimal number) {
        if (Objects.isNull(number)) {
            return BigDecimal.ZERO;
        }
        if (BigDecimalUtility.isPositiveOrZero(number)) {
            return number;
        }
        return number.negate();
    }

    @Generated
    private BigDecimalUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

