/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.numbers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public final class RoundingUtility {
    public static final int DEFAULT_SCALE = 3;
    private static final Map<Integer, DecimalFormat> DFS_BY_SCALE = new ConcurrentHashMap<Integer, DecimalFormat>();

    public static BigDecimal scale(BigDecimal value) {
        return RoundingUtility.scale(value, 3);
    }

    public static BigDecimal scale(BigDecimal value, int scale) {
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal divider, BigDecimal divisor) {
        return RoundingUtility.divide(divider, divisor, 3);
    }

    public static BigDecimal divide(BigDecimal divider, BigDecimal divisor, int scale) {
        return divider.divide(divisor, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divideOrZero(BigDecimal divider, BigDecimal divisor, int scale) {
        if (Objects.nonNull(divisor) && divisor.compareTo(BigDecimal.ZERO) != 0) {
            return divider.divide(divisor, scale, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal divideOrOne(BigDecimal divider, BigDecimal divisor, int scale) {
        try {
            if (Objects.nonNull(divisor) && divisor.compareTo(BigDecimal.ZERO) != 0) {
                return divider.divide(divisor, scale, RoundingMode.HALF_UP);
            }
            return BigDecimal.ONE;
        }
        catch (RuntimeException ex) {
            return BigDecimal.ONE;
        }
    }

    public static String format(BigDecimal value) {
        return RoundingUtility.format(value, 3);
    }

    public static String format(BigDecimal value, int scale) {
        DecimalFormat decimalFormat;
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setGroupingSeparator(' ');
        if (DFS_BY_SCALE.containsKey(scale)) {
            decimalFormat = DFS_BY_SCALE.get(scale);
        } else {
            String pattern = "###,###." + IntStream.range(0, scale).mapToObj(i -> "#").collect(Collectors.joining());
            decimalFormat = new DecimalFormat(pattern, symbols);
            DFS_BY_SCALE.put(scale, decimalFormat);
        }
        return decimalFormat.format(value).replace(".", ",");
    }

    @Generated
    private RoundingUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

