/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.random;

import io.tech1.framework.domain.base.Password;
import io.tech1.framework.domain.base.Username;
import io.tech1.framework.domain.geo.GeoLocation;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThreshold;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThresholds;
import io.tech1.framework.domain.http.requests.IPAddress;
import io.tech1.framework.domain.http.requests.UserAgentDetails;
import io.tech1.framework.domain.http.requests.UserRequestMetadata;
import io.tech1.framework.domain.utilities.collections.CollectionUtility;
import io.tech1.framework.domain.utilities.random.RandomUtility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public final class EntityUtility {
    private static final Map<Class<?>, Function<Class<?>, Object>> CONSTRUCTORS_RULES = new HashMap();
    private static final Deque<Function<Class<?>, Optional<?>>> RANDOM_TYPES_RULES = new LinkedList();

    public static void addConstructorRule(Class<?> constructorClass, Function<Class<?>, Object> constructionFnc) {
        CONSTRUCTORS_RULES.put(constructorClass, constructionFnc);
    }

    public static void addClassRule(Predicate<Class<?>> newPredicate, Function<Class<?>, ?> newFunction) {
        RANDOM_TYPES_RULES.addFirst(definedRule -> {
            if (newPredicate.test((Class<?>)definedRule)) {
                return Optional.of(newFunction.apply((Class<?>)definedRule));
            }
            return Optional.empty();
        });
    }

    public static <T> T entity(Class<? extends T> type) {
        try {
            Function<Class<?>, Object> clazzFunction = CONSTRUCTORS_RULES.get(type);
            if (Objects.nonNull(clazzFunction)) {
                return (T)clazzFunction.apply(type);
            }
            return EntityUtility.createWithDefaultConstructor(type);
        }
        catch (ReflectiveOperationException ex1) {
            try {
                return EntityUtility.createNoDefaultConstructor(type);
            }
            catch (ReflectiveOperationException ex2) {
                try {
                    return EntityUtility.createPrivateDataLombokBasedConstructor(type);
                }
                catch (ReflectiveOperationException ex3) {
                    throw new IllegalArgumentException("Please add entity construction rules or extend functionality. Class: `" + type.getCanonicalName() + "`");
                }
            }
        }
    }

    public static <T> List<T> list(Class<? extends T> type, int size) {
        return IntStream.range(0, size).mapToObj(i -> EntityUtility.entity(type)).collect(Collectors.toList());
    }

    public static <T> List<T> list345(Class<? extends T> type) {
        return EntityUtility.list(type, RandomUtility.randomIntegerGreaterThanZeroByBounds(2, 5));
    }

    public static <T> Set<T> set(Class<? extends T> type, int size) {
        return IntStream.range(0, size).mapToObj(i -> EntityUtility.entity(type)).collect(Collectors.toSet());
    }

    public static <T> Set<T> set345(Class<? extends T> type) {
        return EntityUtility.set(type, RandomUtility.randomIntegerGreaterThanZeroByBounds(2, 5));
    }

    public static <T> void setObjectFields(T instance) throws ReflectiveOperationException {
        if (instance == null) {
            throw new ReflectiveOperationException("Cannot invoke setter. Instance is null");
        }
        List setters = Stream.of(instance.getClass().getMethods()).filter(method -> {
            Class<?>[] params = method.getParameterTypes();
            return method.getName().startsWith("set") && params.length > 0;
        }).collect(Collectors.toList());
        for (Method setter : setters) {
            try {
                Class<?> setterClass = setter.getParameterTypes()[0];
                setter.invoke(instance, EntityUtility.getRandomValueByClass(setterClass));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                String message = "Cannot invoke setter. Unexpected setter signature";
                throw new ReflectiveOperationException(message);
            }
        }
    }

    public static Object getRandomValueByClass(Class<?> rndClass) {
        Optional randomValueOpt;
        Optional<Optional> matches = RANDOM_TYPES_RULES.stream().map(item -> (Optional)item.apply(rndClass)).filter(Optional::isPresent).findFirst();
        if (matches.isPresent() && (randomValueOpt = matches.get()).isPresent()) {
            return randomValueOpt.get();
        }
        return null;
    }

    private static <T> T createWithDefaultConstructor(Class<? extends T> type) throws ReflectiveOperationException {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        EntityUtility.setObjectFields(instance);
        return instance;
    }

    private static <T> T createNoDefaultConstructor(Class<? extends T> type) throws ReflectiveOperationException {
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors.length == 0) {
            throw new ReflectiveOperationException("There is no constructors to initiate instance of type: " + type);
        }
        Constructor<?> constructor = constructors[0];
        Object[] args = Stream.of(constructor.getParameterTypes()).map(EntityUtility::getRandomValueByClass).toArray();
        Object instance = constructor.newInstance(args);
        EntityUtility.setObjectFields(instance);
        return (T)instance;
    }

    private static <T> T createPrivateDataLombokBasedConstructor(Class<? extends T> type) throws ReflectiveOperationException {
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object[] args = Stream.of(constructor.getParameterTypes()).map(EntityUtility::getRandomValueByClass).toArray();
        return (T)constructor.newInstance(args);
    }

    @Generated
    private EntityUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EntityUtility.addConstructorRule(BigDecimal.class, clazz -> RandomUtility.randomBigDecimal());
        EntityUtility.addConstructorRule(BigInteger.class, clazz -> RandomUtility.randomBigInteger());
        EntityUtility.addConstructorRule(Long.class, clazz -> RandomUtility.randomLong());
        EntityUtility.addConstructorRule(Integer.class, clazz -> RandomUtility.randomInteger());
        EntityUtility.addConstructorRule(Double.class, clazz -> RandomUtility.randomDouble());
        EntityUtility.addConstructorRule(ZoneId.class, clazz -> RandomUtility.randomZoneId());
        EntityUtility.addConstructorRule(TimeZone.class, clazz -> RandomUtility.randomTimeZone());
        EntityUtility.addConstructorRule(Username.class, clazz -> RandomUtility.randomUsername());
        EntityUtility.addConstructorRule(Password.class, clazz -> RandomUtility.randomPassword());
        EntityUtility.addConstructorRule(IPAddress.class, clazz -> RandomUtility.randomIPAddress());
        EntityUtility.addConstructorRule(GeoLocation.class, clazz -> RandomUtility.randomGeoLocation());
        EntityUtility.addConstructorRule(UserAgentDetails.class, clazz -> RandomUtility.randomUserAgentDetails());
        EntityUtility.addConstructorRule(UserRequestMetadata.class, clazz -> RandomUtility.randomUserRequestMetadata());
        EntityUtility.addConstructorRule(HardwareMonitoringThreshold.class, clazz -> RandomUtility.randomHardwareMonitoringThreshold());
        EntityUtility.addConstructorRule(HardwareMonitoringThresholds.class, clazz -> RandomUtility.randomHardwareMonitoringThresholds());
        EntityUtility.addClassRule(parameterClass -> {
            boolean isNotPrimitiveOrWrapper = !parameterClass.isPrimitive() && !RandomUtility.containsPrimitiveWrapper(parameterClass);
            boolean isNotEnum = !Enum.class.isAssignableFrom((Class<?>)parameterClass);
            boolean isNotAnnotation = !Annotation.class.isAssignableFrom((Class<?>)parameterClass);
            boolean isNotInterface = !parameterClass.isInterface();
            return isNotPrimitiveOrWrapper && isNotEnum && isNotAnnotation && isNotInterface;
        }, EntityUtility::entity);
        EntityUtility.addClassRule(Class::isEnum, RandomUtility::randomEnumWildcard);
        EntityUtility.addClassRule(List.class::equals, parameterClass -> Collections.emptyList());
        EntityUtility.addClassRule(Set.class::equals, parameterClass -> Collections.emptySet());
        EntityUtility.addClassRule(Queue.class::equals, parameterClass -> CollectionUtility.emptyQueue());
        EntityUtility.addClassRule(Date.class::equals, parameterClass -> RandomUtility.randomDate());
        EntityUtility.addClassRule(LocalDate.class::equals, parameterClass -> RandomUtility.randomLocalDate());
        EntityUtility.addClassRule(LocalDateTime.class::equals, parameterClass -> RandomUtility.randomLocalDateTime());
        EntityUtility.addClassRule(BigDecimal.class::equals, parameterClass -> RandomUtility.randomBigDecimal());
        EntityUtility.addClassRule(BigInteger.class::equals, parameterClass -> RandomUtility.randomBigInteger());
        EntityUtility.addClassRule(Double.class::equals, parameterClass -> RandomUtility.randomDouble());
        EntityUtility.addClassRule(Double.TYPE::equals, parameterClass -> RandomUtility.randomDouble());
        EntityUtility.addClassRule(Long.class::equals, parameterClass -> RandomUtility.randomLong());
        EntityUtility.addClassRule(Long.TYPE::equals, parameterClass -> RandomUtility.randomLong());
        EntityUtility.addClassRule(Integer.class::equals, parameterClass -> RandomUtility.randomInteger());
        EntityUtility.addClassRule(Integer.TYPE::equals, parameterClass -> RandomUtility.randomInteger());
        EntityUtility.addClassRule(String.class::equals, parameterClass -> RandomUtility.randomString());
        EntityUtility.addClassRule(Short.class::equals, parameterClass -> RandomUtility.randomShort());
        EntityUtility.addClassRule(Short.TYPE::equals, parameterClass -> RandomUtility.randomShort());
        EntityUtility.addClassRule(Boolean.class::equals, parameterClass -> RandomUtility.randomBoolean());
        EntityUtility.addClassRule(Boolean.TYPE::equals, parameterClass -> RandomUtility.randomBoolean());
        EntityUtility.addClassRule(ZoneId.class::equals, parameterClass -> RandomUtility.randomZoneId());
        EntityUtility.addClassRule(TimeZone.class::equals, parameterClass -> RandomUtility.randomTimeZone());
        EntityUtility.addClassRule(Username.class::equals, parameterClass -> RandomUtility.randomUsername());
        EntityUtility.addClassRule(IPAddress.class::equals, parameterClass -> RandomUtility.randomIPAddress());
        EntityUtility.addClassRule(GeoLocation.class::equals, parameterClass -> RandomUtility.randomGeoLocation());
        EntityUtility.addClassRule(UserAgentDetails.class::equals, parameterClass -> RandomUtility.randomUserAgentDetails());
        EntityUtility.addClassRule(UserRequestMetadata.class::equals, parameterClass -> RandomUtility.randomUserRequestMetadata());
        EntityUtility.addClassRule(HardwareMonitoringThreshold.class::equals, parameterClass -> RandomUtility.randomHardwareMonitoringThreshold());
        EntityUtility.addClassRule(HardwareMonitoringThresholds.class::equals, parameterClass -> RandomUtility.randomHardwareMonitoringThresholds());
    }
}

