/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.random;

import feign.FeignException;
import feign.Request;
import io.tech1.framework.domain.base.Password;
import io.tech1.framework.domain.base.Username;
import io.tech1.framework.domain.constants.BigDecimalConstants;
import io.tech1.framework.domain.exceptions.random.IllegalEnumException;
import io.tech1.framework.domain.geo.GeoLocation;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringDatapointTableRow;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThreshold;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThresholds;
import io.tech1.framework.domain.hardware.monitoring.HardwareName;
import io.tech1.framework.domain.http.requests.IPAddress;
import io.tech1.framework.domain.http.requests.UserAgentDetails;
import io.tech1.framework.domain.http.requests.UserRequestMetadata;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public final class RandomUtility {
    private static final String LETTERS_OR_NUMBERS = "AaBbCcDdEeFfGgHgIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789";
    private static final SecureRandom RND = new SecureRandom();
    private static final Map<Class<?>, Supplier<?>> PRIMITIVE_WRAPPERS = Map.of(Short.class, RandomUtility::randomShort, Boolean.class, RandomUtility::randomBoolean, Integer.class, RandomUtility::randomInteger, Long.class, RandomUtility::randomLong, Double.class, RandomUtility::randomDouble, BigDecimal.class, RandomUtility::randomBigDecimal);

    public static Number one(Class<? extends Number> clazz) {
        if (clazz == Short.class) {
            return 1;
        }
        if (clazz == Integer.class) {
            return 1;
        }
        if (clazz == Long.class) {
            return 1L;
        }
        if (clazz == Double.class) {
            return 1.0;
        }
        if (clazz == BigDecimal.class) {
            return BigDecimal.ONE;
        }
        throw new IllegalArgumentException("Unexpected clazz: " + clazz.getName());
    }

    public static Short randomShort() {
        return (short)RND.nextInt(Short.MAX_VALUE);
    }

    public static boolean randomBoolean() {
        return RND.nextBoolean();
    }

    public static Double randomDouble() {
        return RND.nextDouble();
    }

    public static Integer randomInteger() {
        return RND.nextInt();
    }

    public static Integer randomIntegerGreaterThanZero() {
        return Math.abs(RandomUtility.randomInteger());
    }

    public static Integer randomIntegerLessThanZero() {
        return -RandomUtility.randomIntegerGreaterThanZero().intValue();
    }

    public static Integer randomIntegerGreaterThanZeroByBounds(int lowerBound, int upperBound) {
        return lowerBound + RND.nextInt(upperBound - lowerBound + 1);
    }

    public static Long randomLong() {
        return RND.nextLong();
    }

    public static Long randomLongGreaterThanZero() {
        return Math.abs(RandomUtility.randomLong());
    }

    public static Long randomLongLessThanZero() {
        return -RandomUtility.randomLongGreaterThanZero().longValue();
    }

    public static Long randomLongGreaterThanZeroByBounds(long lowerBound, long upperBound) {
        return lowerBound + (long)RND.nextInt((int)(upperBound - lowerBound + 1L));
    }

    public static BigDecimal randomBigDecimal() {
        return BigDecimal.valueOf(RandomUtility.randomDouble() * (double)RandomUtility.randomIntegerGreaterThanZeroByBounds(-90, 90).intValue());
    }

    public static BigDecimal randomBigDecimalGreaterThanZero() {
        return BigDecimal.valueOf(RandomUtility.randomDouble() * (double)RandomUtility.randomIntegerGreaterThanZeroByBounds(10, 90).intValue());
    }

    public static BigDecimal randomBigDecimalLessThanZero() {
        return RandomUtility.randomBigDecimalGreaterThanZero().multiply(BigDecimalConstants.MINUS_ONE);
    }

    public static BigDecimal randomBigDecimalGreaterThanZeroByBounds(long lowerBound, long upperBound) {
        Long longValue = RandomUtility.randomLongGreaterThanZeroByBounds(lowerBound, upperBound - 2L);
        BigDecimal delta = BigDecimal.valueOf(RandomUtility.randomDouble()).add(BigDecimal.ONE);
        return new BigDecimal(longValue).add(delta);
    }

    public static BigDecimal randomBigDecimalLessThanZeroByBounds(long lowerBound, long upperBound) {
        return RandomUtility.randomBigDecimalGreaterThanZeroByBounds(lowerBound, upperBound).multiply(BigDecimalConstants.MINUS_ONE);
    }

    public static BigDecimal randomBigDecimalByBounds(long lowerBound, long upperBound) {
        return RandomUtility.randomBoolean() ? RandomUtility.randomBigDecimalGreaterThanZeroByBounds(lowerBound, upperBound) : RandomUtility.randomBigDecimalLessThanZeroByBounds(lowerBound, upperBound);
    }

    public static BigInteger randomBigInteger() {
        return BigInteger.valueOf(RandomUtility.randomIntegerGreaterThanZeroByBounds(-90, 90).intValue());
    }

    public static BigInteger randomBigIntegerGreaterThanZero() {
        return BigInteger.valueOf(RandomUtility.randomLongGreaterThanZero());
    }

    public static BigInteger randomBigIntegerLessThanZero() {
        return BigInteger.valueOf(RandomUtility.randomLongLessThanZero());
    }

    public static BigInteger randomBigIntegerGreaterThanZeroByBounds(long lowerBound, long upperBound) {
        return BigInteger.valueOf(RandomUtility.randomLongGreaterThanZeroByBounds(lowerBound, upperBound));
    }

    public static BigInteger randomBigIntegerLessThanZeroByBounds(long lowerBound, long upperBound) {
        return BigInteger.valueOf(-RandomUtility.randomLongGreaterThanZeroByBounds(lowerBound, upperBound).longValue());
    }

    public static BigInteger randomBigIntegerByBounds(long lowerBound, long upperBound) {
        return RandomUtility.randomBoolean() ? RandomUtility.randomBigIntegerGreaterThanZeroByBounds(lowerBound, upperBound) : RandomUtility.randomBigIntegerLessThanZeroByBounds(lowerBound, upperBound);
    }

    public static String randomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomStringLetterOrNumbersOnly(int size) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < size) {
            Integer index = RandomUtility.randomIntegerGreaterThanZeroByBounds(0, LETTERS_OR_NUMBERS.length() - 1);
            sb.append(LETTERS_OR_NUMBERS.charAt(index));
        }
        return sb.toString();
    }

    public static String randomIPv4() {
        return RND.nextInt(256) + "." + RND.nextInt(256) + "." + RND.nextInt(256) + "." + RND.nextInt(256);
    }

    public static IPAddress randomIPAddress() {
        return new IPAddress(RandomUtility.randomIPv4());
    }

    public static IPAddress localhost() {
        return new IPAddress("127.0.0.1");
    }

    public static String randomServerURL() {
        String ip = RandomUtility.randomIPv4();
        String protocol = RND.nextBoolean() ? "http" : "https";
        int port = 4000 + RND.nextInt(5000);
        return protocol + "://" + ip + ":" + port;
    }

    public static List<String> randomStringsAsList(int size) {
        return IntStream.range(0, size).mapToObj(position -> RandomUtility.randomString()).collect(Collectors.toList());
    }

    public static Set<String> randomStringsAsSet(int size) {
        return IntStream.range(0, size).mapToObj(position -> RandomUtility.randomString()).collect(Collectors.toSet());
    }

    public static String[] randomStringsAsArray(int size) {
        return (String[])IntStream.range(0, size).mapToObj(position -> RandomUtility.randomString()).toArray(String[]::new);
    }

    public static String randomEmail() {
        return RandomUtility.randomString() + "@tech1.io";
    }

    public static <T> T randomElement(List<T> list) {
        int randomIndex = RND.nextInt(list.size());
        return list.get(randomIndex);
    }

    public static <T> T randomElement(Set<T> set) {
        return RandomUtility.randomElement(new ArrayList<T>(set));
    }

    public static LocalDate randomLocalDate() {
        return RandomUtility.randomLocalDateByBounds(2000, LocalDate.now().getYear());
    }

    public static LocalDate randomLocalDateByBounds(int lowerYear, int upperYear) {
        long minDay = LocalDate.of(lowerYear, 1, 1).toEpochDay();
        long maxDay = LocalDate.of(upperYear, 1, 1).toEpochDay();
        Long randomDay = RandomUtility.randomLongGreaterThanZeroByBounds(minDay, maxDay);
        return LocalDate.ofEpochDay(randomDay);
    }

    public static LocalDateTime randomLocalDateTime() {
        return RandomUtility.randomLocalDateTimeByBounds(2000, LocalDate.now().getYear());
    }

    public static LocalDateTime randomLocalDateTimeByBounds(int lowerYear, int upperYear) {
        int minSeconds = 0;
        long maxSeconds = 24L * ChronoUnit.HOURS.getDuration().getSeconds();
        Long randomSeconds = RandomUtility.randomLongGreaterThanZeroByBounds(minSeconds, maxSeconds);
        return LocalDateTime.from(RandomUtility.randomLocalDateByBounds(lowerYear, upperYear).atStartOfDay()).plusSeconds(randomSeconds);
    }

    public static Date randomDate() {
        return Date.from(RandomUtility.randomLocalDateTime().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date randomDateByBounds(int lowerYear, int upperYear) {
        return Date.from(RandomUtility.randomLocalDateTimeByBounds(lowerYear, upperYear).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static <T extends Enum<T>> T randomEnum(Class<T> enumClazz) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        return (T)values[RND.nextInt(values.length)];
    }

    public static <T extends Enum> T randomEnumWildcard(Class<?> enumClazz) {
        ?[] values = enumClazz.getEnumConstants();
        return (T)((Enum)values[RND.nextInt(values.length)]);
    }

    public static <T extends Enum<T>> T randomEnumExcept(Class<T> enumClazz, T enumValue) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        return (T)Stream.of(values).filter(item -> !item.equals(enumValue)).findAny().orElseThrow(() -> new IllegalEnumException(enumClazz));
    }

    public static <T extends Enum> T randomEnumExceptWildcard(Class<?> enumClazz, T enumValue) {
        ?[] values = enumClazz.getEnumConstants();
        return (T)((Enum)Stream.of(values).filter(item -> !item.equals(enumValue)).findAny().orElseThrow(() -> new IllegalEnumException(enumClazz)));
    }

    public static <T extends Enum<T>> T randomEnumExcept(Class<T> enumClazz, List<T> enumValues) {
        Enum[] values = (Enum[])enumClazz.getEnumConstants();
        List collect = Stream.of(values).filter(item -> !enumValues.contains(item)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            throw new IllegalEnumException(enumClazz);
        }
        return (T)((Enum)RandomUtility.randomElement(collect));
    }

    public static <T extends Enum> T randomEnumExceptWildcard(Class<?> enumClazz, List<T> enumValues) {
        ?[] values = enumClazz.getEnumConstants();
        List collect = Stream.of(values).filter(item -> !enumValues.contains(item)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            throw new IllegalEnumException(enumClazz);
        }
        return (T)((Enum)RandomUtility.randomElement(collect));
    }

    public static <T> boolean containsPrimitiveWrapper(Class<T> type) {
        return PRIMITIVE_WRAPPERS.containsKey(type);
    }

    public static <T> List<T> randomListOfPrimitiveWrappers(Class<T> type, int size) {
        if (PRIMITIVE_WRAPPERS.containsKey(type)) {
            Supplier<?> supplier = PRIMITIVE_WRAPPERS.get(type);
            return IntStream.range(0, size).mapToObj(i -> supplier.get()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Method randomMethod() {
        return Object.class.getDeclaredMethods()[0];
    }

    public static ZoneId randomZoneId() {
        return ZoneId.of(RandomUtility.randomElement(ZoneId.getAvailableZoneIds()));
    }

    public static TimeZone randomTimeZone() {
        return TimeZone.getTimeZone(RandomUtility.randomZoneId());
    }

    public static Username randomUsername() {
        return Username.of(RandomUtility.randomString());
    }

    public static Password randomPassword() {
        return Password.of(RandomUtility.randomString());
    }

    public static FeignException randomFeignException() {
        return new FeignException.InternalServerError(RandomUtility.randomString(), Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"/endpoint", Map.of(), (byte[])new byte[0], (Charset)Charset.defaultCharset()), new byte[0]);
    }

    public static GeoLocation validGeoLocation() {
        return GeoLocation.processed(RandomUtility.localhost(), "Ukraine", "Lviv");
    }

    public static GeoLocation invalidGeoLocation() {
        return GeoLocation.unknown(RandomUtility.localhost(), "Location is unknown");
    }

    public static GeoLocation randomGeoLocation() {
        return RandomUtility.randomBoolean() ? RandomUtility.validGeoLocation() : RandomUtility.invalidGeoLocation();
    }

    public static UserAgentDetails validUserAgentDetails() {
        return UserAgentDetails.processed("Chrome", "macOS", "Desktop");
    }

    public static UserAgentDetails invalidUserAgentDetails() {
        return UserAgentDetails.unknown("User agent details are unknown");
    }

    public static UserAgentDetails randomUserAgentDetails() {
        return RandomUtility.randomBoolean() ? RandomUtility.validUserAgentDetails() : RandomUtility.invalidUserAgentDetails();
    }

    public static UserRequestMetadata validUserRequestMetadata() {
        return UserRequestMetadata.processed(RandomUtility.validGeoLocation(), RandomUtility.validUserAgentDetails());
    }

    public static UserRequestMetadata invalidUserRequestMetadata() {
        return UserRequestMetadata.processed(RandomUtility.invalidGeoLocation(), RandomUtility.invalidUserAgentDetails());
    }

    public static UserRequestMetadata randomUserRequestMetadata() {
        return RandomUtility.randomBoolean() ? RandomUtility.validUserRequestMetadata() : RandomUtility.invalidUserRequestMetadata();
    }

    public static HardwareMonitoringThreshold randomHardwareMonitoringThreshold() {
        return new HardwareMonitoringThreshold(RandomUtility.randomBigDecimalGreaterThanZeroByBounds(50L, 100L));
    }

    public static HardwareMonitoringThresholds randomHardwareMonitoringThresholds() {
        Map<HardwareName, BigDecimal> thresholds = Stream.of(HardwareName.values()).collect(Collectors.toMap(entry -> entry, entry -> RandomUtility.randomHardwareMonitoringThreshold().getValue()));
        return new HardwareMonitoringThresholds(thresholds);
    }

    public static HardwareMonitoringDatapointTableRow randomHardwareMonitoringDatapointTableRow() {
        return new HardwareMonitoringDatapointTableRow(RandomUtility.randomEnum(HardwareName.class), RandomUtility.randomLongGreaterThanZero(), RandomUtility.randomBigDecimalGreaterThanZeroByBounds(10L, 20L), RandomUtility.randomString(), RandomUtility.randomHardwareMonitoringThresholds());
    }

    @Generated
    private RandomUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

