/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.reflections;

import io.tech1.framework.domain.base.Password;
import io.tech1.framework.domain.base.Username;
import io.tech1.framework.domain.properties.base.SchedulerConfiguration;
import io.tech1.framework.domain.properties.base.TimeAmount;
import io.tech1.framework.domain.reflections.ReflectionProperty;
import io.tech1.framework.domain.tuples.Tuple2;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.util.StringUtils;

public final class ReflectionUtility {
    public static <T, S> void setPrivateField(T object, String nameField, S valueField) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(nameField);
        field.setAccessible(true);
        field.set(object, valueField);
    }

    public static <T, S> void setPrivateFieldOfSuperClass(T object, String nameField, S valueField, int numberOfSuperClass) throws NoSuchFieldException, IllegalAccessException {
        Class<?> expectedClass = object.getClass();
        for (int i = 0; i < numberOfSuperClass; ++i) {
            expectedClass = expectedClass.getSuperclass();
        }
        Field field = expectedClass.getDeclaredField(nameField);
        field.setAccessible(true);
        field.set(object, valueField);
    }

    public static <T, S> S getPrivateField(T object, String nameField) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(nameField);
        field.setAccessible(true);
        return (S)field.get(object);
    }

    public static <T, S> S getPrivateFieldOfSuperClass(T object, String nameField, int numberOfSuperClass) throws NoSuchFieldException, IllegalAccessException {
        Class<?> expectedClass = object.getClass();
        for (int i = 0; i < numberOfSuperClass; ++i) {
            expectedClass = expectedClass.getSuperclass();
        }
        Field field = expectedClass.getDeclaredField(nameField);
        field.setAccessible(true);
        return (S)field.get(object);
    }

    public static void objectFieldHook(Class<?> type, Object hook, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = type.getDeclaredField(fieldName);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, hook);
    }

    public static void assertFieldsNotNull(Object object) {
        Field[] declaredFields;
        for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            assert (Objects.nonNull(value)) : "Field " + field.getName() + " is null";
        }
    }

    public static <T> List<String> getAllNullFields(T object) {
        Field[] declaredFields = object.getClass().getDeclaredFields();
        ArrayList<String> nullFields = new ArrayList<String>();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                Object o = field.get(object);
                if (!Objects.isNull(o)) continue;
                nullFields.add(field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return nullFields;
    }

    public static List<Method> getGetters(Object object) {
        return Stream.of(object.getClass().getMethods()).filter(method -> !method.getName().equals("getClass")).filter(method -> method.getParameterTypes().length == 0).filter(method -> {
            String methodName = method.getName();
            return methodName.startsWith("get") || methodName.startsWith("is");
        }).collect(Collectors.toList());
    }

    public static List<ReflectionProperty> getNotNullPropertiesRecursively(Object object, String parentKey) {
        Predicate<Object> breakoutClassesPredicate = breakoutObj -> {
            Class<?> clazz = breakoutObj.getClass();
            boolean isArray = clazz.isArray();
            boolean isMap = Map.class.isAssignableFrom(clazz);
            boolean isSet = Set.class.isAssignableFrom(clazz);
            return isArray || isMap || isSet || Username.class.equals(clazz) || Password.class.equals(clazz) || ZoneId.class.equals(clazz) || ChronoUnit.class.equals(clazz) || TimeUnit.class.equals(clazz) || TimeAmount.class.equals(clazz) || SchedulerConfiguration.class.equals(clazz) || String.class.equals(clazz) || Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz) || Short.TYPE.equals(clazz) || Short.class.equals(clazz) || Integer.TYPE.equals(clazz) || Integer.class.equals(clazz) || Long.TYPE.equals(clazz) || Long.class.equals(clazz);
        };
        ArrayList<ReflectionProperty> traversedProperties = new ArrayList<ReflectionProperty>();
        List<ReflectionProperty> properties = ReflectionUtility.getNotNullProperties(object, parentKey);
        properties.forEach(property -> {
            if (breakoutClassesPredicate.test(property.getPropertyValue())) {
                traversedProperties.add((ReflectionProperty)property);
            } else {
                String nestedParentKey = property.getParentPropertyName() + "." + property.getPropertyName();
                traversedProperties.addAll(ReflectionUtility.getNotNullPropertiesRecursively(property.getPropertyValue(), nestedParentKey));
            }
        });
        return traversedProperties;
    }

    public static List<ReflectionProperty> getNotNullProperties(Object object, String parentKey) {
        List<Method> getters = ReflectionUtility.getGetters(object);
        return getters.stream().map(getter -> {
            try {
                String getterName = getter.getName();
                String propertyName = StringUtils.uncapitalize((String)getterName.replaceAll("^get", "").replaceAll("^is", ""));
                Object propertyValue = getter.invoke(object, new Object[0]);
                if (Objects.isNull(propertyValue)) {
                    return null;
                }
                return ReflectionProperty.of(parentKey, propertyName, propertyValue);
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Object getFieldValueOrNull(Object object, Field field, List<Method> getters) {
        Optional<Method> getterOpt = getters.stream().filter(method -> method.getName().equalsIgnoreCase("get" + field.getName())).reduce((a, b) -> {
            throw new IllegalArgumentException("Reflection utility. Multiple getters: " + a + ", " + b);
        });
        if (getterOpt.isPresent()) {
            try {
                Object value = getterOpt.get().invoke(object, new Object[0]);
                return Objects.isNull(value) ? null : value;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new IllegalArgumentException("Reflection utility. Missing getter, field: " + field.getName());
    }

    public static Tuple2<Field, Object> getFieldTuple2(Object object, Field field, List<Method> getters) {
        Object fieldValueOrNull = ReflectionUtility.getFieldValueOrNull(object, field, getters);
        return Tuple2.of(field, fieldValueOrNull);
    }

    @Generated
    private ReflectionUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

