/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.strings;

import lombok.Generated;

public final class MaskUtility {
    public static String mask5(String value) {
        return MaskUtility.mask(value, 5);
    }

    public static String mask8(String value) {
        return MaskUtility.mask(value, 8);
    }

    public static String mask(String value, int length) {
        int valueLength = value.length();
        if (valueLength <= length) {
            return value;
        }
        return value.substring(0, length) + "*".repeat(valueLength - length);
    }

    public static String cut15Mask8(String value) {
        return MaskUtility.cutMask(value, 15, 8);
    }

    public static String cutMask(String value, int cutLength, int maskLength) {
        if (cutLength <= maskLength) {
            throw new IllegalArgumentException("`cutLength`=" + cutLength + " attribute must be greater than `maskLength`=" + maskLength);
        }
        int valueLength = ((String)value).length();
        value = valueLength < cutLength ? (String)value + "*".repeat(cutLength - valueLength) : ((String)value).substring(0, cutLength);
        return MaskUtility.mask((String)value, maskLength);
    }

    @Generated
    private MaskUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

