/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.strings;

import java.util.Objects;
import lombok.Generated;

public final class StringUtility {
    public static boolean isNullOrEmpty(String value) {
        return Objects.isNull(value) || value.isEmpty();
    }

    public static boolean isNullOrBlank(String value) {
        return Objects.isNull(value) || value.isBlank();
    }

    public static boolean hasLength(String value) {
        return Objects.nonNull(value) && !value.isEmpty();
    }

    public static String getShortenValueOrUndefined(String value, int maxLength) {
        if (Objects.isNull(value)) {
            return "[?]";
        }
        if (value.length() <= 3) {
            return value;
        }
        if (maxLength <= 3) {
            maxLength = 3;
        }
        return value.length() > maxLength ? value.substring(0, maxLength - 3) + "..." : value;
    }

    @Generated
    private StringUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

