/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.TimeZone;
import lombok.Generated;

public final class LocalDateTimeUtility {
    public static LocalDateTime nowByTimezone(TimeZone timeZone) {
        return LocalDateTimeUtility.nowByZoneId(timeZone.toZoneId());
    }

    public static LocalDateTime nowByZoneId(ZoneId zoneId) {
        return LocalDateTime.now(zoneId);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        return localDateTime.format(formatter);
    }

    public static LocalDateTime parse(String localDateTime, DateTimeFormatter formatter) {
        return LocalDateTime.parse(localDateTime, formatter);
    }

    public static LocalDateTime convertTimestamp(long timestamp, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static LocalDateTime convertDate(Date date, ZoneId zoneId) {
        return LocalDateTimeUtility.convertTimestamp(date.getTime(), zoneId);
    }

    public static long getTimestamp(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static boolean isParamsEqualsTruncatedBySeconds(LocalDateTime time1, LocalDateTime time2) {
        return LocalDateTimeUtility.isParamsEqualsTruncatedBy(time1, time2, ChronoUnit.SECONDS);
    }

    public static boolean isParamsEqualsTruncatedBy(LocalDateTime time1, LocalDateTime time2, ChronoUnit chronoUnit) {
        LocalDateTime time1Truncated = time1.truncatedTo(chronoUnit);
        LocalDateTime time2Truncated = time2.truncatedTo(chronoUnit);
        return time1Truncated.isEqual(time2Truncated);
    }

    public static boolean isFirstParamAfterTruncatedBySeconds(LocalDateTime time1, LocalDateTime time2) {
        return LocalDateTimeUtility.isFirstParamAfterTruncatedBy(time1, time2, ChronoUnit.SECONDS);
    }

    public static boolean isFirstParamAfterTruncatedBy(LocalDateTime time1, LocalDateTime time2, ChronoUnit chronoUnit) {
        LocalDateTime time1Truncated = time1.truncatedTo(chronoUnit);
        LocalDateTime time2Truncated = time2.truncatedTo(chronoUnit);
        return time1Truncated.isAfter(time2Truncated);
    }

    public static boolean isFirstParamAfterOrEqualTruncatedBySeconds(LocalDateTime time1, LocalDateTime time2) {
        return LocalDateTimeUtility.isFirstParamAfterOrEqualTruncatedBy(time1, time2, ChronoUnit.SECONDS);
    }

    public static boolean isFirstParamAfterOrEqualTruncatedBy(LocalDateTime time1, LocalDateTime time2, ChronoUnit chronoUnit) {
        return LocalDateTimeUtility.isParamsEqualsTruncatedBy(time1, time2, chronoUnit) || LocalDateTimeUtility.isFirstParamAfterTruncatedBy(time1, time2, chronoUnit);
    }

    public static boolean isFirstParamBeforeTruncatedBySeconds(LocalDateTime time1, LocalDateTime time2) {
        return LocalDateTimeUtility.isFirstParamBeforeTruncatedBy(time1, time2, ChronoUnit.SECONDS);
    }

    public static boolean isFirstParamBeforeTruncatedBy(LocalDateTime time1, LocalDateTime time2, ChronoUnit chronoUnit) {
        LocalDateTime time1Truncated = time1.truncatedTo(chronoUnit);
        LocalDateTime time2Truncated = time2.truncatedTo(chronoUnit);
        return time1Truncated.isBefore(time2Truncated);
    }

    public static boolean isFirstParamBeforeOrEqualTruncatedBySeconds(LocalDateTime time1, LocalDateTime time2) {
        return LocalDateTimeUtility.isFirstParamBeforeOrEqualTruncatedBy(time1, time2, ChronoUnit.SECONDS);
    }

    public static boolean isFirstParamBeforeOrEqualTruncatedBy(LocalDateTime time1, LocalDateTime time2, ChronoUnit chronoUnit) {
        return LocalDateTimeUtility.isParamsEqualsTruncatedBy(time1, time2, chronoUnit) || LocalDateTimeUtility.isFirstParamBeforeTruncatedBy(time1, time2, chronoUnit);
    }

    @Generated
    private LocalDateTimeUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

