/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import lombok.Generated;

public final class LocalDateUtility {
    public static LocalDate now(TimeZone timeZone) {
        return LocalDateUtility.now(timeZone.toZoneId());
    }

    public static LocalDate now(ZoneId zoneId) {
        return LocalDate.now(zoneId);
    }

    public static LocalDate convertDate(Date date) {
        return new java.sql.Date(date.getTime()).toLocalDate();
    }

    public static LocalDate convertDate(Date date, ZoneId zoneId) {
        return LocalDate.ofInstant(Instant.ofEpochMilli(date.getTime()), zoneId);
    }

    public static LocalDate getFirstDayCurrentMonth(ZoneId zoneId) {
        return LocalDateUtility.now(zoneId).withDayOfMonth(1);
    }

    public static LocalDate getFirstDayPreviousMonth(ZoneId zoneId) {
        return LocalDateUtility.now(zoneId).minusMonths(1L).withDayOfMonth(1);
    }

    public static LocalDate getFirstDayTwoMonthAgo(ZoneId zoneId) {
        return LocalDateUtility.now(zoneId).minusMonths(2L).withDayOfMonth(1);
    }

    public static LocalDate getFirstDayMonthsAgo(ZoneId zoneId, int months) {
        return LocalDateUtility.now(zoneId).minusMonths(months).withDayOfMonth(1);
    }

    public static LocalDate getLastDayCurrentMonth(ZoneId zoneId) {
        LocalDate now = LocalDateUtility.now(zoneId);
        return now.withDayOfMonth(now.lengthOfMonth());
    }

    public static LocalDate getLastDayPreviousMonth(ZoneId zoneId) {
        LocalDate past = LocalDateUtility.now(zoneId).minusMonths(1L);
        return past.withDayOfMonth(past.lengthOfMonth());
    }

    public static LocalDate getLastDayTwoMonthAgo(ZoneId zoneId) {
        LocalDate past = LocalDateUtility.now(zoneId).minusMonths(2L);
        return past.withDayOfMonth(past.lengthOfMonth());
    }

    public static LocalDate getLastDayMonthsAgo(ZoneId zoneId, int months) {
        LocalDate past = LocalDateUtility.now(zoneId).minusMonths(months);
        return past.withDayOfMonth(past.lengthOfMonth());
    }

    public static boolean isFirstDayOfMonth(LocalDate localDate) {
        return localDate.getDayOfMonth() == 1;
    }

    public static boolean isLastDayOfMonth(LocalDate localDate) {
        return localDate.equals(YearMonth.from(localDate).atEndOfMonth());
    }

    public static int getCurrentDayOfMonth(ZoneId zoneId) {
        return LocalDateUtility.now(zoneId).getDayOfMonth();
    }

    @Generated
    private LocalDateUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

