/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.time;

import io.tech1.framework.domain.time.TimeAmount;
import io.tech1.framework.domain.tuples.Tuple2;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class TimestampUtility {
    public static long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static Tuple2<Long, Long> getPastRange(TimeAmount timeAmount) {
        long currentTimestamp = TimestampUtility.getCurrentTimestamp();
        long past = currentTimestamp - timeAmount.toMillis();
        return Tuple2.of(past, currentTimestamp);
    }

    public static Tuple2<Long, Long> getFutureRange(TimeAmount timeAmount) {
        long currentTimestamp = TimestampUtility.getCurrentTimestamp();
        long future = currentTimestamp + timeAmount.toMillis();
        return Tuple2.of(currentTimestamp, future);
    }

    public static boolean isBetween(long timestamp, long past, long future) {
        return timestamp > past && timestamp < future;
    }

    public static boolean isPast(long timestamp) {
        return TimestampUtility.getCurrentTimestamp() > timestamp;
    }

    public static boolean isFuture(long timestamp) {
        return TimestampUtility.getCurrentTimestamp() < timestamp;
    }

    public static boolean isCurrentTimestampNSecondsMore(long timestamp, long seconds) {
        return TimeUnit.MILLISECONDS.toSeconds(TimestampUtility.getCurrentTimestamp() - timestamp) > seconds;
    }

    @Generated
    private TimestampUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

