/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.emails.configurations;

import io.tech1.framework.domain.properties.configs.AbstractPropertiesConfigs;
import io.tech1.framework.domain.properties.configs.EmailConfigs;
import io.tech1.framework.domain.properties.utilities.PropertiesAsserter;
import io.tech1.framework.emails.services.EmailService;
import io.tech1.framework.emails.services.impl.EmailServiceImpl;
import io.tech1.framework.emails.utilities.EmailUtility;
import io.tech1.framework.emails.utilities.impl.EmailUtilityImpl;
import io.tech1.framework.properties.ApplicationFrameworkProperties;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class ApplicationEmails {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationEmails.class);
    private final ApplicationFrameworkProperties applicationFrameworkProperties;

    @PostConstruct
    public void init() {
        PropertiesAsserter.assertProperties((AbstractPropertiesConfigs)this.applicationFrameworkProperties.getEmailConfigs(), (String)"emailConfigs");
    }

    @Bean
    public JavaMailSender javaMailSender() {
        EmailConfigs emailConfigs = this.applicationFrameworkProperties.getEmailConfigs();
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(emailConfigs.getHost());
        mailSender.setPort(emailConfigs.getPort());
        mailSender.setUsername(emailConfigs.getUsername());
        mailSender.setPassword(emailConfigs.getPassword());
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.debug", "false");
        return mailSender;
    }

    @Bean
    public SpringTemplateEngine springTemplateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.addTemplateResolver((ITemplateResolver)this.htmlTemplateResolver());
        return templateEngine;
    }

    @Bean
    public SpringResourceTemplateResolver htmlTemplateResolver() {
        SpringResourceTemplateResolver emailTemplateResolver = new SpringResourceTemplateResolver();
        emailTemplateResolver.setPrefix("classpath:/email-templates/");
        emailTemplateResolver.setSuffix(".html");
        emailTemplateResolver.setTemplateMode(TemplateMode.HTML);
        emailTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        return emailTemplateResolver;
    }

    @Bean
    public EmailUtility emailUtility() {
        return new EmailUtilityImpl(this.javaMailSender());
    }

    @Bean
    public EmailService emailService() {
        return new EmailServiceImpl(this.javaMailSender(), this.springTemplateEngine(), this.emailUtility(), this.applicationFrameworkProperties);
    }

    @ConstructorProperties(value={"applicationFrameworkProperties"})
    @Autowired
    @Generated
    public ApplicationEmails(ApplicationFrameworkProperties applicationFrameworkProperties) {
        this.applicationFrameworkProperties = applicationFrameworkProperties;
    }
}

