/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.emails.services.impl;

import io.tech1.framework.domain.properties.configs.EmailConfigs;
import io.tech1.framework.domain.tuples.Tuple2;
import io.tech1.framework.emails.domain.EmailHTML;
import io.tech1.framework.emails.domain.EmailPlainAttachment;
import io.tech1.framework.emails.services.EmailService;
import io.tech1.framework.emails.utilities.EmailUtility;
import io.tech1.framework.properties.ApplicationFrameworkProperties;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

public class EmailServiceImpl
implements EmailService {
    private final JavaMailSender javaMailSender;
    private final SpringTemplateEngine springTemplateEngine;
    private final EmailUtility emailUtility;
    private final ApplicationFrameworkProperties applicationFrameworkProperties;

    @Override
    public void sendPlain(String subject, String message) {
        EmailConfigs emailConfigs = this.applicationFrameworkProperties.getEmailConfigs();
        this.sendPlain(emailConfigs.getTo(), subject, message);
    }

    @Override
    public void sendPlain(String[] to, String subject, String message) {
        EmailConfigs emailConfigs = this.applicationFrameworkProperties.getEmailConfigs();
        if (emailConfigs.isEnabled()) {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setFrom(emailConfigs.getFrom());
            mailMessage.setTo(to);
            mailMessage.setSubject(subject);
            mailMessage.setText(message);
            this.javaMailSender.send(mailMessage);
        }
    }

    @Override
    public void sendPlain(List<String> to, String subject, String message) {
        this.sendPlain(to.toArray(new String[0]), subject, message);
    }

    @Override
    public void sendPlain(Set<String> to, String subject, String message) {
        this.sendPlain(to.toArray(new String[0]), subject, message);
    }

    @Override
    public void sendPlainAttachment(EmailPlainAttachment emailPlainAttachment) {
        EmailConfigs emailConfigs = this.applicationFrameworkProperties.getEmailConfigs();
        if (emailConfigs.isEnabled()) {
            try {
                MimeMessage message = this.javaMailSender.createMimeMessage();
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart part1 = new MimeBodyPart();
                part1.setText(emailPlainAttachment.getMessage());
                multipart.addBodyPart((BodyPart)part1);
                MimeBodyPart part2 = new MimeBodyPart();
                ByteArrayDataSource source = new ByteArrayDataSource(emailPlainAttachment.getAttachmentMessage(), "text/plain; charset=UTF-8");
                part2.setDataHandler(new DataHandler((DataSource)source));
                part2.setFileName(emailPlainAttachment.getAttachmentFileName());
                multipart.addBodyPart((BodyPart)part2);
                message.setFrom(emailConfigs.getFrom());
                for (String to : emailPlainAttachment.getTo()) {
                    message.addRecipients(Message.RecipientType.TO, to);
                }
                message.setSubject(emailPlainAttachment.getSubject());
                message.setContent((Multipart)multipart);
                this.javaMailSender.send(message);
            }
            catch (IOException | MessagingException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendHTML(EmailHTML emailHTML) {
        EmailConfigs emailConfigs = this.applicationFrameworkProperties.getEmailConfigs();
        if (emailConfigs.isEnabled()) {
            try {
                Tuple2<MimeMessage, MimeMessageHelper> tuple2 = this.emailUtility.getMimeMessageTuple2();
                MimeMessage message = (MimeMessage)tuple2.getA();
                MimeMessageHelper mmHelper = (MimeMessageHelper)tuple2.getB();
                mmHelper.setFrom(emailConfigs.getFrom());
                mmHelper.setTo(emailHTML.getTo().toArray(new String[0]));
                mmHelper.setSubject(emailHTML.getSubject());
                Context context = new Context();
                context.setVariables(emailHTML.getTemplateVariables());
                String processedHTML = this.springTemplateEngine.process(emailHTML.getTemplateName(), (IContext)context);
                mmHelper.setText(processedHTML, true);
                this.javaMailSender.send(message);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    @ConstructorProperties(value={"javaMailSender", "springTemplateEngine", "emailUtility", "applicationFrameworkProperties"})
    @Autowired
    @Generated
    public EmailServiceImpl(JavaMailSender javaMailSender, SpringTemplateEngine springTemplateEngine, EmailUtility emailUtility, ApplicationFrameworkProperties applicationFrameworkProperties) {
        this.javaMailSender = javaMailSender;
        this.springTemplateEngine = springTemplateEngine;
        this.emailUtility = emailUtility;
        this.applicationFrameworkProperties = applicationFrameworkProperties;
    }
}

