/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.metadata;

import io.temporal.common.metadata.POJOWorkflowInterfaceMetadata;
import io.temporal.common.metadata.POJOWorkflowMethodMetadata;
import io.temporal.common.metadata.WorkflowMethodType;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0015\u0010\u0006\u001a\u00020\u0001\"\n\b\u0000\u0010\u0007\u0018\u0001*\u00020\bH\u0086\b\u001a\u0012\u0010\u0006\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u001a\u0012\u0010\u000b\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\f\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a8\u0006\r"}, d2={"workflowMethodName", "", "method", "Lkotlin/reflect/KFunction;", "type", "Lio/temporal/common/metadata/WorkflowMethodType;", "workflowName", "T", "", "workflowClass", "Ljava/lang/Class;", "workflowQueryType", "workflowSignalName", "temporal-kotlin"})
public final class WorkflowMetadataKt {
    @NotNull
    public static final String workflowName(@NotNull Class<?> workflowClass) {
        POJOWorkflowInterfaceMetadata workflowInterfaceMetadata;
        Intrinsics.checkNotNullParameter(workflowClass, (String)"workflowClass");
        POJOWorkflowInterfaceMetadata pOJOWorkflowInterfaceMetadata = workflowInterfaceMetadata = POJOWorkflowInterfaceMetadata.newInstance(workflowClass);
        Intrinsics.checkNotNullExpressionValue((Object)pOJOWorkflowInterfaceMetadata, (String)"workflowInterfaceMetadata");
        String string = pOJOWorkflowInterfaceMetadata.getWorkflowType().orElse(null);
        if (string == null) {
            throw (Throwable)new IllegalArgumentException(workflowClass + " does not define a workflow method");
        }
        return string;
    }

    public static final /* synthetic */ <T> String workflowName() {
        int $i$f$workflowName = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return WorkflowMetadataKt.workflowName(Object.class);
    }

    @NotNull
    public static final String workflowSignalName(@NotNull KFunction<?> method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        return WorkflowMetadataKt.workflowMethodName(method, WorkflowMethodType.SIGNAL);
    }

    @NotNull
    public static final String workflowQueryType(@NotNull KFunction<?> method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        return WorkflowMetadataKt.workflowMethodName(method, WorkflowMethodType.QUERY);
    }

    private static final String workflowMethodName(KFunction<?> method, WorkflowMethodType type) {
        Object v4;
        block4: {
            POJOWorkflowInterfaceMetadata interfaceMetadata;
            Method method2 = ReflectJvmMapping.getJavaMethod(method);
            if (method2 == null) {
                throw (Throwable)new IllegalArgumentException("Invalid method reference " + method);
            }
            Method javaMethod = method2;
            POJOWorkflowInterfaceMetadata pOJOWorkflowInterfaceMetadata = interfaceMetadata = POJOWorkflowInterfaceMetadata.newInstance(javaMethod.getDeclaringClass());
            Intrinsics.checkNotNullExpressionValue((Object)pOJOWorkflowInterfaceMetadata, (String)"interfaceMetadata");
            List list = pOJOWorkflowInterfaceMetadata.getMethodsMetadata();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"interfaceMetadata.methodsMetadata");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                POJOWorkflowMethodMetadata it = (POJOWorkflowMethodMetadata)t;
                boolean bl3 = false;
                POJOWorkflowMethodMetadata pOJOWorkflowMethodMetadata = it;
                Intrinsics.checkNotNullExpressionValue((Object)pOJOWorkflowMethodMetadata, (String)"it");
                if (!Intrinsics.areEqual((Object)pOJOWorkflowMethodMetadata.getWorkflowMethod(), (Object)javaMethod)) continue;
                v4 = t;
                break block4;
            }
            v4 = null;
        }
        POJOWorkflowMethodMetadata pOJOWorkflowMethodMetadata = v4;
        if (pOJOWorkflowMethodMetadata == null) {
            throw (Throwable)new IllegalArgumentException("Not a workflow method reference " + method);
        }
        POJOWorkflowMethodMetadata methodMetadata = pOJOWorkflowMethodMetadata;
        if (methodMetadata.getType() != type) {
            throw (Throwable)new IllegalArgumentException("Workflow method " + method + " is not of expected type " + type);
        }
        String string = methodMetadata.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodMetadata.name");
        return string;
    }
}

