/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.codec;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.payload.codec.PayloadCodec;
import io.temporal.payload.codec.PayloadCodecException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractRemoteDataEncoderCodec
implements PayloadCodec {
    public static final String ENCODE_PATH_POSTFIX = "/encode";
    public static final String DECODE_PATH_POSTFIX = "/decode";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final JsonFormat.Parser JSON_FORMAT = JsonFormat.parser();
    public static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer();
    private final String rdeEncodeUrl;
    private final String rdeDecodeUrl;

    public AbstractRemoteDataEncoderCodec(String rdeUrl) {
        this.rdeEncodeUrl = rdeUrl + ENCODE_PATH_POSTFIX;
        this.rdeDecodeUrl = rdeUrl + DECODE_PATH_POSTFIX;
    }

    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        return this.transform(payloads, this.rdeEncodeUrl);
    }

    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        return this.transform(payloads, this.rdeDecodeUrl);
    }

    protected List<Payload> transform(@Nonnull List<Payload> payloads, String url) {
        List list;
        block8: {
            Payloads outgoingPayloads = Payloads.newBuilder().addAllPayloads(payloads).build();
            String json = JSON_PRINTER.print((MessageOrBuilder)outgoingPayloads);
            Reader reader = this.performPost(url, json);
            try {
                Payloads.Builder incomingPayloads = Payloads.newBuilder();
                JSON_FORMAT.merge(reader, (Message.Builder)incomingPayloads);
                list = incomingPayloads.getPayloadsList();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PayloadCodecException((Throwable)e);
                }
            }
            reader.close();
        }
        return list;
    }

    protected abstract Reader performPost(String var1, String var2) throws IOException;
}

