/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.payload.codec;

import io.temporal.payload.codec.AbstractRemoteDataEncoderCodec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpRemoteDataEncoderCodec
extends AbstractRemoteDataEncoderCodec {
    private final OkHttpClient client;

    public OkHttpRemoteDataEncoderCodec(OkHttpClient client, String rdeUrl) {
        super(rdeUrl);
        this.client = client;
    }

    @Override
    protected Reader performPost(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        if (response.code() == 200) {
            if (response.body() != null) {
                return new InputStreamReader(response.body().byteStream());
            }
            throw new IOException("Remote Data Encoder response body is empty. Response: " + response);
        }
        throw new IOException("Remote Data Encoder response status code is not 200 OK. Response: " + response);
    }
}

