/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.rde.httpserver;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.temporal.api.common.v1.Payloads;
import io.temporal.payload.codec.AbstractRemoteDataEncoderCodec;
import io.temporal.payload.codec.ChainCodec;
import io.temporal.payload.codec.PayloadCodec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;

class DataEncoderHandler
implements HttpHandler {
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private final PayloadCodec codec;

    public DataEncoderHandler(List<PayloadCodec> codecs) {
        this.codec = new ChainCodec(codecs);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        switch (exchange.getRequestMethod()) {
            case "POST": {
                this.handlePost(exchange);
                break;
            }
            case "OPTIONS": {
                this.handleOptions(exchange);
                break;
            }
            default: {
                exchange.sendResponseHeaders(405, -1L);
            }
        }
        exchange.close();
    }

    private void handleOptions(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().add(ACCESS_CONTROL_ALLOW_METHODS, "POST, OPTIONS");
        exchange.getResponseHeaders().add(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        exchange.getResponseHeaders().add(ACCESS_CONTROL_ALLOW_HEADERS, "*");
        exchange.sendResponseHeaders(204, -1L);
    }

    private void handlePost(HttpExchange exchange) throws IOException {
        boolean encode;
        String contentType = exchange.getRequestHeaders().getFirst("Content-Type");
        if (contentType == null || !contentType.startsWith("application/json")) {
            exchange.sendResponseHeaders(415, -1L);
            return;
        }
        String path = exchange.getRequestURI().getPath();
        if (path.endsWith("/encode")) {
            encode = true;
        } else if (path.endsWith("/decode")) {
            encode = false;
        } else {
            exchange.sendResponseHeaders(404, -1L);
            return;
        }
        Payloads.Builder incomingPayloads = Payloads.newBuilder();
        try (InputStreamReader ioReader = new InputStreamReader(exchange.getRequestBody());){
            AbstractRemoteDataEncoderCodec.JSON_FORMAT.merge((Reader)ioReader, (Message.Builder)incomingPayloads);
        }
        catch (IOException e) {
            exchange.sendResponseHeaders(400, -1L);
            return;
        }
        List incomingPayloadsList = incomingPayloads.build().getPayloadsList();
        List outgoingPayloadsList = encode ? this.codec.encode(incomingPayloadsList) : this.codec.decode(incomingPayloadsList);
        exchange.getResponseHeaders().add("Content-Type", "application/json");
        exchange.getResponseHeaders().add(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
            AbstractRemoteDataEncoderCodec.JSON_PRINTER.appendTo((MessageOrBuilder)Payloads.newBuilder().addAllPayloads((Iterable)outgoingPayloadsList).build(), (Appendable)out);
        }
    }
}

