/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.rde.httpserver;

import com.google.common.base.Preconditions;
import com.sun.net.httpserver.HttpServer;
import io.temporal.payload.codec.PayloadCodec;
import io.temporal.rde.httpserver.DataEncoderHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;

public class RDEHttpServer
implements Closeable {
    private final List<PayloadCodec> codecs;
    private final int port;
    private HttpServer server;

    public RDEHttpServer(List<PayloadCodec> codecs) {
        this(codecs, -1);
    }

    public RDEHttpServer(List<PayloadCodec> codecs, int port) {
        this.codecs = codecs;
        this.port = port;
    }

    public synchronized void start() throws IOException {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0, (Object)"Server already started");
        this.server = this.port > 0 ? HttpServer.create(new InetSocketAddress(this.port), 0) : HttpServer.create();
        this.server.createContext("/encode", new DataEncoderHandler(this.codecs));
        this.server.createContext("/decode", new DataEncoderHandler(this.codecs));
        this.server.setExecutor(null);
        this.server.start();
    }

    public int getPort() {
        return this.server != null ? this.server.getAddress().getPort() : this.port;
    }

    @Override
    public synchronized void close() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }
}

