/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.rde.servlet;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import io.temporal.api.common.v1.Payloads;
import io.temporal.payload.codec.AbstractRemoteDataEncoderCodec;
import io.temporal.payload.codec.ChainCodec;
import io.temporal.payload.codec.PayloadCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RDEServlet4
extends HttpServlet {
    private final PayloadCodec codec;

    public RDEServlet4(List<PayloadCodec> codecs) {
        this.codec = new ChainCodec(codecs);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean encode;
        if (!request.getMethod().equals("POST")) {
            response.sendError(405, "Only POST is allowed");
            return;
        }
        String contentType = request.getContentType();
        if (contentType == null || !contentType.startsWith("application/json")) {
            response.sendError(415, "Unsupported content type, application/json is expected");
            return;
        }
        String path = request.getRequestURI();
        if (path.endsWith("/encode")) {
            encode = true;
        } else if (path.endsWith("/decode")) {
            encode = false;
        } else {
            response.sendError(404, "Path should end with /encode or /decode");
            return;
        }
        Payloads.Builder incomingPayloads = Payloads.newBuilder();
        ServletInputStream inputStream = request.getInputStream();
        try (InputStreamReader ioReader = new InputStreamReader((InputStream)inputStream);){
            AbstractRemoteDataEncoderCodec.JSON_FORMAT.merge((Reader)ioReader, (Message.Builder)incomingPayloads);
        }
        catch (InvalidProtocolBufferException e) {
            response.sendError(400, e.getMessage());
            return;
        }
        List incomingPayloadsList = incomingPayloads.build().getPayloadsList();
        List outgoingPayloadsList = encode ? this.codec.encode(incomingPayloadsList) : this.codec.decode(incomingPayloadsList);
        response.addHeader("Content-Type", "application/json");
        response.setStatus(200);
        ServletOutputStream outputStream = response.getOutputStream();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream);){
            AbstractRemoteDataEncoderCodec.JSON_PRINTER.appendTo((MessageOrBuilder)Payloads.newBuilder().addAllPayloads((Iterable)outgoingPayloadsList).build(), (Appendable)out);
        }
    }
}

