/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.EncodingKeys;
import io.temporal.common.converter.PayloadConverter;
import java.lang.reflect.Type;
import java.util.Optional;

public final class ByteArrayPayloadConverter
implements PayloadConverter {
    @Override
    public String getEncodingType() {
        return "binary/plain";
    }

    @Override
    public Optional<Payload> toData(Object value) throws DataConverterException {
        if (!(value instanceof byte[])) {
            return Optional.empty();
        }
        return Optional.of(Payload.newBuilder().putMetadata("encoding", EncodingKeys.METADATA_ENCODING_RAW).setData(ByteString.copyFrom((byte[])((byte[])value))).build());
    }

    @Override
    public <T> T fromData(Payload content, Class<T> valueClass, Type valueType) throws DataConverterException {
        ByteString data = content.getData();
        if (valueClass != byte[].class) {
            throw new IllegalArgumentException("Raw encoding can be deserialized only to a byte array. valueClass=" + valueClass.getName());
        }
        return (T)data.toByteArray();
    }
}

