/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.internal.statemachines.EntityStateMachine;
import io.temporal.internal.statemachines.WorkflowStateMachines;
import java.util.Objects;

class CancellableCommand {
    private final Command command;
    private final EntityStateMachine entityStateMachine;
    private boolean canceled;

    public CancellableCommand(Command command, EntityStateMachine entityStateMachine) {
        this.command = Objects.requireNonNull(command);
        this.entityStateMachine = Objects.requireNonNull(entityStateMachine);
    }

    public Command getCommand() {
        if (this.canceled) {
            throw new IllegalStateException("canceled");
        }
        return this.command;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    public EntityStateMachine getStateMachine() {
        return this.entityStateMachine;
    }

    public CommandType getCommandType() {
        return this.command.getCommandType();
    }

    public void handleCommand(CommandType commandType) {
        if (!this.canceled) {
            this.entityStateMachine.handleCommand(commandType);
        }
    }

    public WorkflowStateMachines.HandleEventStatus handleEvent(HistoryEvent event, boolean hasNextEvent) {
        if (this.canceled) {
            return WorkflowStateMachines.HandleEventStatus.NON_MATCHING_EVENT;
        }
        return this.entityStateMachine.handleEvent(event, hasNextEvent);
    }

    public String toString() {
        return "CancellableCommand{command=" + this.command + ", canceled=" + this.canceled + '}';
    }

    public void handleWorkflowTaskStarted() {
        this.entityStateMachine.handleWorkflowTaskStarted();
    }
}

