/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.FailWorkflowExecutionCommandAttributes;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;

final class FailWorkflowStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, FailWorkflowStateMachine> {
    private final FailWorkflowExecutionCommandAttributes failWorkflowAttributes;
    public static final StateMachineDefinition<State, ExplicitEvent, FailWorkflowStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("FailWorkflow", State.CREATED, State.FAIL_WORKFLOW_COMMAND_RECORDED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.FAIL_WORKFLOW_COMMAND_CREATED, FailWorkflowStateMachine::createFailWorkflowCommand).add(State.FAIL_WORKFLOW_COMMAND_CREATED, CommandType.COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION, State.FAIL_WORKFLOW_COMMAND_CREATED).add(State.FAIL_WORKFLOW_COMMAND_CREATED, EventType.EVENT_TYPE_WORKFLOW_EXECUTION_FAILED, State.FAIL_WORKFLOW_COMMAND_RECORDED);

    public static void newInstance(Failure failure, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        FailWorkflowExecutionCommandAttributes attributes = FailWorkflowExecutionCommandAttributes.newBuilder().setFailure(failure).build();
        new FailWorkflowStateMachine(attributes, commandSink, stateMachineSink);
    }

    private FailWorkflowStateMachine(FailWorkflowExecutionCommandAttributes failWorkflowAttributes, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.failWorkflowAttributes = failWorkflowAttributes;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    private void createFailWorkflowCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION).setFailWorkflowExecutionCommandAttributes(this.failWorkflowAttributes).build());
    }

    static enum State {
        CREATED,
        FAIL_WORKFLOW_COMMAND_CREATED,
        FAIL_WORKFLOW_COMMAND_RECORDED;

    }

    static enum ExplicitEvent {
        SCHEDULE;

    }
}

