/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.activity.LocalActivityOptions;
import io.temporal.common.MethodRetry;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.LocalActivityStubImpl;
import io.temporal.workflow.ActivityStub;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Function;

class LocalActivityInvocationHandler
extends ActivityInvocationHandlerBase {
    private final LocalActivityOptions options;
    private final WorkflowOutboundCallsInterceptor activityExecutor;

    static InvocationHandler newInstance(Class<?> activityInterface, LocalActivityOptions options, WorkflowOutboundCallsInterceptor activityExecutor) {
        return new LocalActivityInvocationHandler(activityInterface, activityExecutor, options);
    }

    private LocalActivityInvocationHandler(Class<?> activityInterface, WorkflowOutboundCallsInterceptor activityExecutor, LocalActivityOptions options) {
        this.options = options;
        this.activityExecutor = activityExecutor;
        this.init(activityInterface);
    }

    @Override
    protected Function<Object[], Object> getActivityFunc(Method method, MethodRetry methodRetry, String activityName) {
        LocalActivityOptions mergedOptions = LocalActivityOptions.newBuilder(this.options).setMethodRetry(methodRetry).validateAndBuildWithDefaults();
        ActivityStub stub = LocalActivityStubImpl.newInstance(mergedOptions, this.activityExecutor);
        Function<Object[], Object> function = a -> stub.execute(activityName, method.getReturnType(), method.getGenericReturnType(), a);
        return function;
    }
}

