/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Objects;
import io.temporal.activity.ActivityInterface;
import io.temporal.activity.ActivityMethod;
import io.temporal.internal.sync.POJOActivityMethodMetadata;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class POJOActivityInterfaceMetadata {
    private final Map<Method, POJOActivityMethodMetadata> methods = new HashMap<Method, POJOActivityMethodMetadata>();

    public static POJOActivityInterfaceMetadata newInstance(Class<?> anInterface) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("Interface expected: " + anInterface);
        }
        ActivityInterface annotation = anInterface.getAnnotation(ActivityInterface.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Missing required @ActivityInterface annotation: " + anInterface);
        }
        POJOActivityInterfaceMetadata.validateModifierAccess(anInterface);
        POJOActivityInterfaceMetadata result = new POJOActivityInterfaceMetadata(anInterface);
        if (result.methods.isEmpty()) {
            throw new IllegalArgumentException("Interface doesn't contain any methods: " + anInterface.getName());
        }
        return result;
    }

    private static void validateModifierAccess(Class<?> current) {
        if (!Modifier.isPublic(current.getModifiers())) {
            throw new IllegalArgumentException("Interface with @ActivityInterface annotation must be public: " + current);
        }
    }

    static POJOActivityInterfaceMetadata newImplementationInterface(Class<?> anInterface) {
        return new POJOActivityInterfaceMetadata(anInterface);
    }

    private POJOActivityInterfaceMetadata(Class<?> anInterface) {
        if (!anInterface.isInterface()) {
            throw new IllegalArgumentException("not an interface: " + anInterface);
        }
        HashMap<EqualsByMethodName, POJOActivityMethodMetadata> dedupeMap = new HashMap<EqualsByMethodName, POJOActivityMethodMetadata>();
        this.getActivityInterfaceMethods(anInterface, dedupeMap);
    }

    public List<POJOActivityMethodMetadata> getMethodsMetadata() {
        return new ArrayList<POJOActivityMethodMetadata>(this.methods.values());
    }

    public POJOActivityMethodMetadata getMethodMetadata(Method method) {
        POJOActivityMethodMetadata result = this.methods.get(method);
        if (result == null) {
            throw new IllegalArgumentException("Unknown method: " + method);
        }
        return result;
    }

    private Set<Method> getActivityInterfaceMethods(Class<?> current, Map<EqualsByMethodName, POJOActivityMethodMetadata> dedupeMap) {
        ActivityInterface annotation = current.getAnnotation(ActivityInterface.class);
        if (annotation != null) {
            POJOActivityInterfaceMetadata.validateModifierAccess(current);
        }
        HashSet<Method> result = new HashSet<Method>();
        Class<?>[] interfaces = current.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            Set<Method> parentMethods = this.getActivityInterfaceMethods(anInterface, dedupeMap);
            for (Method parentMethod : parentMethods) {
                ActivityMethod activityMethod = parentMethod.getAnnotation(ActivityMethod.class);
                if (activityMethod == null) {
                    try {
                        current.getDeclaredMethod(parentMethod.getName(), parentMethod.getParameterTypes());
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                result.add(parentMethod);
            }
        }
        Method[] declaredMethods = current.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            result.add(declaredMethod);
        }
        if (annotation == null) {
            return result;
        }
        for (Method method : result) {
            POJOActivityMethodMetadata methodMetadata;
            EqualsByMethodName wrapped = new EqualsByMethodName(method);
            POJOActivityMethodMetadata registered = dedupeMap.put(wrapped, methodMetadata = new POJOActivityMethodMetadata(method, current, annotation));
            if (registered != null) {
                throw new IllegalArgumentException("Duplicated methods (overloads are not allowed in activity interfaces): \"" + registered.getMethod() + " through \"" + registered.getInterfaceType() + "\" and \"" + methodMetadata.getMethod() + "\" through \"" + methodMetadata.getInterfaceType() + "\"");
            }
            this.methods.put(method, methodMetadata);
        }
        return Collections.emptySet();
    }

    static class EqualsByMethodName {
        private final Method method;

        EqualsByMethodName(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualsByMethodName that = (EqualsByMethodName)o;
            return Objects.equal((Object)this.method.getName(), (Object)that.method.getName());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method.getName()});
        }
    }
}

