/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.util.concurrent.RateLimiter;
import io.temporal.common.context.ContextPropagator;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.context.ContextThreadLocal;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.CancellationScopeImpl;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.internal.sync.DeterministicRunnerImpl;
import io.temporal.internal.sync.Status;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowRejectedExecutionError;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.sync.WorkflowThreadContext;
import io.temporal.internal.sync.WorkflowThreadLocalInternal;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class WorkflowThreadImpl
implements WorkflowThread {
    private static final RateLimiter metricsRateLimiter = RateLimiter.create((double)1.0);
    private static final Logger log = LoggerFactory.getLogger(WorkflowThreadImpl.class);
    private final ExecutorService threadPool;
    private final WorkflowThreadContext context;
    private final WorkflowExecutorCache cache;
    private final DeterministicRunnerImpl runner;
    private final RunnableWrapper task;
    private final int priority;
    private Thread thread;
    private Future<?> taskFuture;
    private final Map<WorkflowThreadLocalInternal<?>, Object> threadLocalMap = new HashMap();

    WorkflowThreadImpl(ExecutorService threadPool, DeterministicRunnerImpl runner, String name, int priority, boolean detached, CancellationScopeImpl parentCancellationScope, Runnable runnable, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
        this.threadPool = threadPool;
        this.runner = runner;
        this.context = new WorkflowThreadContext(runner.getLock());
        this.cache = cache;
        this.priority = priority;
        if (name == null) {
            name = "workflow-" + super.hashCode();
        }
        this.task = new RunnableWrapper(this.context, runner.getWorkflowContext().getContext(), name, detached, parentCancellationScope, runnable, contextPropagators, propagatedContexts);
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("not used");
    }

    @Override
    public boolean isDetached() {
        return this.task.cancellationScope.isDetached();
    }

    @Override
    public void cancel() {
        this.task.cancellationScope.cancel();
    }

    @Override
    public void cancel(String reason) {
        this.task.cancellationScope.cancel(reason);
    }

    @Override
    public String getCancellationReason() {
        return this.task.cancellationScope.getCancellationReason();
    }

    @Override
    public boolean isCancelRequested() {
        return this.task.cancellationScope.isCancelRequested();
    }

    @Override
    public Promise<String> getCancellationRequest() {
        return this.task.cancellationScope.getCancellationRequest();
    }

    @Override
    public void start() {
        if (this.context.getStatus() != Status.CREATED) {
            throw new IllegalThreadStateException("already started");
        }
        this.context.setStatus(Status.RUNNING);
        if (metricsRateLimiter.tryAcquire(1)) {
            this.getWorkflowContext().getMetricsScope().gauge("temporal_workflow_active_thread_count").update((double)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        }
        while (true) {
            try {
                this.taskFuture = this.threadPool.submit(this.task);
                return;
            }
            catch (RejectedExecutionException e) {
                this.getWorkflowContext().getMetricsScope().counter("temporal_sticky_cache_thread_forced_eviction").inc(1L);
                if (this.cache != null) {
                    SyncWorkflowContext workflowContext;
                    ReplayWorkflowContext context;
                    boolean evicted;
                    if (evicted = this.cache.evictAnyNotInProcessing((context = (workflowContext = this.runner.getWorkflowContext()).getContext()).getWorkflowExecution(), workflowContext.getMetricsScope())) continue;
                    throw new WorkflowRejectedExecutionError(e);
                }
                throw new WorkflowRejectedExecutionError(e);
            }
            break;
        }
    }

    @Override
    public boolean isStarted() {
        return this.context.getStatus() != Status.CREATED;
    }

    public WorkflowThreadContext getContext() {
        return this.context;
    }

    @Override
    public DeterministicRunnerImpl getRunner() {
        return this.runner;
    }

    @Override
    public SyncWorkflowContext getWorkflowContext() {
        return this.runner.getWorkflowContext();
    }

    @Override
    public void setName(String name) {
        this.task.setName(name);
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public long getId() {
        return this.hashCode();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean runUntilBlocked(long deadlockDetectionTimeout) {
        if (this.taskFuture == null) {
            this.start();
        }
        return this.context.runUntilBlocked(deadlockDetectionTimeout);
    }

    @Override
    public boolean isDone() {
        return this.context.isDone();
    }

    public Thread.State getState() {
        if (this.context.getStatus() == Status.YIELDED) {
            return Thread.State.BLOCKED;
        }
        if (this.context.getStatus() == Status.DONE) {
            return Thread.State.TERMINATED;
        }
        return Thread.State.RUNNABLE;
    }

    @Override
    public Throwable getUnhandledException() {
        return this.context.getUnhandledException();
    }

    public void evaluateInCoroutineContext(Functions.Proc1<String> function) {
        this.context.evaluateInCoroutineContext(function);
    }

    @Override
    public Future<?> stopNow() {
        if (this.thread == Thread.currentThread()) {
            throw new Error("Cannot call destroy on itself: " + this.thread.getName());
        }
        this.context.destroy();
        if (!this.context.isDone()) {
            throw new RuntimeException("Couldn't destroy the thread. The blocked thread stack trace: " + this.getStackTrace());
        }
        if (this.taskFuture == null) {
            return this.getCompletedFuture();
        }
        return this.taskFuture;
    }

    private Future<?> getCompletedFuture() {
        CompletableFuture<String> f = new CompletableFuture<String>();
        f.complete("done");
        return f;
    }

    @Override
    public void addStackTrace(StringBuilder result) {
        result.append(this.getName());
        if (this.thread == null) {
            result.append("(NEW)");
            return;
        }
        result.append(": (BLOCKED on ").append(this.getContext().getYieldReason()).append(")\n");
        int omitTop = 5;
        int omitBottom = 7;
        if ("workflow-method".equals(this.getName())) {
            omitBottom = 11;
        }
        StackTraceElement[] stackTrace = this.thread.getStackTrace();
        for (int i = omitTop; i < stackTrace.length - omitBottom; ++i) {
            StackTraceElement e = stackTrace[i];
            if (i == omitTop && "await".equals(e.getMethodName())) continue;
            result.append(e);
            result.append("\n");
        }
    }

    @Override
    public void yield(String reason, Supplier<Boolean> unblockCondition) {
        this.context.yield(reason, unblockCondition);
    }

    @Override
    public <R> void exitThread(R value) {
        this.runner.exit(value);
        throw new DestroyWorkflowThreadError("exit");
    }

    @Override
    public <T> void setThreadLocal(WorkflowThreadLocalInternal<T> key, T value) {
        this.threadLocalMap.put(key, value);
    }

    @Override
    public <T> Optional<T> getThreadLocal(WorkflowThreadLocalInternal<T> key) {
        if (!this.threadLocalMap.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(this.threadLocalMap.get(key));
    }

    @Override
    public String getStackTrace() {
        StackTraceElement[] st = this.task.getStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement se : st) {
            pw.println("\tat " + se);
        }
        return sw.toString();
    }

    static class YieldWithTimeoutCondition
    implements Supplier<Boolean> {
        private final Supplier<Boolean> unblockCondition;
        private final long blockedUntil;
        private boolean timedOut;

        YieldWithTimeoutCondition(Supplier<Boolean> unblockCondition, long blockedUntil) {
            this.unblockCondition = unblockCondition;
            this.blockedUntil = blockedUntil;
        }

        boolean isTimedOut() {
            return this.timedOut;
        }

        @Override
        public Boolean get() {
            boolean result = this.unblockCondition.get();
            if (result) {
                return true;
            }
            long currentTimeMillis = WorkflowInternal.currentTimeMillis();
            this.timedOut = currentTimeMillis >= this.blockedUntil;
            return this.timedOut;
        }
    }

    class RunnableWrapper
    implements Runnable {
        private final WorkflowThreadContext threadContext;
        private final ReplayWorkflowContext replayWorkflowContext;
        private String originalName;
        private String name;
        private final CancellationScopeImpl cancellationScope;
        private final List<ContextPropagator> contextPropagators;
        private final Map<String, Object> propagatedContexts;

        RunnableWrapper(WorkflowThreadContext threadContext, ReplayWorkflowContext replayWorkflowContext, String name, boolean detached, CancellationScopeImpl parent, Runnable runnable, List<ContextPropagator> contextPropagators, Map<String, Object> propagatedContexts) {
            this.threadContext = threadContext;
            this.replayWorkflowContext = replayWorkflowContext;
            this.name = name;
            this.cancellationScope = new CancellationScopeImpl(detached, runnable, parent);
            if (WorkflowThreadImpl.this.context.getStatus() != Status.CREATED) {
                throw new IllegalStateException("threadContext not in CREATED state");
            }
            this.contextPropagators = contextPropagators;
            this.propagatedContexts = propagatedContexts;
        }

        @Override
        public void run() {
            WorkflowThreadImpl.this.thread = Thread.currentThread();
            this.threadContext.setCurrentThread(WorkflowThreadImpl.this.thread);
            this.originalName = WorkflowThreadImpl.this.thread.getName();
            WorkflowThreadImpl.this.thread.setName(this.name);
            DeterministicRunnerImpl.setCurrentThreadInternal(WorkflowThreadImpl.this);
            MDC.put((String)"WorkflowId", (String)this.replayWorkflowContext.getWorkflowId());
            MDC.put((String)"WorkflowType", (String)this.replayWorkflowContext.getWorkflowType().getName());
            MDC.put((String)"RunId", (String)this.replayWorkflowContext.getRunId());
            MDC.put((String)"TaskQueue", (String)this.replayWorkflowContext.getTaskQueue());
            MDC.put((String)"Namespace", (String)this.replayWorkflowContext.getNamespace());
            ContextThreadLocal.setContextPropagators(this.contextPropagators);
            ContextThreadLocal.propagateContextToCurrentThread(this.propagatedContexts);
            try {
                this.threadContext.initialYield();
                this.cancellationScope.run();
            }
            catch (DestroyWorkflowThreadError e) {
                if (!this.threadContext.isDestroyRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
            }
            catch (Error e) {
                this.threadContext.setUnhandledException(e);
            }
            catch (CanceledFailure e) {
                if (!WorkflowThreadImpl.this.isCancelRequested()) {
                    this.threadContext.setUnhandledException(e);
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Workflow thread \"%s\" run canceled", this.name));
                }
            }
            catch (Throwable e) {
                this.threadContext.setUnhandledException(e);
            }
            finally {
                DeterministicRunnerImpl.setCurrentThreadInternal(null);
                this.threadContext.setStatus(Status.DONE);
                WorkflowThreadImpl.this.thread.setName(this.originalName);
                WorkflowThreadImpl.this.thread = null;
                this.threadContext.setCurrentThread(null);
                MDC.clear();
            }
        }

        public String getName() {
            return this.name;
        }

        StackTraceElement[] getStackTrace() {
            if (WorkflowThreadImpl.this.thread != null) {
                return WorkflowThreadImpl.this.thread.getStackTrace();
            }
            return new StackTraceElement[0];
        }

        public void setName(String name) {
            this.name = name;
            if (WorkflowThreadImpl.this.thread != null) {
                WorkflowThreadImpl.this.thread.setName(name);
            }
        }
    }
}

