/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.Duration;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.failure.v1.Failure;
import java.util.Optional;

final class TestServiceRetryState {
    private final RetryPolicy retryPolicy;
    private final Timestamp expirationTime;
    private final int attempt;
    private final Optional<Failure> lastFailure;

    TestServiceRetryState(RetryPolicy retryPolicy, Timestamp expirationTime) {
        this(TestServiceRetryState.validateAndOverrideRetryPolicy(retryPolicy), expirationTime, 1, Optional.empty());
    }

    private TestServiceRetryState(RetryPolicy retryPolicy, Timestamp expirationTime, int attempt, Optional<Failure> lastFailure) {
        this.retryPolicy = retryPolicy;
        this.expirationTime = Timestamps.toMillis((Timestamp)expirationTime) == 0L ? Timestamps.MAX_VALUE : expirationTime;
        this.attempt = attempt;
        this.lastFailure = lastFailure;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    Timestamp getExpirationTime() {
        return this.expirationTime;
    }

    int getAttempt() {
        return this.attempt;
    }

    public Optional<Failure> getLastFailure() {
        return this.lastFailure;
    }

    TestServiceRetryState getNextAttempt(Optional<Failure> failure) {
        return new TestServiceRetryState(this.retryPolicy, this.expirationTime, this.attempt + 1, failure);
    }

    BackoffInterval getBackoffIntervalInSeconds(Optional<String> errorType, Timestamp currentTime) {
        RetryPolicy retryPolicy = this.getRetryPolicy();
        ProtocolStringList nonRetryableErrorTypes = retryPolicy.getNonRetryableErrorTypesList();
        if (nonRetryableErrorTypes != null && errorType.isPresent()) {
            String type = errorType.get();
            for (String err : nonRetryableErrorTypes) {
                if (!type.equals(err)) continue;
                return new BackoffInterval(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE);
            }
        }
        Timestamp expirationTime = this.getExpirationTime();
        if (retryPolicy.getMaximumAttempts() == 0 && Timestamps.toMillis((Timestamp)expirationTime) == 0L) {
            return new BackoffInterval(RetryState.RETRY_STATE_RETRY_POLICY_NOT_SET);
        }
        if (retryPolicy.getMaximumAttempts() > 0 && this.getAttempt() >= retryPolicy.getMaximumAttempts()) {
            return new BackoffInterval(RetryState.RETRY_STATE_MAXIMUM_ATTEMPTS_REACHED);
        }
        long initInterval = Durations.toMillis((Duration)retryPolicy.getInitialInterval());
        long nextInterval = (long)((double)initInterval * Math.pow(retryPolicy.getBackoffCoefficient(), this.getAttempt() - 1));
        long maxInterval = Durations.toMillis((Duration)retryPolicy.getMaximumInterval());
        if (nextInterval <= 0L) {
            if (maxInterval > 0L) {
                nextInterval = maxInterval;
            } else {
                return new BackoffInterval(RetryState.RETRY_STATE_TIMEOUT);
            }
        }
        if (maxInterval > 0L && nextInterval > maxInterval) {
            nextInterval = maxInterval;
        }
        long backoffInterval = nextInterval;
        Timestamp nextScheduleTime = Timestamps.add((Timestamp)currentTime, (Duration)Durations.fromMillis((long)backoffInterval));
        if (expirationTime.getNanos() != 0 && Timestamps.compare((Timestamp)nextScheduleTime, (Timestamp)expirationTime) > 0) {
            return new BackoffInterval(RetryState.RETRY_STATE_TIMEOUT);
        }
        return new BackoffInterval(java.time.Duration.ofMillis(backoffInterval));
    }

    static RetryPolicy validateAndOverrideRetryPolicy(RetryPolicy p) {
        RetryPolicy.Builder policy = p.toBuilder();
        if (Durations.compare((Duration)policy.getInitialInterval(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("InitialIntervalInSeconds must be greater than 0 on retry policy.").asRuntimeException();
        }
        if (Durations.compare((Duration)policy.getInitialInterval(), (Duration)Durations.ZERO) == 0) {
            policy.setInitialInterval(Durations.fromSeconds((long)1L));
        }
        if (policy.getBackoffCoefficient() != 0.0 && policy.getBackoffCoefficient() < 1.0) {
            throw Status.INVALID_ARGUMENT.withDescription("BackoffCoefficient cannot be less than 1 on retry policy.").asRuntimeException();
        }
        if (policy.getBackoffCoefficient() == 0.0) {
            policy.setBackoffCoefficient(2.0);
        }
        if (Durations.compare((Duration)policy.getMaximumInterval(), (Duration)Durations.ZERO) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("MaximumIntervalInSeconds cannot be less than 0 on retry policy.").asRuntimeException();
        }
        if (Durations.compare((Duration)policy.getMaximumInterval(), (Duration)Durations.ZERO) > 0 && Durations.compare((Duration)policy.getMaximumInterval(), (Duration)policy.getInitialInterval()) < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("MaximumIntervalInSeconds cannot be less than InitialIntervalInSeconds on retry policy.").asRuntimeException();
        }
        if (policy.getMaximumAttempts() < 0) {
            throw Status.INVALID_ARGUMENT.withDescription("MaximumAttempts cannot be less than 0 on retry policy.").asRuntimeException();
        }
        return policy.build();
    }

    static class BackoffInterval {
        private final java.time.Duration interval;
        private final RetryState retryState;

        BackoffInterval(java.time.Duration interval) {
            this.interval = interval;
            this.retryState = RetryState.RETRY_STATE_IN_PROGRESS;
        }

        BackoffInterval(RetryState retryState) {
            this.interval = java.time.Duration.ofMillis(-1000L);
            this.retryState = retryState;
        }

        public java.time.Duration getInterval() {
            return this.interval;
        }

        public RetryState getRetryState() {
            return this.retryState;
        }
    }
}

