/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.common.base.Throwables;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.SignalExternalWorkflowExecutionFailedCause;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.enums.v1.WorkflowIdReusePolicy;
import io.temporal.api.errordetails.v1.WorkflowExecutionAlreadyStartedFailure;
import io.temporal.api.history.v1.WorkflowExecutionContinuedAsNewEventAttributes;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListClosedWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsRequest;
import io.temporal.api.workflowservice.v1.ListOpenWorkflowExecutionsResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.QueryWorkflowRequest;
import io.temporal.api.workflowservice.v1.QueryWorkflowResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatByIdResponse;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.RequestCancelWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedByIdResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedResponse;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWithStartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.TerminateWorkflowExecutionResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.StatusUtils;
import io.temporal.internal.testservice.ActivityId;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.QueryId;
import io.temporal.internal.testservice.TestServiceRetryState;
import io.temporal.internal.testservice.TestWorkflowMutableState;
import io.temporal.internal.testservice.TestWorkflowMutableStateImpl;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.internal.testservice.TestWorkflowStoreImpl;
import io.temporal.internal.testservice.WorkflowId;
import io.temporal.internal.testservice.WorkflowTaskToken;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestWorkflowService
extends WorkflowServiceGrpc.WorkflowServiceImplBase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestWorkflowService.class);
    private final Lock lock = new ReentrantLock();
    private final TestWorkflowStore store = new TestWorkflowStoreImpl();
    private final Map<ExecutionId, TestWorkflowMutableState> executions = new HashMap<ExecutionId, TestWorkflowMutableState>();
    private final Map<WorkflowId, TestWorkflowMutableState> executionsByWorkflowId = new HashMap<WorkflowId, TestWorkflowMutableState>();
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(4);
    private final String serverName = InProcessServerBuilder.generateName();
    private final ManagedChannel channel;
    private final WorkflowServiceStubs stubs;

    public WorkflowServiceStubs newClientStub() {
        return this.stubs;
    }

    public TestWorkflowService(boolean lockTimeSkipping) {
        this();
        if (lockTimeSkipping) {
            this.lockTimeSkipping("constructor");
        }
    }

    public TestWorkflowService() {
        try {
            ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)this.serverName).directExecutor()).addService((BindableService)this)).build().start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        this.stubs = WorkflowServiceStubs.newInstance((WorkflowServiceStubsOptions)WorkflowServiceStubsOptions.newBuilder().setChannel(this.channel).build());
    }

    @Override
    public void close() {
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.debug("interrupted", (Throwable)e);
        }
        this.store.close();
    }

    private TestWorkflowMutableState getMutableState(ExecutionId executionId) {
        return this.getMutableState(executionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(ExecutionId executionId, boolean failNotExists) {
        this.lock.lock();
        try {
            if (executionId.getExecution().getRunId().isEmpty()) {
                TestWorkflowMutableState testWorkflowMutableState = this.getMutableState(executionId.getWorkflowId(), failNotExists);
                return testWorkflowMutableState;
            }
            TestWorkflowMutableState mutableState = this.executions.get(executionId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution \"" + executionId + "\" not found in mutable state. Known executions: " + this.executions.values() + ", service=" + this).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    private TestWorkflowMutableState getMutableState(WorkflowId workflowId) {
        return this.getMutableState(workflowId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestWorkflowMutableState getMutableState(WorkflowId workflowId, boolean failNotExists) {
        this.lock.lock();
        try {
            TestWorkflowMutableState mutableState = this.executionsByWorkflowId.get(workflowId);
            if (mutableState == null && failNotExists) {
                throw Status.NOT_FOUND.withDescription("Execution not found in mutable state: " + workflowId).asRuntimeException();
            }
            TestWorkflowMutableState testWorkflowMutableState = mutableState;
            return testWorkflowMutableState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void startWorkflowExecution(StartWorkflowExecutionRequest request, StreamObserver<StartWorkflowExecutionResponse> responseObserver) {
        try {
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionImpl(request, java.time.Duration.ZERO, Optional.empty(), OptionalLong.empty(), Optional.empty());
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StartWorkflowExecutionResponse startWorkflowExecutionImpl(StartWorkflowExecutionRequest startRequest, java.time.Duration backoffStartInterval, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal) {
        String requestWorkflowId = this.requireNotNull("WorkflowId", startRequest.getWorkflowId());
        String namespace = this.requireNotNull("Namespace", startRequest.getNamespace());
        WorkflowId workflowId = new WorkflowId(namespace, requestWorkflowId);
        this.lock.lock();
        try {
            Optional<TestServiceRetryState> retryState;
            TestWorkflowMutableState existing = this.executionsByWorkflowId.get(workflowId);
            if (existing != null) {
                WorkflowExecutionStatus status = existing.getWorkflowExecutionStatus();
                WorkflowIdReusePolicy policy = startRequest.getWorkflowIdReusePolicy();
                if (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_RUNNING || policy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_REJECT_DUPLICATE) {
                    StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                    return startWorkflowExecutionResponse;
                }
                if (policy == WorkflowIdReusePolicy.WORKFLOW_ID_REUSE_POLICY_ALLOW_DUPLICATE_FAILED_ONLY && (status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_COMPLETED || status == WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_CONTINUED_AS_NEW)) {
                    StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.throwDuplicatedWorkflow(startRequest, existing);
                    return startWorkflowExecutionResponse;
                }
            }
            if (startRequest.hasRetryPolicy()) {
                java.time.Duration expirationInterval = ProtobufTimeUtils.toJavaDuration(startRequest.getWorkflowExecutionTimeout());
                retryState = this.newRetryStateLocked(startRequest.getRetryPolicy(), expirationInterval);
            } else {
                retryState = Optional.empty();
            }
            StartWorkflowExecutionResponse startWorkflowExecutionResponse = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, UUID.randomUUID().toString(), Optional.empty(), retryState, backoffStartInterval, null, parent, parentChildInitiatedEventId, signalWithStartSignal, workflowId);
            return startWorkflowExecutionResponse;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Optional<TestServiceRetryState> newRetryStateLocked(RetryPolicy retryPolicy, java.time.Duration expirationInterval) {
        Timestamp expirationTime = expirationInterval.isZero() ? Timestamps.fromNanos((long)0L) : Timestamps.add((Timestamp)this.store.currentTime(), (Duration)ProtobufTimeUtils.toProtoDuration(expirationInterval));
        return Optional.of(new TestServiceRetryState(retryPolicy, expirationTime));
    }

    private StartWorkflowExecutionResponse throwDuplicatedWorkflow(StartWorkflowExecutionRequest startRequest, TestWorkflowMutableState existing) {
        WorkflowExecution execution = existing.getExecutionId().getExecution();
        WorkflowExecutionAlreadyStartedFailure error = WorkflowExecutionAlreadyStartedFailure.newBuilder().setRunId(execution.getRunId()).setStartRequestId(startRequest.getRequestId()).build();
        throw StatusUtils.newException(Status.ALREADY_EXISTS.withDescription(String.format("WorkflowId: %s, RunId: %s", execution.getWorkflowId(), execution.getRunId())), error);
    }

    private StartWorkflowExecutionResponse startWorkflowExecutionNoRunningCheckLocked(StartWorkflowExecutionRequest startRequest, String runId, Optional<String> continuedExecutionRunId, Optional<TestServiceRetryState> retryState, java.time.Duration backoffStartInterval, Payloads lastCompletionResult, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId, Optional<SignalWorkflowExecutionRequest> signalWithStartSignal, WorkflowId workflowId) {
        String namespace = startRequest.getNamespace();
        TestWorkflowMutableStateImpl mutableState = new TestWorkflowMutableStateImpl(startRequest, runId, retryState, backoffStartInterval, lastCompletionResult, parent, parentChildInitiatedEventId, continuedExecutionRunId, this, this.store);
        WorkflowExecution execution = mutableState.getExecutionId().getExecution();
        ExecutionId executionId = new ExecutionId(namespace, execution);
        this.executionsByWorkflowId.put(workflowId, mutableState);
        this.executions.put(executionId, mutableState);
        mutableState.startWorkflow(continuedExecutionRunId.isPresent(), signalWithStartSignal);
        return StartWorkflowExecutionResponse.newBuilder().setRunId(execution.getRunId()).build();
    }

    public void getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getRequest, StreamObserver<GetWorkflowExecutionHistoryResponse> responseObserver) {
        ExecutionId executionId = new ExecutionId(getRequest.getNamespace(), getRequest.getExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        this.forkJoinPool.execute(() -> {
            try {
                Deadline deadline = Context.current().getDeadline();
                responseObserver.onNext((Object)this.store.getWorkflowExecutionHistory(mutableState.getExecutionId(), getRequest, deadline));
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                    log.error("unexpected", (Throwable)e);
                }
                responseObserver.onError((Throwable)e);
            }
            catch (Exception e) {
                log.error("unexpected", (Throwable)e);
                responseObserver.onError((Throwable)e);
            }
        });
    }

    public void pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest pollRequest, StreamObserver<PollWorkflowTaskQueueResponse> responseObserver) {
        Deadline deadline = Context.current().getDeadline();
        Optional<PollWorkflowTaskQueueResponse.Builder> optionalTask = this.store.pollWorkflowTaskQueue(pollRequest, deadline);
        if (!optionalTask.isPresent()) {
            responseObserver.onNext((Object)PollWorkflowTaskQueueResponse.getDefaultInstance());
            responseObserver.onCompleted();
            return;
        }
        PollWorkflowTaskQueueResponse.Builder task = optionalTask.get();
        ExecutionId executionId = new ExecutionId(pollRequest.getNamespace(), task.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        try {
            mutableState.startWorkflowTask(task, pollRequest);
            task.setWorkflowExecutionTaskQueue(mutableState.getStartRequest().getTaskQueue());
            PollWorkflowTaskQueueResponse response = task.build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping outdated workflow task for " + executionId, (Throwable)e);
                }
                responseObserver.onNext((Object)PollWorkflowTaskQueueResponse.getDefaultInstance());
                responseObserver.onCompleted();
            }
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondWorkflowTaskCompleted(RespondWorkflowTaskCompletedRequest request, StreamObserver<RespondWorkflowTaskCompletedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(request.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.completeWorkflowTask(taskToken.getHistorySize(), request);
            responseObserver.onNext((Object)RespondWorkflowTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
        catch (Throwable e) {
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription(Throwables.getStackTraceAsString((Throwable)e)).withCause(e).asRuntimeException());
        }
    }

    public void respondWorkflowTaskFailed(RespondWorkflowTaskFailedRequest failedRequest, StreamObserver<RespondWorkflowTaskFailedResponse> responseObserver) {
        try {
            WorkflowTaskToken taskToken = WorkflowTaskToken.fromBytes(failedRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(taskToken.getExecutionId());
            mutableState.failWorkflowTask(failedRequest);
            responseObserver.onNext((Object)RespondWorkflowTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void pollActivityTaskQueue(PollActivityTaskQueueRequest pollRequest, StreamObserver<PollActivityTaskQueueResponse> responseObserver) {
        while (true) {
            Deadline deadline;
            Optional<PollActivityTaskQueueResponse.Builder> optionalTask;
            if (!(optionalTask = this.store.pollActivityTaskQueue(pollRequest, deadline = Context.current().getDeadline())).isPresent()) {
                responseObserver.onNext((Object)PollActivityTaskQueueResponse.getDefaultInstance());
                responseObserver.onCompleted();
                return;
            }
            PollActivityTaskQueueResponse.Builder task = optionalTask.get();
            ExecutionId executionId = new ExecutionId(pollRequest.getNamespace(), task.getWorkflowExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            try {
                mutableState.startActivityTask((PollActivityTaskQueueResponseOrBuilder)task, pollRequest);
                responseObserver.onNext((Object)task.build());
                responseObserver.onCompleted();
                return;
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping outdated activity task for " + executionId, (Throwable)e);
                    }
                    responseObserver.onNext((Object)PollActivityTaskQueueResponse.getDefaultInstance());
                    responseObserver.onCompleted();
                    continue;
                }
                if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                    log.error("unexpected", (Throwable)e);
                }
                responseObserver.onError((Throwable)e);
                return;
            }
            break;
        }
    }

    public void recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(heartbeatRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            boolean cancelRequested = mutableState.heartbeatActivityTask(activityId.getScheduledEventId(), heartbeatRequest.getDetails());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void recordActivityTaskHeartbeatById(RecordActivityTaskHeartbeatByIdRequest heartbeatRequest, StreamObserver<RecordActivityTaskHeartbeatByIdResponse> responseObserver) {
        try {
            ExecutionId execution = new ExecutionId(heartbeatRequest.getNamespace(), heartbeatRequest.getWorkflowId(), heartbeatRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(execution);
            boolean cancelRequested = mutableState.heartbeatActivityTaskById(heartbeatRequest.getActivityId(), heartbeatRequest.getDetails());
            responseObserver.onNext((Object)RecordActivityTaskHeartbeatByIdResponse.newBuilder().setCancelRequested(cancelRequested).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest completeRequest, StreamObserver<RespondActivityTaskCompletedResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.completeActivityTask(activityId.getScheduledEventId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskCompletedById(RespondActivityTaskCompletedByIdRequest completeRequest, StreamObserver<RespondActivityTaskCompletedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(completeRequest.getNamespace(), completeRequest.getWorkflowId(), completeRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.completeActivityTaskById(completeRequest.getActivityId(), completeRequest);
            responseObserver.onNext((Object)RespondActivityTaskCompletedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest failRequest, StreamObserver<RespondActivityTaskFailedResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(failRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.failActivityTask(activityId.getScheduledEventId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskFailedById(RespondActivityTaskFailedByIdRequest failRequest, StreamObserver<RespondActivityTaskFailedByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(failRequest.getNamespace(), failRequest.getWorkflowId(), failRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.failActivityTaskById(failRequest.getActivityId(), failRequest);
            responseObserver.onNext((Object)RespondActivityTaskFailedByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledResponse> responseObserver) {
        try {
            ActivityId activityId = ActivityId.fromBytes(canceledRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(activityId.getExecutionId());
            mutableState.cancelActivityTask(activityId.getScheduledEventId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondActivityTaskCanceledById(RespondActivityTaskCanceledByIdRequest canceledRequest, StreamObserver<RespondActivityTaskCanceledByIdResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(canceledRequest.getNamespace(), canceledRequest.getWorkflowId(), canceledRequest.getRunId());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.cancelActivityTaskById(canceledRequest.getActivityId(), canceledRequest);
            responseObserver.onNext((Object)RespondActivityTaskCanceledByIdResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, StreamObserver<RequestCancelWorkflowExecutionResponse> responseObserver) {
        try {
            this.requestCancelWorkflowExecution(cancelRequest, Optional.empty());
            responseObserver.onNext((Object)RequestCancelWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest cancelRequest, Optional<TestWorkflowMutableStateImpl.CancelExternalWorkflowExecutionCallerInfo> callerInfo) {
        ExecutionId executionId = new ExecutionId(cancelRequest.getNamespace(), cancelRequest.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.requestCancelWorkflowExecution(cancelRequest, callerInfo);
    }

    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request, StreamObserver<TerminateWorkflowExecutionResponse> responseObserver) {
        try {
            this.terminateWorkflowExecution(request);
            responseObserver.onNext((Object)TerminateWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    private void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        ExecutionId executionId = new ExecutionId(request.getNamespace(), request.getWorkflowExecution());
        TestWorkflowMutableState mutableState = this.getMutableState(executionId);
        mutableState.terminateWorkflowExecution(request);
    }

    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalRequest, StreamObserver<SignalWorkflowExecutionResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(signalRequest.getNamespace(), signalRequest.getWorkflowExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            mutableState.signal(signalRequest);
            responseObserver.onNext((Object)SignalWorkflowExecutionResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void signalWithStartWorkflowExecution(SignalWithStartWorkflowExecutionRequest r, StreamObserver<SignalWithStartWorkflowExecutionResponse> responseObserver) {
        try {
            if (!r.hasTaskQueue()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required taskQueue field").asRuntimeException();
            }
            if (!r.hasWorkflowType()) {
                throw Status.INVALID_ARGUMENT.withDescription("request missing required workflowType field").asRuntimeException();
            }
            ExecutionId executionId = new ExecutionId(r.getNamespace(), r.getWorkflowId(), null);
            TestWorkflowMutableState mutableState = this.getMutableState(executionId, false);
            SignalWorkflowExecutionRequest signalRequest = SignalWorkflowExecutionRequest.newBuilder().setInput(r.getSignalInput()).setSignalName(r.getSignalName()).setWorkflowExecution(executionId.getExecution()).setRequestId(r.getRequestId()).setControl(r.getControl()).setNamespace(r.getNamespace()).setIdentity(r.getIdentity()).build();
            if (mutableState != null && !mutableState.isTerminalState()) {
                mutableState.signal(signalRequest);
                responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(mutableState.getExecutionId().getExecution().getRunId()).build());
                responseObserver.onCompleted();
                return;
            }
            StartWorkflowExecutionRequest.Builder startRequest = StartWorkflowExecutionRequest.newBuilder().setRequestId(r.getRequestId()).setInput(r.getInput()).setWorkflowExecutionTimeout(r.getWorkflowExecutionTimeout()).setWorkflowRunTimeout(r.getWorkflowRunTimeout()).setWorkflowTaskTimeout(r.getWorkflowTaskTimeout()).setNamespace(r.getNamespace()).setTaskQueue(r.getTaskQueue()).setWorkflowId(r.getWorkflowId()).setWorkflowIdReusePolicy(r.getWorkflowIdReusePolicy()).setIdentity(r.getIdentity()).setWorkflowType(r.getWorkflowType()).setCronSchedule(r.getCronSchedule()).setRequestId(r.getRequestId());
            if (r.hasRetryPolicy()) {
                startRequest.setRetryPolicy(r.getRetryPolicy());
            }
            if (r.hasHeader()) {
                startRequest.setHeader(r.getHeader());
            }
            if (r.hasMemo()) {
                startRequest.setMemo(r.getMemo());
            }
            if (r.hasSearchAttributes()) {
                startRequest.setSearchAttributes(r.getSearchAttributes());
            }
            StartWorkflowExecutionResponse startResult = this.startWorkflowExecutionImpl(startRequest.build(), java.time.Duration.ZERO, Optional.empty(), OptionalLong.empty(), Optional.of(signalRequest));
            responseObserver.onNext((Object)SignalWithStartWorkflowExecutionResponse.newBuilder().setRunId(startResult.getRunId()).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void signalExternalWorkflowExecution(String signalId, SignalExternalWorkflowExecutionCommandAttributes a, TestWorkflowMutableState source) {
        String namespace = a.getNamespace().isEmpty() ? source.getExecutionId().getNamespace() : a.getNamespace();
        ExecutionId executionId = new ExecutionId(namespace, a.getExecution());
        TestWorkflowMutableState mutableState = null;
        try {
            mutableState = this.getMutableState(executionId);
            mutableState.signalFromWorkflow(a);
            source.completeSignalExternalWorkflowExecution(signalId, mutableState.getExecutionId().getExecution().getRunId());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                source.failSignalExternalWorkflowExecution(signalId, SignalExternalWorkflowExecutionFailedCause.SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED_CAUSE_EXTERNAL_WORKFLOW_EXECUTION_NOT_FOUND);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String continueAsNew(StartWorkflowExecutionRequest previousRunStartRequest, WorkflowExecutionContinuedAsNewEventAttributes a, Optional<TestServiceRetryState> retryState, String identity, ExecutionId executionId, Optional<TestWorkflowMutableState> parent, OptionalLong parentChildInitiatedEventId) {
        StartWorkflowExecutionRequest.Builder startRequestBuilder = StartWorkflowExecutionRequest.newBuilder().setRequestId(UUID.randomUUID().toString()).setWorkflowType(a.getWorkflowType()).setWorkflowRunTimeout(a.getWorkflowRunTimeout()).setWorkflowTaskTimeout(a.getWorkflowTaskTimeout()).setNamespace(executionId.getNamespace()).setTaskQueue(a.getTaskQueue()).setWorkflowId(executionId.getWorkflowId().getWorkflowId()).setWorkflowIdReusePolicy(previousRunStartRequest.getWorkflowIdReusePolicy()).setIdentity(identity).setCronSchedule(previousRunStartRequest.getCronSchedule());
        if (previousRunStartRequest.hasRetryPolicy()) {
            startRequestBuilder.setRetryPolicy(previousRunStartRequest.getRetryPolicy());
        }
        if (a.hasInput()) {
            startRequestBuilder.setInput(a.getInput());
        }
        StartWorkflowExecutionRequest startRequest = startRequestBuilder.build();
        this.lock.lock();
        try {
            StartWorkflowExecutionResponse response = this.startWorkflowExecutionNoRunningCheckLocked(startRequest, a.getNewExecutionRunId(), Optional.of(executionId.getExecution().getRunId()), retryState, ProtobufTimeUtils.toJavaDuration(a.getBackoffStartInterval()), a.getLastCompletionResult(), parent, parentChildInitiatedEventId, Optional.empty(), executionId.getWorkflowId());
            String string = response.getRunId();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listRequest, StreamObserver<ListOpenWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.OPEN, workflowIdFilter);
            responseObserver.onNext((Object)ListOpenWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listRequest, StreamObserver<ListClosedWorkflowExecutionsResponse> responseObserver) {
        try {
            Optional<String> workflowIdFilter = listRequest.hasExecutionFilter() && !listRequest.getExecutionFilter().getWorkflowId().isEmpty() ? Optional.of(listRequest.getExecutionFilter().getWorkflowId()) : Optional.empty();
            List<WorkflowExecutionInfo> result = this.store.listWorkflows(TestWorkflowStore.WorkflowState.CLOSED, workflowIdFilter);
            responseObserver.onNext((Object)ListClosedWorkflowExecutionsResponse.newBuilder().addAllExecutions(result).build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void respondQueryTaskCompleted(RespondQueryTaskCompletedRequest completeRequest, StreamObserver<RespondQueryTaskCompletedResponse> responseObserver) {
        try {
            QueryId queryId = QueryId.fromBytes(completeRequest.getTaskToken());
            TestWorkflowMutableState mutableState = this.getMutableState(queryId.getExecutionId());
            mutableState.completeQuery(queryId, completeRequest);
            responseObserver.onNext((Object)RespondQueryTaskCompletedResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    public void queryWorkflow(QueryWorkflowRequest queryRequest, StreamObserver<QueryWorkflowResponse> responseObserver) {
        try {
            ExecutionId executionId = new ExecutionId(queryRequest.getNamespace(), queryRequest.getExecution());
            TestWorkflowMutableState mutableState = this.getMutableState(executionId);
            Deadline deadline = Context.current().getDeadline();
            QueryWorkflowResponse result = mutableState.query(queryRequest, deadline.timeRemaining(TimeUnit.MILLISECONDS));
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.INTERNAL) {
                log.error("unexpected", (Throwable)e);
            }
            responseObserver.onError((Throwable)e);
        }
    }

    private <R> R requireNotNull(String fieldName, R value) {
        if (value == null) {
            throw Status.INVALID_ARGUMENT.withDescription("Missing requried field \"" + fieldName + "\".").asRuntimeException();
        }
        return value;
    }

    public void getDiagnostics(StringBuilder result) {
        this.store.getDiagnostics(result);
    }

    public long currentTimeMillis() {
        return this.store.getTimer().getClock().getAsLong();
    }

    public void registerDelayedCallback(java.time.Duration delay, Runnable r) {
        this.store.registerDelayedCallback(delay, r);
    }

    public void lockTimeSkipping(String caller) {
        this.store.getTimer().lockTimeSkipping(caller);
    }

    public void unlockTimeSkipping(String caller) {
        this.store.getTimer().unlockTimeSkipping(caller);
    }

    public void sleep(java.time.Duration duration) {
        CompletableFuture result = new CompletableFuture();
        this.store.getTimer().schedule(duration, () -> {
            this.store.getTimer().lockTimeSkipping("TestWorkflowService sleep");
            result.complete(null);
        }, "workflow sleep");
        this.store.getTimer().unlockTimeSkipping("TestWorkflowService sleep");
        try {
            result.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

