/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.DoubleValue;
import com.uber.m3.tally.Scope;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.taskqueue.v1.TaskQueueMetadata;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
implements Poller.PollTask<PollActivityTaskQueueResponse> {
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);
    private final double taskQueueActivitiesPerSecond;
    private final Scope metricsScope;

    public ActivityPollTask(WorkflowServiceStubs service, String namespace, String taskQueue, SingleWorkerOptions options, double taskQueueActivitiesPerSecond) {
        this.service = service;
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.options = options;
        this.metricsScope = options.getMetricsScope();
        this.taskQueueActivitiesPerSecond = taskQueueActivitiesPerSecond;
    }

    @Override
    public PollActivityTaskQueueResponse poll() {
        PollActivityTaskQueueResponse result;
        PollActivityTaskQueueRequest.Builder pollRequest = PollActivityTaskQueueRequest.newBuilder().setNamespace(this.namespace).setIdentity(this.options.getIdentity()).setTaskQueue(TaskQueue.newBuilder().setName(this.taskQueue));
        if (this.taskQueueActivitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(this.taskQueueActivitiesPerSecond).build()).build());
        }
        if (this.taskQueueActivitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(this.taskQueueActivitiesPerSecond).build()).build());
        }
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + pollRequest);
        }
        try {
            result = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub().withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollActivityTaskQueue(pollRequest.build());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.UNAVAILABLE && e.getMessage().startsWith("UNAVAILABLE: Channel shutdown")) {
                return null;
            }
            throw e;
        }
        if (result == null || result.getTaskToken().isEmpty()) {
            this.metricsScope.counter("temporal_activity_poll_no_task").inc(1L);
            return null;
        }
        this.metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(result.getStartedTime(), result.getCurrentAttemptScheduledTime()));
        return result;
    }
}

