/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.worker.BlockCallerPolicy;
import io.temporal.internal.worker.ExecutorThreadFactory;
import io.temporal.internal.worker.ShutdownableTaskExecutor;
import io.temporal.internal.worker.SingleWorkerOptions;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

final class PollTaskExecutor<T>
implements ShutdownableTaskExecutor<T> {
    private final ThreadPoolExecutor taskExecutor;
    private final SingleWorkerOptions options;
    private final String namespace;
    private final String taskQueue;
    private final TaskHandler<T> handler;

    PollTaskExecutor(String namespace, String taskQueue, SingleWorkerOptions options, TaskHandler<T> handler) {
        this.namespace = namespace;
        this.taskQueue = taskQueue;
        this.handler = handler;
        Preconditions.checkNotNull((Object)options, (Object)"options should not be null");
        this.options = options;
        this.taskExecutor = new ThreadPoolExecutor(0, options.getTaskExecutorThreadPoolSize(), 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.taskExecutor.setThreadFactory(new ExecutorThreadFactory(options.getPollerOptions().getPollThreadNamePrefix().replaceFirst("Poller", "Executor"), options.getPollerOptions().getUncaughtExceptionHandler()));
        this.taskExecutor.setRejectedExecutionHandler(new BlockCallerPolicy());
    }

    @Override
    public void process(T task) {
        this.taskExecutor.execute(() -> {
            MDC.put((String)"Namespace", (String)this.namespace);
            MDC.put((String)"TaskQueue", (String)this.taskQueue);
            try {
                this.handler.handle(task);
            }
            catch (Throwable ee) {
                if (!this.isShutdown()) {
                    this.options.getPollerOptions().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), this.handler.wrapFailure(task, ee));
                }
            }
            finally {
                MDC.remove((String)"Namespace");
                MDC.remove((String)"TaskQueue");
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return this.taskExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.taskExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.taskExecutor.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        InternalUtils.awaitTermination(this.taskExecutor, unit.toMillis(timeout));
    }

    public static interface TaskHandler<TT> {
        public void handle(TT var1) throws Exception;

        public Throwable wrapFailure(TT var1, Throwable var2);
    }
}

