/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.uber.m3.tally.Scope;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.client.WorkflowClient;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.worker.PollWorkflowTaskDispatcher;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.WorkflowPollTaskFactory;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactoryOptions;
import io.temporal.worker.WorkerOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkerFactory {
    private final Scope metricsScope;
    private static final String POLL_THREAD_NAME = "Host Local Workflow Poller";
    private final List<Worker> workers = new ArrayList<Worker>();
    private final WorkflowClient workflowClient;
    private final UUID id = UUID.randomUUID();
    private final ThreadPoolExecutor workflowThreadPool;
    private final AtomicInteger workflowThreadCounter = new AtomicInteger();
    private final WorkerFactoryOptions factoryOptions;
    private final Poller<PollWorkflowTaskQueueResponse> stickyPoller;
    private final PollWorkflowTaskDispatcher dispatcher;
    private final WorkflowExecutorCache cache;
    private State state = State.Initial;
    private final String statusErrorMessage = "attempted to %s while in %s state. Acceptable States: %s";
    private static final Logger log = LoggerFactory.getLogger(WorkerFactory.class);

    public static WorkerFactory newInstance(WorkflowClient workflowClient) {
        return WorkerFactory.newInstance(workflowClient, WorkerFactoryOptions.getDefaultInstance());
    }

    public static WorkerFactory newInstance(WorkflowClient workflowClient, WorkerFactoryOptions options) {
        return new WorkerFactory(workflowClient, options);
    }

    private WorkerFactory(WorkflowClient workflowClient, WorkerFactoryOptions factoryOptions) {
        this.workflowClient = Objects.requireNonNull(workflowClient);
        this.factoryOptions = WorkerFactoryOptions.newBuilder(factoryOptions).validateAndBuildWithDefaults();
        this.workflowThreadPool = new ThreadPoolExecutor(0, this.factoryOptions.getMaxWorkflowThreadCount(), 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.workflowThreadPool.setThreadFactory(r -> new Thread(r, "workflow-thread-" + this.workflowThreadCounter.incrementAndGet()));
        this.metricsScope = this.workflowClient.getWorkflowServiceStubs().getOptions().getMetricsScope().tagged(MetricsTag.defaultTags((String)workflowClient.getOptions().getNamespace()));
        this.cache = new WorkflowExecutorCache(this.factoryOptions.getWorkflowCacheSize(), this.metricsScope);
        Scope stickyScope = this.metricsScope.tagged((Map)new ImmutableMap.Builder(1).put((Object)"TaskQueue", (Object)"sticky").build());
        this.dispatcher = new PollWorkflowTaskDispatcher(workflowClient.getWorkflowServiceStubs(), this.metricsScope);
        this.stickyPoller = new Poller<PollWorkflowTaskQueueResponse>(this.id.toString(), (Poller.PollTask<PollWorkflowTaskQueueResponse>)new WorkflowPollTaskFactory(workflowClient.getWorkflowServiceStubs(), workflowClient.getOptions().getNamespace(), this.getStickyTaskQueueName(), stickyScope, this.id.toString()).get(), this.dispatcher, PollerOptions.newBuilder().setPollThreadNamePrefix(POLL_THREAD_NAME).setPollThreadCount(this.factoryOptions.getWorkflowHostLocalPollThreadCount()).build(), stickyScope);
    }

    public Worker newWorker(String taskQueue) {
        return this.newWorker(taskQueue, null);
    }

    public synchronized Worker newWorker(String taskQueue, WorkerOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskQueue) ? 1 : 0) != 0, (Object)"taskQueue should not be an empty string");
        Preconditions.checkState((this.state == State.Initial ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "create new worker", this.state.name(), State.Initial.name()));
        Worker worker = new Worker(this.workflowClient, taskQueue, this.factoryOptions, options, this.metricsScope, this.cache, this.getStickyTaskQueueName(), this.workflowThreadPool, this.workflowClient.getOptions().getContextPropagators());
        this.workers.add(worker);
        this.dispatcher.subscribe(taskQueue, worker.workflowWorker);
        return worker;
    }

    public synchronized void start() {
        Preconditions.checkState((this.state == State.Initial || this.state == State.Started ? 1 : 0) != 0, (Object)String.format("attempted to %s while in %s state. Acceptable States: %s", "start WorkerFactory", this.state.name(), String.format("%s, %s", State.Initial.name(), State.Initial.name())));
        if (this.state == State.Started) {
            return;
        }
        this.state = State.Started;
        for (Worker worker : this.workers) {
            worker.start();
        }
        if (this.stickyPoller != null) {
            this.stickyPoller.start();
        }
    }

    public synchronized boolean isStarted() {
        return this.state != State.Initial;
    }

    public synchronized boolean isShutdown() {
        return this.state == State.Shutdown;
    }

    public synchronized boolean isTerminated() {
        if (this.state != State.Shutdown) {
            return false;
        }
        if (this.stickyPoller != null && !this.stickyPoller.isTerminated()) {
            return false;
        }
        for (Worker worker : this.workers) {
            if (worker.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    public synchronized void shutdown() {
        log.info("shutdown");
        this.state = State.Shutdown;
        if (this.stickyPoller != null) {
            this.stickyPoller.shutdown();
            this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
        }
        for (Worker worker : this.workers) {
            worker.shutdown();
        }
    }

    public synchronized void shutdownNow() {
        log.info("shutdownNow");
        this.state = State.Shutdown;
        if (this.stickyPoller != null) {
            this.stickyPoller.shutdownNow();
            this.stickyPoller.awaitTermination(1L, TimeUnit.SECONDS);
        }
        for (Worker worker : this.workers) {
            worker.shutdownNow();
        }
    }

    public void awaitTermination(long timeout, TimeUnit unit) {
        log.info("awaitTermination begin");
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = InternalUtils.awaitTermination(this.stickyPoller, timeoutMillis);
        for (Worker worker : this.workers) {
            long t = timeoutMillis;
            timeoutMillis = InternalUtils.awaitTermination(timeoutMillis, () -> worker.awaitTermination(t, TimeUnit.MILLISECONDS));
        }
        log.info("awaitTermination done");
    }

    @VisibleForTesting
    WorkflowExecutorCache getCache() {
        return this.cache;
    }

    private String getStickyTaskQueueName() {
        return String.format("%s:%s", this.workflowClient.getOptions().getIdentity(), this.id);
    }

    public synchronized void suspendPolling() {
        if (this.state != State.Started) {
            return;
        }
        log.info("suspendPolling");
        this.state = State.Suspended;
        if (this.stickyPoller != null) {
            this.stickyPoller.suspendPolling();
        }
        for (Worker worker : this.workers) {
            worker.suspendPolling();
        }
    }

    public synchronized void resumePolling() {
        if (this.state != State.Suspended) {
            return;
        }
        log.info("resumePolling");
        this.state = State.Started;
        if (this.stickyPoller != null) {
            this.stickyPoller.resumePolling();
        }
        for (Worker worker : this.workers) {
            worker.resumePolling();
        }
    }

    static enum State {
        Initial,
        Started,
        Suspended,
        Shutdown;

    }
}

