package io.temporal.api.operatorservice.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
 * to perform administrative functions like registering a search attribute or a namespace.
 * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
 * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.34.1)",
    comments = "Source: temporal/api/operatorservice/v1/service.proto")
public final class OperatorServiceGrpc {

  private OperatorServiceGrpc() {}

  public static final String SERVICE_NAME = "temporal.api.operatorservice.v1.OperatorService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;
    if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getAddSearchAttributesMethod = getAddSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("AddSearchAttributes"))
              .build();
        }
      }
    }
    return getAddSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;
    if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getRemoveSearchAttributesMethod = getRemoveSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("RemoveSearchAttributes"))
              .build();
        }
      }
    }
    return getRemoveSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;
    if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getListSearchAttributesMethod = getListSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListSearchAttributes"))
              .build();
        }
      }
    }
    return getListSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNamespace",
      requestType = io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;
    if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
          OperatorServiceGrpc.getDeleteNamespaceMethod = getDeleteNamespaceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNamespace"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNamespace"))
              .build();
        }
      }
    }
    return getDeleteNamespaceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddOrUpdateRemoteCluster",
      requestType = io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest.class,
      responseType = io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest, io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> getAddOrUpdateRemoteClusterMethod;
    if ((getAddOrUpdateRemoteClusterMethod = OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getAddOrUpdateRemoteClusterMethod = OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod) == null) {
          OperatorServiceGrpc.getAddOrUpdateRemoteClusterMethod = getAddOrUpdateRemoteClusterMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest, io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddOrUpdateRemoteCluster"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("AddOrUpdateRemoteCluster"))
              .build();
        }
      }
    }
    return getAddOrUpdateRemoteClusterMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveRemoteCluster",
      requestType = io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest.class,
      responseType = io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
      io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest, io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> getRemoveRemoteClusterMethod;
    if ((getRemoveRemoteClusterMethod = OperatorServiceGrpc.getRemoveRemoteClusterMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getRemoveRemoteClusterMethod = OperatorServiceGrpc.getRemoveRemoteClusterMethod) == null) {
          OperatorServiceGrpc.getRemoveRemoteClusterMethod = getRemoveRemoteClusterMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest, io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveRemoteCluster"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("RemoveRemoteCluster"))
              .build();
        }
      }
    }
    return getRemoveRemoteClusterMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest,
      io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListClusters",
      requestType = io.temporal.api.operatorservice.v1.ListClustersRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListClustersResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest,
      io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListClustersRequest, io.temporal.api.operatorservice.v1.ListClustersResponse> getListClustersMethod;
    if ((getListClustersMethod = OperatorServiceGrpc.getListClustersMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListClustersMethod = OperatorServiceGrpc.getListClustersMethod) == null) {
          OperatorServiceGrpc.getListClustersMethod = getListClustersMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListClustersRequest, io.temporal.api.operatorservice.v1.ListClustersResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListClusters"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListClustersRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListClustersResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListClusters"))
              .build();
        }
      }
    }
    return getListClustersMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> getGetNexusIncomingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetNexusIncomingService",
      requestType = io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> getGetNexusIncomingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> getGetNexusIncomingServiceMethod;
    if ((getGetNexusIncomingServiceMethod = OperatorServiceGrpc.getGetNexusIncomingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getGetNexusIncomingServiceMethod = OperatorServiceGrpc.getGetNexusIncomingServiceMethod) == null) {
          OperatorServiceGrpc.getGetNexusIncomingServiceMethod = getGetNexusIncomingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetNexusIncomingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("GetNexusIncomingService"))
              .build();
        }
      }
    }
    return getGetNexusIncomingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> getCreateNexusIncomingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateNexusIncomingService",
      requestType = io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> getCreateNexusIncomingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> getCreateNexusIncomingServiceMethod;
    if ((getCreateNexusIncomingServiceMethod = OperatorServiceGrpc.getCreateNexusIncomingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getCreateNexusIncomingServiceMethod = OperatorServiceGrpc.getCreateNexusIncomingServiceMethod) == null) {
          OperatorServiceGrpc.getCreateNexusIncomingServiceMethod = getCreateNexusIncomingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateNexusIncomingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("CreateNexusIncomingService"))
              .build();
        }
      }
    }
    return getCreateNexusIncomingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> getUpdateNexusIncomingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateNexusIncomingService",
      requestType = io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> getUpdateNexusIncomingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> getUpdateNexusIncomingServiceMethod;
    if ((getUpdateNexusIncomingServiceMethod = OperatorServiceGrpc.getUpdateNexusIncomingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getUpdateNexusIncomingServiceMethod = OperatorServiceGrpc.getUpdateNexusIncomingServiceMethod) == null) {
          OperatorServiceGrpc.getUpdateNexusIncomingServiceMethod = getUpdateNexusIncomingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateNexusIncomingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("UpdateNexusIncomingService"))
              .build();
        }
      }
    }
    return getUpdateNexusIncomingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> getDeleteNexusIncomingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNexusIncomingService",
      requestType = io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> getDeleteNexusIncomingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> getDeleteNexusIncomingServiceMethod;
    if ((getDeleteNexusIncomingServiceMethod = OperatorServiceGrpc.getDeleteNexusIncomingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNexusIncomingServiceMethod = OperatorServiceGrpc.getDeleteNexusIncomingServiceMethod) == null) {
          OperatorServiceGrpc.getDeleteNexusIncomingServiceMethod = getDeleteNexusIncomingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest, io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNexusIncomingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNexusIncomingService"))
              .build();
        }
      }
    }
    return getDeleteNexusIncomingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest,
      io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> getListNexusIncomingServicesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListNexusIncomingServices",
      requestType = io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest,
      io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> getListNexusIncomingServicesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest, io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> getListNexusIncomingServicesMethod;
    if ((getListNexusIncomingServicesMethod = OperatorServiceGrpc.getListNexusIncomingServicesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListNexusIncomingServicesMethod = OperatorServiceGrpc.getListNexusIncomingServicesMethod) == null) {
          OperatorServiceGrpc.getListNexusIncomingServicesMethod = getListNexusIncomingServicesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest, io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListNexusIncomingServices"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListNexusIncomingServices"))
              .build();
        }
      }
    }
    return getListNexusIncomingServicesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> getGetNexusOutgoingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetNexusOutgoingService",
      requestType = io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> getGetNexusOutgoingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> getGetNexusOutgoingServiceMethod;
    if ((getGetNexusOutgoingServiceMethod = OperatorServiceGrpc.getGetNexusOutgoingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getGetNexusOutgoingServiceMethod = OperatorServiceGrpc.getGetNexusOutgoingServiceMethod) == null) {
          OperatorServiceGrpc.getGetNexusOutgoingServiceMethod = getGetNexusOutgoingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetNexusOutgoingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("GetNexusOutgoingService"))
              .build();
        }
      }
    }
    return getGetNexusOutgoingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> getCreateNexusOutgoingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateNexusOutgoingService",
      requestType = io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> getCreateNexusOutgoingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> getCreateNexusOutgoingServiceMethod;
    if ((getCreateNexusOutgoingServiceMethod = OperatorServiceGrpc.getCreateNexusOutgoingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getCreateNexusOutgoingServiceMethod = OperatorServiceGrpc.getCreateNexusOutgoingServiceMethod) == null) {
          OperatorServiceGrpc.getCreateNexusOutgoingServiceMethod = getCreateNexusOutgoingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateNexusOutgoingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("CreateNexusOutgoingService"))
              .build();
        }
      }
    }
    return getCreateNexusOutgoingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> getUpdateNexusOutgoingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateNexusOutgoingService",
      requestType = io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> getUpdateNexusOutgoingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> getUpdateNexusOutgoingServiceMethod;
    if ((getUpdateNexusOutgoingServiceMethod = OperatorServiceGrpc.getUpdateNexusOutgoingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getUpdateNexusOutgoingServiceMethod = OperatorServiceGrpc.getUpdateNexusOutgoingServiceMethod) == null) {
          OperatorServiceGrpc.getUpdateNexusOutgoingServiceMethod = getUpdateNexusOutgoingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "UpdateNexusOutgoingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("UpdateNexusOutgoingService"))
              .build();
        }
      }
    }
    return getUpdateNexusOutgoingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> getDeleteNexusOutgoingServiceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNexusOutgoingService",
      requestType = io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest,
      io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> getDeleteNexusOutgoingServiceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> getDeleteNexusOutgoingServiceMethod;
    if ((getDeleteNexusOutgoingServiceMethod = OperatorServiceGrpc.getDeleteNexusOutgoingServiceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNexusOutgoingServiceMethod = OperatorServiceGrpc.getDeleteNexusOutgoingServiceMethod) == null) {
          OperatorServiceGrpc.getDeleteNexusOutgoingServiceMethod = getDeleteNexusOutgoingServiceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest, io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNexusOutgoingService"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNexusOutgoingService"))
              .build();
        }
      }
    }
    return getDeleteNexusOutgoingServiceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest,
      io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> getListNexusOutgoingServicesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListNexusOutgoingServices",
      requestType = io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest,
      io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> getListNexusOutgoingServicesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest, io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> getListNexusOutgoingServicesMethod;
    if ((getListNexusOutgoingServicesMethod = OperatorServiceGrpc.getListNexusOutgoingServicesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListNexusOutgoingServicesMethod = OperatorServiceGrpc.getListNexusOutgoingServicesMethod) == null) {
          OperatorServiceGrpc.getListNexusOutgoingServicesMethod = getListNexusOutgoingServicesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest, io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListNexusOutgoingServices"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListNexusOutgoingServices"))
              .build();
        }
      }
    }
    return getListNexusOutgoingServicesMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OperatorServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub>() {
        @java.lang.Override
        public OperatorServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceStub(channel, callOptions);
        }
      };
    return OperatorServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OperatorServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub>() {
        @java.lang.Override
        public OperatorServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceBlockingStub(channel, callOptions);
        }
      };
    return OperatorServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OperatorServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub>() {
        @java.lang.Override
        public OperatorServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceFutureStub(channel, callOptions);
        }
      };
    return OperatorServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static abstract class OperatorServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAddSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRemoveSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNamespaceMethod(), responseObserver);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public void addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAddOrUpdateRemoteClusterMethod(), responseObserver);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public void removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRemoveRemoteClusterMethod(), responseObserver);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public void listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListClustersMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a registered incoming Nexus service by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public void getNexusIncomingService(io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetNexusIncomingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public void createNexusIncomingService(io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateNexusIncomingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Optimistically update a Nexus service based on provided version as obtained via the
     * `GetNexusIncomingService` or `ListNexusOutgoingServicesResponse` APIs. This will fail with a status of
     * FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void updateNexusIncomingService(io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateNexusIncomingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public void deleteNexusIncomingService(io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNexusIncomingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all Nexus incoming services for the cluster, sorted by service ID in ascending order. Set page_token in the
     * request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with an ID
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public void listNexusIncomingServices(io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListNexusIncomingServicesMethod(), responseObserver);
    }

    /**
     * <pre>
     * Get a registered outgoing Nexus service by namespace and service name. The returned version can be used for
     * optimistic updates.
     * </pre>
     */
    public void getNexusOutgoingService(io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetNexusOutgoingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void createNexusOutgoingService(io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateNexusOutgoingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Update an outgoing Nexus service by namespace and service name. The version in the request should match the
     * current version of the service. This will fail with a status of FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with the updated version, which can be used for subsequent updates. You don't need
     * to increment the version yourself. The server will increment the version for you.
     * </pre>
     */
    public void updateNexusOutgoingService(io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateNexusOutgoingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delete an outgoing Nexus service by namespace and service name.
     * </pre>
     */
    public void deleteNexusOutgoingService(io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNexusOutgoingServiceMethod(), responseObserver);
    }

    /**
     * <pre>
     * List all Nexus outgoing services for a namespace, sorted by service name in ascending order. Set page_token in
     * the request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with a name
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public void listNexusOutgoingServices(io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListNexusOutgoingServicesMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getAddSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>(
                  this, METHODID_ADD_SEARCH_ATTRIBUTES)))
          .addMethod(
            getRemoveSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>(
                  this, METHODID_REMOVE_SEARCH_ATTRIBUTES)))
          .addMethod(
            getListSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>(
                  this, METHODID_LIST_SEARCH_ATTRIBUTES)))
          .addMethod(
            getDeleteNamespaceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
                io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>(
                  this, METHODID_DELETE_NAMESPACE)))
          .addMethod(
            getAddOrUpdateRemoteClusterMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest,
                io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>(
                  this, METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER)))
          .addMethod(
            getRemoveRemoteClusterMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest,
                io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>(
                  this, METHODID_REMOVE_REMOTE_CLUSTER)))
          .addMethod(
            getListClustersMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListClustersRequest,
                io.temporal.api.operatorservice.v1.ListClustersResponse>(
                  this, METHODID_LIST_CLUSTERS)))
          .addMethod(
            getGetNexusIncomingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest,
                io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse>(
                  this, METHODID_GET_NEXUS_INCOMING_SERVICE)))
          .addMethod(
            getCreateNexusIncomingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest,
                io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse>(
                  this, METHODID_CREATE_NEXUS_INCOMING_SERVICE)))
          .addMethod(
            getUpdateNexusIncomingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest,
                io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse>(
                  this, METHODID_UPDATE_NEXUS_INCOMING_SERVICE)))
          .addMethod(
            getDeleteNexusIncomingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest,
                io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse>(
                  this, METHODID_DELETE_NEXUS_INCOMING_SERVICE)))
          .addMethod(
            getListNexusIncomingServicesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest,
                io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse>(
                  this, METHODID_LIST_NEXUS_INCOMING_SERVICES)))
          .addMethod(
            getGetNexusOutgoingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest,
                io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse>(
                  this, METHODID_GET_NEXUS_OUTGOING_SERVICE)))
          .addMethod(
            getCreateNexusOutgoingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest,
                io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse>(
                  this, METHODID_CREATE_NEXUS_OUTGOING_SERVICE)))
          .addMethod(
            getUpdateNexusOutgoingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest,
                io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse>(
                  this, METHODID_UPDATE_NEXUS_OUTGOING_SERVICE)))
          .addMethod(
            getDeleteNexusOutgoingServiceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest,
                io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse>(
                  this, METHODID_DELETE_NEXUS_OUTGOING_SERVICE)))
          .addMethod(
            getListNexusOutgoingServicesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest,
                io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse>(
                  this, METHODID_LIST_NEXUS_OUTGOING_SERVICES)))
          .build();
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceStub extends io.grpc.stub.AbstractAsyncStub<OperatorServiceStub> {
    private OperatorServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public void addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAddOrUpdateRemoteClusterMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public void removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRemoveRemoteClusterMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public void listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListClustersMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get a registered incoming Nexus service by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public void getNexusIncomingService(io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetNexusIncomingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public void createNexusIncomingService(io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateNexusIncomingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Optimistically update a Nexus service based on provided version as obtained via the
     * `GetNexusIncomingService` or `ListNexusOutgoingServicesResponse` APIs. This will fail with a status of
     * FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void updateNexusIncomingService(io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateNexusIncomingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public void deleteNexusIncomingService(io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNexusIncomingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all Nexus incoming services for the cluster, sorted by service ID in ascending order. Set page_token in the
     * request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with an ID
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public void listNexusIncomingServices(io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListNexusIncomingServicesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Get a registered outgoing Nexus service by namespace and service name. The returned version can be used for
     * optimistic updates.
     * </pre>
     */
    public void getNexusOutgoingService(io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetNexusOutgoingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public void createNexusOutgoingService(io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateNexusOutgoingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Update an outgoing Nexus service by namespace and service name. The version in the request should match the
     * current version of the service. This will fail with a status of FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with the updated version, which can be used for subsequent updates. You don't need
     * to increment the version yourself. The server will increment the version for you.
     * </pre>
     */
    public void updateNexusOutgoingService(io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateNexusOutgoingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delete an outgoing Nexus service by namespace and service name.
     * </pre>
     */
    public void deleteNexusOutgoingService(io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNexusOutgoingServiceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * List all Nexus outgoing services for a namespace, sorted by service name in ascending order. Set page_token in
     * the request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with a name
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public void listNexusOutgoingServices(io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListNexusOutgoingServicesMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<OperatorServiceBlockingStub> {
    private OperatorServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.AddSearchAttributesResponse addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getAddSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getRemoveSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListSearchAttributesResponse listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNamespaceResponse deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNamespaceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse addOrUpdateRemoteCluster(io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request) {
      return blockingUnaryCall(
          getChannel(), getAddOrUpdateRemoteClusterMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse removeRemoteCluster(io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request) {
      return blockingUnaryCall(
          getChannel(), getRemoveRemoteClusterMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListClustersResponse listClusters(io.temporal.api.operatorservice.v1.ListClustersRequest request) {
      return blockingUnaryCall(
          getChannel(), getListClustersMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get a registered incoming Nexus service by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse getNexusIncomingService(io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetNexusIncomingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse createNexusIncomingService(io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getCreateNexusIncomingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Optimistically update a Nexus service based on provided version as obtained via the
     * `GetNexusIncomingService` or `ListNexusOutgoingServicesResponse` APIs. This will fail with a status of
     * FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse updateNexusIncomingService(io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateNexusIncomingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse deleteNexusIncomingService(io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNexusIncomingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all Nexus incoming services for the cluster, sorted by service ID in ascending order. Set page_token in the
     * request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with an ID
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse listNexusIncomingServices(io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListNexusIncomingServicesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Get a registered outgoing Nexus service by namespace and service name. The returned version can be used for
     * optimistic updates.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse getNexusOutgoingService(io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetNexusOutgoingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse createNexusOutgoingService(io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getCreateNexusOutgoingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Update an outgoing Nexus service by namespace and service name. The version in the request should match the
     * current version of the service. This will fail with a status of FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with the updated version, which can be used for subsequent updates. You don't need
     * to increment the version yourself. The server will increment the version for you.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse updateNexusOutgoingService(io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateNexusOutgoingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delete an outgoing Nexus service by namespace and service name.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse deleteNexusOutgoingService(io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNexusOutgoingServiceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * List all Nexus outgoing services for a namespace, sorted by service name in ascending order. Set page_token in
     * the request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with a name
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse listNexusOutgoingServices(io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListNexusOutgoingServicesMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceFutureStub extends io.grpc.stub.AbstractFutureStub<OperatorServiceFutureStub> {
    private OperatorServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> addSearchAttributes(
        io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> removeSearchAttributes(
        io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> listSearchAttributes(
        io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> deleteNamespace(
        io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * AddOrUpdateRemoteCluster adds or updates remote cluster.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse> addOrUpdateRemoteCluster(
        io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAddOrUpdateRemoteClusterMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RemoveRemoteCluster removes remote cluster.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse> removeRemoteCluster(
        io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRemoveRemoteClusterMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ListClusters returns information about Temporal clusters.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListClustersResponse> listClusters(
        io.temporal.api.operatorservice.v1.ListClustersRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListClustersMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get a registered incoming Nexus service by ID. The returned version can be used for optimistic updates.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse> getNexusIncomingService(
        io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetNexusIncomingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse> createNexusIncomingService(
        io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateNexusIncomingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Optimistically update a Nexus service based on provided version as obtained via the
     * `GetNexusIncomingService` or `ListNexusOutgoingServicesResponse` APIs. This will fail with a status of
     * FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with its updated version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse> updateNexusIncomingService(
        io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateNexusIncomingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delete an incoming Nexus service by ID.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse> deleteNexusIncomingService(
        io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNexusIncomingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all Nexus incoming services for the cluster, sorted by service ID in ascending order. Set page_token in the
     * request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with an ID
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse> listNexusIncomingServices(
        io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListNexusIncomingServicesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Get a registered outgoing Nexus service by namespace and service name. The returned version can be used for
     * optimistic updates.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse> getNexusOutgoingService(
        io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetNexusOutgoingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Create a Nexus service. This will fail if a service with the same name already exists in the namespace with a
     * status of ALREADY_EXISTS.
     * Returns the created service with its initial version. You may use this version for subsequent updates. You don't
     * need to increment the version yourself. The server will increment the version for you after each update.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse> createNexusOutgoingService(
        io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateNexusOutgoingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Update an outgoing Nexus service by namespace and service name. The version in the request should match the
     * current version of the service. This will fail with a status of FAILED_PRECONDITION if the version does not match.
     * Returns the updated service with the updated version, which can be used for subsequent updates. You don't need
     * to increment the version yourself. The server will increment the version for you.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse> updateNexusOutgoingService(
        io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateNexusOutgoingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delete an outgoing Nexus service by namespace and service name.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse> deleteNexusOutgoingService(
        io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNexusOutgoingServiceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * List all Nexus outgoing services for a namespace, sorted by service name in ascending order. Set page_token in
     * the request to the next_page_token field of the previous response to get the next page of results. An empty
     * next_page_token indicates that there are no more results. During pagination, a newly added service with a name
     * lexicographically earlier than the previous page's last service name may be missed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse> listNexusOutgoingServices(
        io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListNexusOutgoingServicesMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ADD_SEARCH_ATTRIBUTES = 0;
  private static final int METHODID_REMOVE_SEARCH_ATTRIBUTES = 1;
  private static final int METHODID_LIST_SEARCH_ATTRIBUTES = 2;
  private static final int METHODID_DELETE_NAMESPACE = 3;
  private static final int METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER = 4;
  private static final int METHODID_REMOVE_REMOTE_CLUSTER = 5;
  private static final int METHODID_LIST_CLUSTERS = 6;
  private static final int METHODID_GET_NEXUS_INCOMING_SERVICE = 7;
  private static final int METHODID_CREATE_NEXUS_INCOMING_SERVICE = 8;
  private static final int METHODID_UPDATE_NEXUS_INCOMING_SERVICE = 9;
  private static final int METHODID_DELETE_NEXUS_INCOMING_SERVICE = 10;
  private static final int METHODID_LIST_NEXUS_INCOMING_SERVICES = 11;
  private static final int METHODID_GET_NEXUS_OUTGOING_SERVICE = 12;
  private static final int METHODID_CREATE_NEXUS_OUTGOING_SERVICE = 13;
  private static final int METHODID_UPDATE_NEXUS_OUTGOING_SERVICE = 14;
  private static final int METHODID_DELETE_NEXUS_OUTGOING_SERVICE = 15;
  private static final int METHODID_LIST_NEXUS_OUTGOING_SERVICES = 16;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final OperatorServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(OperatorServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ADD_SEARCH_ATTRIBUTES:
          serviceImpl.addSearchAttributes((io.temporal.api.operatorservice.v1.AddSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_REMOVE_SEARCH_ATTRIBUTES:
          serviceImpl.removeSearchAttributes((io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_LIST_SEARCH_ATTRIBUTES:
          serviceImpl.listSearchAttributes((io.temporal.api.operatorservice.v1.ListSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_DELETE_NAMESPACE:
          serviceImpl.deleteNamespace((io.temporal.api.operatorservice.v1.DeleteNamespaceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>) responseObserver);
          break;
        case METHODID_ADD_OR_UPDATE_REMOTE_CLUSTER:
          serviceImpl.addOrUpdateRemoteCluster((io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddOrUpdateRemoteClusterResponse>) responseObserver);
          break;
        case METHODID_REMOVE_REMOTE_CLUSTER:
          serviceImpl.removeRemoteCluster((io.temporal.api.operatorservice.v1.RemoveRemoteClusterRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveRemoteClusterResponse>) responseObserver);
          break;
        case METHODID_LIST_CLUSTERS:
          serviceImpl.listClusters((io.temporal.api.operatorservice.v1.ListClustersRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListClustersResponse>) responseObserver);
          break;
        case METHODID_GET_NEXUS_INCOMING_SERVICE:
          serviceImpl.getNexusIncomingService((io.temporal.api.operatorservice.v1.GetNexusIncomingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusIncomingServiceResponse>) responseObserver);
          break;
        case METHODID_CREATE_NEXUS_INCOMING_SERVICE:
          serviceImpl.createNexusIncomingService((io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusIncomingServiceResponse>) responseObserver);
          break;
        case METHODID_UPDATE_NEXUS_INCOMING_SERVICE:
          serviceImpl.updateNexusIncomingService((io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusIncomingServiceResponse>) responseObserver);
          break;
        case METHODID_DELETE_NEXUS_INCOMING_SERVICE:
          serviceImpl.deleteNexusIncomingService((io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusIncomingServiceResponse>) responseObserver);
          break;
        case METHODID_LIST_NEXUS_INCOMING_SERVICES:
          serviceImpl.listNexusIncomingServices((io.temporal.api.operatorservice.v1.ListNexusIncomingServicesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusIncomingServicesResponse>) responseObserver);
          break;
        case METHODID_GET_NEXUS_OUTGOING_SERVICE:
          serviceImpl.getNexusOutgoingService((io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.GetNexusOutgoingServiceResponse>) responseObserver);
          break;
        case METHODID_CREATE_NEXUS_OUTGOING_SERVICE:
          serviceImpl.createNexusOutgoingService((io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.CreateNexusOutgoingServiceResponse>) responseObserver);
          break;
        case METHODID_UPDATE_NEXUS_OUTGOING_SERVICE:
          serviceImpl.updateNexusOutgoingService((io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.UpdateNexusOutgoingServiceResponse>) responseObserver);
          break;
        case METHODID_DELETE_NEXUS_OUTGOING_SERVICE:
          serviceImpl.deleteNexusOutgoingService((io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNexusOutgoingServiceResponse>) responseObserver);
          break;
        case METHODID_LIST_NEXUS_OUTGOING_SERVICES:
          serviceImpl.listNexusOutgoingServices((io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListNexusOutgoingServicesResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OperatorServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.temporal.api.operatorservice.v1.ServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OperatorService");
    }
  }

  private static final class OperatorServiceFileDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier {
    OperatorServiceFileDescriptorSupplier() {}
  }

  private static final class OperatorServiceMethodDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    OperatorServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OperatorServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OperatorServiceFileDescriptorSupplier())
              .addMethod(getAddSearchAttributesMethod())
              .addMethod(getRemoveSearchAttributesMethod())
              .addMethod(getListSearchAttributesMethod())
              .addMethod(getDeleteNamespaceMethod())
              .addMethod(getAddOrUpdateRemoteClusterMethod())
              .addMethod(getRemoveRemoteClusterMethod())
              .addMethod(getListClustersMethod())
              .addMethod(getGetNexusIncomingServiceMethod())
              .addMethod(getCreateNexusIncomingServiceMethod())
              .addMethod(getUpdateNexusIncomingServiceMethod())
              .addMethod(getDeleteNexusIncomingServiceMethod())
              .addMethod(getListNexusIncomingServicesMethod())
              .addMethod(getGetNexusOutgoingServiceMethod())
              .addMethod(getCreateNexusOutgoingServiceMethod())
              .addMethod(getUpdateNexusOutgoingServiceMethod())
              .addMethod(getDeleteNexusOutgoingServiceMethod())
              .addMethod(getListNexusOutgoingServicesMethod())
              .build();
        }
      }
    }
    return result;
  }
}
