/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.operatorservice.v1.AddSearchAttributesRequest;
import io.temporal.api.operatorservice.v1.AddSearchAttributesResponse;
import io.temporal.api.operatorservice.v1.OperatorServiceGrpc;
import io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest;
import io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse;
import io.temporal.internal.testservice.TestVisibilityStore;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestOperatorService
extends OperatorServiceGrpc.OperatorServiceImplBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TestOperatorService.class);
    private final TestVisibilityStore visibilityStore;

    public TestOperatorService(TestVisibilityStore visibilityStore) {
        this.visibilityStore = visibilityStore;
    }

    public void addSearchAttributes(AddSearchAttributesRequest request, StreamObserver<AddSearchAttributesResponse> responseObserver) {
        try {
            Map<String, IndexedValueType> registeredSearchAttributes = this.visibilityStore.getRegisteredSearchAttributes();
            request.getSearchAttributesMap().keySet().stream().filter(registeredSearchAttributes::containsKey).findFirst().ifPresent(sa -> {
                throw Status.ALREADY_EXISTS.withDescription("Search attribute " + sa + " already exists.").asRuntimeException();
            });
            request.getSearchAttributesMap().forEach(this.visibilityStore::addSearchAttribute);
            responseObserver.onNext((Object)AddSearchAttributesResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    public void removeSearchAttributes(RemoveSearchAttributesRequest request, StreamObserver<RemoveSearchAttributesResponse> responseObserver) {
        try {
            Map<String, IndexedValueType> registeredSearchAttributes = this.visibilityStore.getRegisteredSearchAttributes();
            request.getSearchAttributesList().stream().filter(k -> !registeredSearchAttributes.containsKey(k)).findFirst().ifPresent(sa -> {
                throw Status.NOT_FOUND.withDescription("Search attribute " + sa + " doesn't exist.").asRuntimeException();
            });
            request.getSearchAttributesList().forEach(this.visibilityStore::removeSearchAttribute);
            responseObserver.onNext((Object)RemoveSearchAttributesResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (StatusRuntimeException e) {
            this.handleStatusRuntimeException(e, responseObserver);
        }
    }

    private void handleStatusRuntimeException(StatusRuntimeException e, StreamObserver<?> responseObserver) {
        if (e.getStatus().getCode() == Status.Code.INTERNAL) {
            log.error("unexpected", (Throwable)e);
        }
        responseObserver.onError((Throwable)e);
    }

    @Override
    public void close() {
    }
}

