/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import com.google.protobuf.Timestamp;
import io.grpc.Deadline;
import io.temporal.api.workflow.v1.WorkflowExecutionInfo;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.internal.testservice.ExecutionId;
import io.temporal.internal.testservice.RequestContext;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

interface TestWorkflowStore {
    public Timestamp currentTime();

    public long save(RequestContext var1);

    public void applyTimersAndLocks(RequestContext var1);

    public void registerDelayedCallback(Duration var1, Runnable var2);

    public Future<PollWorkflowTaskQueueResponse.Builder> pollWorkflowTaskQueue(PollWorkflowTaskQueueRequest var1);

    public Future<PollActivityTaskQueueResponse.Builder> pollActivityTaskQueue(PollActivityTaskQueueRequest var1);

    public void sendQueryTask(ExecutionId var1, TaskQueueId var2, PollWorkflowTaskQueueResponse.Builder var3);

    public GetWorkflowExecutionHistoryResponse getWorkflowExecutionHistory(ExecutionId var1, GetWorkflowExecutionHistoryRequest var2, Deadline var3);

    public void getDiagnostics(StringBuilder var1);

    public List<WorkflowExecutionInfo> listWorkflows(WorkflowState var1, Optional<String> var2);

    public void close();

    public static class ActivityTask {
        private final TaskQueueId taskQueueId;
        private final PollActivityTaskQueueResponse.Builder task;

        public ActivityTask(TaskQueueId taskQueueId, PollActivityTaskQueueResponse.Builder task) {
            this.taskQueueId = taskQueueId;
            this.task = task;
        }

        public TaskQueueId getTaskQueueId() {
            return this.taskQueueId;
        }

        public PollActivityTaskQueueResponse.Builder getTask() {
            return this.task;
        }
    }

    public static class WorkflowTask {
        private final TaskQueueId taskQueueId;
        private final PollWorkflowTaskQueueResponse.Builder task;

        public WorkflowTask(TaskQueueId taskQueueId, PollWorkflowTaskQueueResponse.Builder task) {
            this.taskQueueId = taskQueueId;
            this.task = task;
        }

        public TaskQueueId getTaskQueueId() {
            return this.taskQueueId;
        }

        public PollWorkflowTaskQueueResponse.Builder getTask() {
            return this.task;
        }
    }

    public static class TaskQueueId {
        private final String namespace;
        private final String taskQueueName;

        public TaskQueueId(String namespace, String taskQueueName) {
            this.namespace = Objects.requireNonNull(namespace);
            this.taskQueueName = Objects.requireNonNull(taskQueueName);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTaskQueueName() {
            return this.taskQueueName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskQueueId)) {
                return false;
            }
            TaskQueueId that = (TaskQueueId)o;
            if (!this.namespace.equals(that.namespace)) {
                return false;
            }
            return this.taskQueueName.equals(that.taskQueueName);
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.taskQueueName.hashCode();
            return result;
        }

        public String toString() {
            return "TaskQueueId{namespace='" + this.namespace + '\'' + ", taskQueueName='" + this.taskQueueName + '\'' + '}';
        }
    }

    public static enum WorkflowState {
        OPEN,
        CLOSED;

    }
}

