/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.constgen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.tesler.constgen.Constant;
import io.tesler.constgen.DtoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class CodeGenerator {
    private final TypeElement typeElement;
    private final Element superclass;
    private final Elements elements;
    private final String packageName;
    private final String className;

    CodeGenerator(TypeElement typeElement, Element superclass, Elements elements) {
        this.typeElement = typeElement;
        this.superclass = superclass;
        this.elements = elements;
        this.packageName = elements.getPackageOf(typeElement).getQualifiedName().toString();
        this.className = typeElement.getSimpleName() + "_";
    }

    private static boolean isStatic(VariableElement el) {
        return el.getModifiers().contains((Object)Modifier.STATIC);
    }

    JavaFile generate() {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.className);
        if (this.superclass != null) {
            classBuilder.superclass((TypeName)ClassName.get((String)this.elements.getPackageOf(this.superclass).getQualifiedName().toString(), (String)(this.superclass.getSimpleName() + "_"), (String[])new String[0]));
        }
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Constant constant : this.collectFields()) {
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(DtoField.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.typeElement.asType()), constant.getType()});
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)parameterizedTypeName, (String)constant.getName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new DtoField($S)", new Object[]{constant.getName()}).build();
            classBuilder.addField(fieldSpec);
        }
        return JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build();
    }

    private List<Constant> collectFields() {
        ArrayList<Constant> fields = new ArrayList<Constant>();
        for (Element element : this.typeElement.getEnclosedElements()) {
            VariableElement varEl;
            if (element.getKind() != ElementKind.FIELD || this.isTransient(varEl = (VariableElement)element) || CodeGenerator.isStatic(varEl)) continue;
            fields.add(new Constant(element.getSimpleName().toString(), TypeName.get((TypeMirror)varEl.asType()).box()));
        }
        Collections.sort(fields);
        return fields;
    }

    private boolean isTransient(VariableElement el) {
        for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(el)) {
            Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!qualifiedName.contentEquals("io.tesler.constgen.DtoMetamodelIgnore")) continue;
            return true;
        }
        return false;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }
}

