/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.dto;

import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.core.util.filter.SearchParameter;
import io.tesler.vanilla.dto.validators.KppConstraint;
import io.tesler.vanilla.entity.VanillaCounterparty;
import java.time.LocalDateTime;
import java.util.Random;

public class VanillaResidentDTO
extends DataResponseDTO {
    private String country;
    private String counterpartyType;
    @SearchParameter(name="legalPersonShortName")
    private String legalPersonName;
    private String ogrn;
    private LocalDateTime registrationDate;
    @SearchParameter
    private String inn;
    private String legalAddress;
    @SearchParameter
    @KppConstraint(message="{error.validation.kpp}")
    private String kpp;
    private String okpo;
    private String opf;
    private String account;
    private boolean ufr;
    private String legalPersonNamebgColor;
    private String drllDwnWthSrchSpc;
    private String okato;
    private String legalAddressDrillDown;
    private Boolean testCheckbox;
    private String testInput;
    private String testText;
    private int testPercent;
    private Double testFractional;
    private Double testNumber;
    private Double testMoney;
    private String intendModeBgColor;
    private LocalDateTime testDate;
    private LocalDateTime testDateTime;
    private LocalDateTime testDateTimeWithSeconds;
    private LocalDateTime testMonthYear;
    private String testDictionary;
    private String testPickList;

    public VanillaResidentDTO(VanillaCounterparty sourceEntity) {
        this.id = sourceEntity.getId().toString();
        this.legalPersonName = sourceEntity.getLegalPersonShortName();
        this.ogrn = sourceEntity.getOgrn();
        this.registrationDate = sourceEntity.getRegistrationDate();
        this.inn = sourceEntity.getInn();
        this.legalAddress = sourceEntity.getLegalAddress();
        this.kpp = sourceEntity.getKpp();
        this.okpo = sourceEntity.getOkpo();
        this.opf = sourceEntity.getOpfName();
        this.country = sourceEntity.getCountryName();
        this.account = sourceEntity.getAccount();
        this.drllDwnWthSrchSpc = "\u0417\u0430\u0434\u0430\u0447\u0438 \u0441 \u0432\u043e\u0441\u044c\u043c\u0435\u0440\u043a\u043e\u0439";
        Random rand = new Random();
        String[] okatoArray = new String[]{"41", "42", "90", "67", "94", "85", "39", "37", "82", "34", "69"};
        this.okato = okatoArray[rand.nextInt(10)];
        this.legalAddressDrillDown = "screen/vanilla/view/vanilla/legalResidentVanilla/" + sourceEntity.getId().toString();
        if (this.id.length() >= 1) {
            this.legalPersonNamebgColor = "#f9ec49";
        }
        if (this.id.length() >= 2) {
            this.legalPersonNamebgColor = "#ff9999";
        }
        this.intendModeBgColor = "#E9E967";
        this.testInput = "\u0422\u0435\u043a\u0441\u0442";
        this.testText = "\u041c\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430";
        this.testCheckbox = true;
        this.testDictionary = "\u0421\u0430\u043c\u043e\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435";
        this.testPickList = null;
        int SCALE = 100;
        this.testFractional = (double)SCALE * rand.nextDouble();
        this.testNumber = (double)(-SCALE) + (double)(2 * SCALE) * rand.nextDouble();
        this.testPercent = rand.nextInt(SCALE);
        this.testMoney = 1.2345678901289E11;
        this.testDate = sourceEntity.getRegistrationDate();
        this.testDateTime = sourceEntity.getRegistrationDate();
        this.testDateTimeWithSeconds = sourceEntity.getRegistrationDate();
        this.testMonthYear = sourceEntity.getRegistrationDate();
    }

    public VanillaResidentDTO() {
    }

    public String getCountry() {
        return this.country;
    }

    public String getCounterpartyType() {
        return this.counterpartyType;
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public String getOgrn() {
        return this.ogrn;
    }

    public LocalDateTime getRegistrationDate() {
        return this.registrationDate;
    }

    public String getInn() {
        return this.inn;
    }

    public String getLegalAddress() {
        return this.legalAddress;
    }

    public String getKpp() {
        return this.kpp;
    }

    public String getOkpo() {
        return this.okpo;
    }

    public String getOpf() {
        return this.opf;
    }

    public String getAccount() {
        return this.account;
    }

    public boolean isUfr() {
        return this.ufr;
    }

    public String getLegalPersonNamebgColor() {
        return this.legalPersonNamebgColor;
    }

    public String getDrllDwnWthSrchSpc() {
        return this.drllDwnWthSrchSpc;
    }

    public String getOkato() {
        return this.okato;
    }

    public String getLegalAddressDrillDown() {
        return this.legalAddressDrillDown;
    }

    public Boolean getTestCheckbox() {
        return this.testCheckbox;
    }

    public String getTestInput() {
        return this.testInput;
    }

    public String getTestText() {
        return this.testText;
    }

    public int getTestPercent() {
        return this.testPercent;
    }

    public Double getTestFractional() {
        return this.testFractional;
    }

    public Double getTestNumber() {
        return this.testNumber;
    }

    public Double getTestMoney() {
        return this.testMoney;
    }

    public String getIntendModeBgColor() {
        return this.intendModeBgColor;
    }

    public LocalDateTime getTestDate() {
        return this.testDate;
    }

    public LocalDateTime getTestDateTime() {
        return this.testDateTime;
    }

    public LocalDateTime getTestDateTimeWithSeconds() {
        return this.testDateTimeWithSeconds;
    }

    public LocalDateTime getTestMonthYear() {
        return this.testMonthYear;
    }

    public String getTestDictionary() {
        return this.testDictionary;
    }

    public String getTestPickList() {
        return this.testPickList;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCounterpartyType(String counterpartyType) {
        this.counterpartyType = counterpartyType;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public void setOgrn(String ogrn) {
        this.ogrn = ogrn;
    }

    public void setRegistrationDate(LocalDateTime registrationDate) {
        this.registrationDate = registrationDate;
    }

    public void setInn(String inn) {
        this.inn = inn;
    }

    public void setLegalAddress(String legalAddress) {
        this.legalAddress = legalAddress;
    }

    public void setKpp(String kpp) {
        this.kpp = kpp;
    }

    public void setOkpo(String okpo) {
        this.okpo = okpo;
    }

    public void setOpf(String opf) {
        this.opf = opf;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setUfr(boolean ufr) {
        this.ufr = ufr;
    }

    public void setLegalPersonNamebgColor(String legalPersonNamebgColor) {
        this.legalPersonNamebgColor = legalPersonNamebgColor;
    }

    public void setDrllDwnWthSrchSpc(String drllDwnWthSrchSpc) {
        this.drllDwnWthSrchSpc = drllDwnWthSrchSpc;
    }

    public void setOkato(String okato) {
        this.okato = okato;
    }

    public void setLegalAddressDrillDown(String legalAddressDrillDown) {
        this.legalAddressDrillDown = legalAddressDrillDown;
    }

    public void setTestCheckbox(Boolean testCheckbox) {
        this.testCheckbox = testCheckbox;
    }

    public void setTestInput(String testInput) {
        this.testInput = testInput;
    }

    public void setTestText(String testText) {
        this.testText = testText;
    }

    public void setTestPercent(int testPercent) {
        this.testPercent = testPercent;
    }

    public void setTestFractional(Double testFractional) {
        this.testFractional = testFractional;
    }

    public void setTestNumber(Double testNumber) {
        this.testNumber = testNumber;
    }

    public void setTestMoney(Double testMoney) {
        this.testMoney = testMoney;
    }

    public void setIntendModeBgColor(String intendModeBgColor) {
        this.intendModeBgColor = intendModeBgColor;
    }

    public void setTestDate(LocalDateTime testDate) {
        this.testDate = testDate;
    }

    public void setTestDateTime(LocalDateTime testDateTime) {
        this.testDateTime = testDateTime;
    }

    public void setTestDateTimeWithSeconds(LocalDateTime testDateTimeWithSeconds) {
        this.testDateTimeWithSeconds = testDateTimeWithSeconds;
    }

    public void setTestMonthYear(LocalDateTime testMonthYear) {
        this.testMonthYear = testMonthYear;
    }

    public void setTestDictionary(String testDictionary) {
        this.testDictionary = testDictionary;
    }

    public void setTestPickList(String testPickList) {
        this.testPickList = testPickList;
    }
}

