/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.dto;

import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.vanilla.entity.VanillaSupervisoryFact;
import java.time.LocalDateTime;

public class VanillaSupFactDTO
extends DataResponseDTO {
    private LocalDateTime detectionDate;
    private String initiator;
    private String name;
    private LocalDateTime commissionDate;
    private String status;
    private String priority;
    private Number someIndex;
    private String someDrillDown;

    public VanillaSupFactDTO(VanillaSupervisoryFact supervisoryFact) {
        this.id = supervisoryFact.getId().toString();
        this.detectionDate = supervisoryFact.getDetectionDate();
        this.initiator = supervisoryFact.getInitiator() != null ? supervisoryFact.getInitiator().getLastName() + " " + supervisoryFact.getInitiator().getFirstName() : null;
        this.name = supervisoryFact.getName();
        this.commissionDate = supervisoryFact.getCommissionDate();
        this.status = DictionaryType.SUPERVISORY_FACT_STATUS.lookupValue(supervisoryFact.getStatus());
        this.priority = DictionaryType.TASK_PRIORITY.lookupValue(supervisoryFact.getPriority());
        this.someIndex = Math.random() * 100.0;
        this.someDrillDown = "screen/vanilla/view/vanilla2//legalResidentVanilla/?filters=eyJsZWdhbFJlc2lkZW50VmFuaWxsYSI6ICJsZWdhbFBlcnNvbk5hbWUuY29udGFpbnM90JDQniJ9";
    }

    public LocalDateTime getDetectionDate() {
        return this.detectionDate;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getCommissionDate() {
        return this.commissionDate;
    }

    public String getStatus() {
        return this.status;
    }

    public String getPriority() {
        return this.priority;
    }

    public Number getSomeIndex() {
        return this.someIndex;
    }

    public String getSomeDrillDown() {
        return this.someDrillDown;
    }

    public void setDetectionDate(LocalDateTime detectionDate) {
        this.detectionDate = detectionDate;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCommissionDate(LocalDateTime commissionDate) {
        this.commissionDate = commissionDate;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setSomeIndex(Number someIndex) {
        this.someIndex = someIndex;
    }

    public void setSomeDrillDown(String someDrillDown) {
        this.someDrillDown = someDrillDown;
    }

    public VanillaSupFactDTO() {
    }
}

