/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.dto;

import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.data.dto.TZAware;
import io.tesler.core.dto.Lov;
import io.tesler.core.util.filter.SearchParameter;
import io.tesler.core.util.filter.SearchParameterType;
import io.tesler.vanilla.entity.VanillaTask;
import java.time.LocalDateTime;

public class VanillaTaskDTO
extends DataResponseDTO {
    @SearchParameter(name="supervisedOrg.legalPersonShortName")
    private String legalPersonName;
    private String activityType;
    @SearchParameter(type=SearchParameterType.LOV)
    @Lov(value=DictionaryType.TASK_CATEGORY)
    private String taskCategory;
    @SearchParameter(type=SearchParameterType.LOV)
    @Lov(value=DictionaryType.TASK_TYPE)
    private String taskType;
    @SearchParameter
    private String name;
    @SearchParameter(type=SearchParameterType.LOV)
    @Lov(value=DictionaryType.TASK_PRIORITY)
    private String priority;
    private String job;
    @SearchParameter(type=SearchParameterType.DATE)
    private String reportPeriod;
    @SearchParameter(type=SearchParameterType.DATE)
    private LocalDateTime reportDate;
    private Boolean supervisedMonitor;
    private String result;
    @SearchParameter(type=SearchParameterType.DATE)
    private LocalDateTime planDate;
    private String periodicalType;
    private String executor;
    private String executorName;
    private Long executorId;
    @TZAware
    @SearchParameter(type=SearchParameterType.DATE)
    private LocalDateTime createDate;
    private String fileName;
    private String fileId;
    private Double fund;
    private String taskStatus;
    private Boolean isExecute;
    private Boolean bcDisabledFlg;
    private String priorityBgColor;
    private String nameBgColor;
    private String iconParams;
    private String comboConditionTest;
    private Double moneyInputTest;
    private Long numberInputTest;
    private Double decimalInputTest;
    private Long percentInputTest;
    private String longInputTest;
    private String editor;
    private String icon;

    public VanillaTaskDTO(VanillaTask task) {
        this.id = task.getId().toString();
        this.activityType = task.getActivityType() != null ? task.getActivityType().getKey() : null;
        this.job = task.getJob();
        this.supervisedMonitor = task.getSupervisedMonitor();
        this.result = task.getResult();
        this.reportDate = task.getReportDate();
        this.name = task.getName();
        this.planDate = task.getPlanDate();
        this.executor = task.getExecutor() != null ? task.getExecutor().getFullName() : null;
        this.executorName = task.getExecutor() != null ? task.getExecutor().getFullName() : null;
        this.createDate = task.getCreateDate();
        this.reportPeriod = DictionaryType.REPORT_PERIOD.lookupValue(task.getReportPeriod());
        this.taskType = DictionaryType.TASK_TYPE.lookupValue(task.getTaskType());
        this.taskCategory = DictionaryType.TASK_CATEGORY.lookupValue(task.getTaskCategory());
        this.priority = DictionaryType.TASK_PRIORITY.lookupValue(task.getPriority());
        this.periodicalType = DictionaryType.PERIODICAL_TYPE.lookupValue(task.getPeriodicalType());
        this.fileName = task.getFileEntity() != null ? task.getFileEntity().getFileName() : null;
        this.fileId = task.getFileEntity() != null ? task.getFileEntity().getId().toString() : null;
        this.fund = 1.2345678901289E11;
        this.taskStatus = DictionaryType.TASK_STATUS.lookupValue(task.getTaskStatus());
        this.isExecute = task.getIsExecute();
        this.bcDisabledFlg = task.getBcDisabledFlg();
        this.comboConditionTest = task.getComboConditionTest();
        this.moneyInputTest = task.getMoneyInputTest();
        this.numberInputTest = task.getNumberInputTest();
        this.decimalInputTest = task.getDecimalInputTest();
        this.percentInputTest = task.getPercentInputTest();
        this.icon = task.getIcon();
        if (task.getPriority() != null && task.getPriority().getKey() != null) {
            switch (task.getPriority().getKey()) {
                case "LOW": {
                    this.priorityBgColor = "#6fff4f";
                    this.iconParams = "arrow-down green";
                    break;
                }
                case "MIDDLE": {
                    this.priorityBgColor = "#e7ff4f";
                    this.iconParams = "arrow-up orange";
                    break;
                }
                case "HIGH": {
                    this.priorityBgColor = "#ff4f4f";
                    this.iconParams = "arrow-up red";
                    break;
                }
            }
        }
        this.nameBgColor = "#9c27b0a8";
        if (task.getSuperVisedOrg() != null) {
            this.setLegalPersonName(task.getSuperVisedOrg().getLegalPersonShortName());
        }
        this.setLongInputTest("vanilla");
        this.editor = "<h1 style=\"z-index:auto;\">\u0411\u043e\u043b\u044c\u0448\u043e\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a</h1>\n \n<p>\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u043d\u0430 \u0444\u0440\u043e\u043d\u0442\u0435. (\u041f\u043e\u043c\u0435\u043d\u044f\u0442\u044c \u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u0438 \u0441\u0442\u0440\u043e\u043a\u0438 \u043c\u0435\u0441\u0442\u0430\u043c\u0438)</p>\n \n<p>\u0412\u0432\u043e\u0434\u0438\u043c <del style=\"z-index:auto;\">\u043d\u043e\u0432\u044b\u0439</del> \u0442\u0438\u043f <i>\u0432\u0438\u0434\u0436\u0435\u0442\u0430</i> \u043d\u0430 <u>\u0444\u0440\u043e\u043d\u0442\u0435</u>. (\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, <b>pivot</b>)</p>\n \n<h2 style=\"z-index:auto;\">\u0422\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f</h2>\n \n<h3 style=\"z-index:auto;\">\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f:</h3>\n \n<ol>\n<li>\u041a\u043e\u043b\u043e\u043d\u043a\u0438 \u0438 \u0441\u0442\u0440\u043e\u043a\u0438 \u043c\u0435\u043d\u044f\u0435\u043c \u043c\u0435\u0441\u0442\u0430\u043c\u0438 (\u0441\u043c. \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0443 [\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b])</li>\n<li>\u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u044b \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f, \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c \u0442\u0430\u043a \u0436\u0435 \u043a\u0430\u043a \u0438 \u0440\u0430\u043d\u044c\u0448\u0435, \u043f\u043e\u044d\u0442\u043e\u043c\u0443 <b>\u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u043f\u043e \u043a\u043e\u043b\u043e\u043d\u043a\u0430\u043c</b>, \u043d\u0430 1 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0430\u0442\u0430 \u0441 01.09.2017 \u043f\u043e 31.09.2017, \u043f\u0440\u0438 \u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u0438, \u043a\u0430\u043a \u0431\u0443\u0434\u0442\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u0435\u043c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (\u0441\u043c [\u041f\u0440\u0438\u043c\u0435\u0440 \u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u0438])</li>\n<li>\u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u0440\u0441\u043e\u0440\u0430 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u0432\u044f\u0437\u043d\u043e\u0441\u0442\u0438 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e \u043a\u043e\u043b\u043e\u043d\u043a\u0430\u043c</li>\n<li>\u0432\u0445\u043e\u0434\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f</li>\n<li>\u0437\u0430\u043f\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u0440\u0438\u0445\u043e\u0434\u044f\u0442 \u0441 \u0431\u0435\u043a\u0435\u043d\u0434\u0430 (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u0442\u0440\u043e\u0438\u0442\u0441\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438)</li>\n</ol>\n \n<hr />\n<p>\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f:</p>\n \n<ol>\n<li>\u0412\u0438\u0434\u0435\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0432 \u0440\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u043e\u043c \u0432\u0438\u0434\u0435 (\u043d\u0430 \u0432\u0435\u0441\u044c \u044d\u043a\u0440\u0430\u043d)</li>\n<li>\u043f\u0440\u0438 \u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u0438 \u043b\u0438\u0441\u0442\u0430\u0435\u043c \u043a\u043e\u043b\u043e\u043d\u043a\u0438 (\u0441\u043c [\u041f\u0440\u0438\u043c\u0435\u0440 \u043f\u0430\u0433\u0438\u043d\u0430\u0446\u0438\u0438])</li>\n<li>\n<p style=\"z-index:auto;\"><del style=\"z-index:auto;\">??? \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043c\u0430\u0440\u043a\u0435\u0440\u044b \u0440\u043e\u0441\u0442\u0430/\u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u044f </del></p>\n</li>\n<li>??? \u0430\u0433\u0440\u0435\u0433\u0430\u0446\u0438\u044f \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0430\u043c \u0438 \u043f\u043e\u043b\u044f\u043c (\u0441\u043c [\u0410\u0433\u0440\u0435\u0433\u0430\u0446\u0438\u044f \u043d\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0438? \u0442\u0430\u0431\u043b\u0438\u0446\u0435])</li>\n<li>\u0413\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u0430 \u0438 \u0441\u043a\u0440\u044b\u0442\u0438\u0435(toggle) \u0441\u0442\u0440\u043e\u043a</li>\n<li>DrillDown \u043d\u0430 SearchSpec</li>\n<li> \u0412\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0446\u0432\u0435\u0442\u043e\u043c \u0432\u043c\u0435\u0441\u0442\u043e 3</li>\n</ol>\n \n<h3 style=\"z-index:auto;\">\u041d\u0435\u043d\u0443\u043c\u0435\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a</h3>\n \n<ul>\n<li>\u044d\u043b\u0435\u043c\u0435\u043d\u0442 1</li>\n<li>\u044d\u043b\u0435\u043c\u0435\u043d\u0442 2</li>\n</ul>\n \n<blockquote>\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diem nonummy nibh euismod tincidunt ut lacreet dolore magna aliguam erat volutpat. Ut wisis enim ad minim veniam, quis nostrud exerci tution ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.</p>\n</blockquote>";
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getTaskCategory() {
        return this.taskCategory;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getName() {
        return this.name;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getJob() {
        return this.job;
    }

    public String getReportPeriod() {
        return this.reportPeriod;
    }

    public LocalDateTime getReportDate() {
        return this.reportDate;
    }

    public Boolean getSupervisedMonitor() {
        return this.supervisedMonitor;
    }

    public String getResult() {
        return this.result;
    }

    public LocalDateTime getPlanDate() {
        return this.planDate;
    }

    public String getPeriodicalType() {
        return this.periodicalType;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public Long getExecutorId() {
        return this.executorId;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public Double getFund() {
        return this.fund;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public Boolean getIsExecute() {
        return this.isExecute;
    }

    public Boolean getBcDisabledFlg() {
        return this.bcDisabledFlg;
    }

    public String getPriorityBgColor() {
        return this.priorityBgColor;
    }

    public String getNameBgColor() {
        return this.nameBgColor;
    }

    public String getIconParams() {
        return this.iconParams;
    }

    public String getComboConditionTest() {
        return this.comboConditionTest;
    }

    public Double getMoneyInputTest() {
        return this.moneyInputTest;
    }

    public Long getNumberInputTest() {
        return this.numberInputTest;
    }

    public Double getDecimalInputTest() {
        return this.decimalInputTest;
    }

    public Long getPercentInputTest() {
        return this.percentInputTest;
    }

    public String getLongInputTest() {
        return this.longInputTest;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public void setTaskCategory(String taskCategory) {
        this.taskCategory = taskCategory;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void setReportPeriod(String reportPeriod) {
        this.reportPeriod = reportPeriod;
    }

    public void setReportDate(LocalDateTime reportDate) {
        this.reportDate = reportDate;
    }

    public void setSupervisedMonitor(Boolean supervisedMonitor) {
        this.supervisedMonitor = supervisedMonitor;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setPlanDate(LocalDateTime planDate) {
        this.planDate = planDate;
    }

    public void setPeriodicalType(String periodicalType) {
        this.periodicalType = periodicalType;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public void setExecutorId(Long executorId) {
        this.executorId = executorId;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setFund(Double fund) {
        this.fund = fund;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setIsExecute(Boolean isExecute) {
        this.isExecute = isExecute;
    }

    public void setBcDisabledFlg(Boolean bcDisabledFlg) {
        this.bcDisabledFlg = bcDisabledFlg;
    }

    public void setPriorityBgColor(String priorityBgColor) {
        this.priorityBgColor = priorityBgColor;
    }

    public void setNameBgColor(String nameBgColor) {
        this.nameBgColor = nameBgColor;
    }

    public void setIconParams(String iconParams) {
        this.iconParams = iconParams;
    }

    public void setComboConditionTest(String comboConditionTest) {
        this.comboConditionTest = comboConditionTest;
    }

    public void setMoneyInputTest(Double moneyInputTest) {
        this.moneyInputTest = moneyInputTest;
    }

    public void setNumberInputTest(Long numberInputTest) {
        this.numberInputTest = numberInputTest;
    }

    public void setDecimalInputTest(Double decimalInputTest) {
        this.decimalInputTest = decimalInputTest;
    }

    public void setPercentInputTest(Long percentInputTest) {
        this.percentInputTest = percentInputTest;
    }

    public void setLongInputTest(String longInputTest) {
        this.longInputTest = longInputTest;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public VanillaTaskDTO() {
    }
}

