/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.service;

import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.service.rowmeta.BcDisabler;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.vanilla.VanillaServiceAssociation;
import io.tesler.vanilla.entity.VanillaTask;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;

@Service
public class VanillaBcDisabler
extends BcDisabler {
    private final JpaDao jpaDao;

    public Collection<BcIdentifier> getSupportedBc() {
        return Collections.singletonList(VanillaServiceAssociation.bcExample);
    }

    public boolean isBcDisabled(BusinessComponent bc) {
        if (bc.getId() == null) {
            return false;
        }
        VanillaTask task = (VanillaTask)this.jpaDao.findById(VanillaTask.class, bc.getIdAsLong());
        return BooleanUtils.isTrue((Boolean)task.getBcDisabledFlg());
    }

    protected boolean isActionDisabled(String actionName) {
        return true;
    }

    public VanillaBcDisabler(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

