/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.service.action;

import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.exception.BusinessException;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.vanilla.dto.VanillaTaskDTO;
import io.tesler.vanilla.entity.VanillaTask;
import org.springframework.stereotype.Service;

@Service
public class VanillaTaskActionDownloadFile {
    private final JpaDao jpaDao;

    public boolean fileExists(BusinessComponent bc) {
        if (bc.getIdAsLong() == null) {
            return false;
        }
        VanillaTask task = (VanillaTask)this.jpaDao.findById(VanillaTask.class, bc.getIdAsLong());
        return task != null && task.getFileEntity() != null;
    }

    public ActionResultDTO<VanillaTaskDTO> downloadFile(BusinessComponent bc, VanillaTaskDTO data) {
        if (data.getFileId() == null) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.file_not_found"));
        }
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.downloadFile((String)data.getFileId()));
    }

    public VanillaTaskActionDownloadFile(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

