/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.service.data.impl;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.ResultPage;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.core.controller.param.QueryParameters;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.DrillDownType;
import io.tesler.core.dto.MessageType;
import io.tesler.core.dto.multivalue.MultivalueField;
import io.tesler.core.dto.multivalue.MultivalueFieldSingleValue;
import io.tesler.core.dto.multivalue.MultivalueOptionType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.dto.rowmeta.PreAction;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.action.ActionIcon;
import io.tesler.core.service.action.ActionScope;
import io.tesler.core.service.action.Actions;
import io.tesler.core.service.action.PreActionCondition;
import io.tesler.core.service.action.PreActionEvent;
import io.tesler.model.core.entity.AbstractEntity;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.FileEntity;
import io.tesler.vanilla.VanillaServiceAssociation;
import io.tesler.vanilla.dto.VanillaDocDTO;
import io.tesler.vanilla.dto.VanillaDocDTO_;
import io.tesler.vanilla.entity.VanillaFileEntity;
import io.tesler.vanilla.entity.VanillaTask;
import io.tesler.vanilla.entity.VanillaTaskRelatedRecord;
import io.tesler.vanilla.entity.VanillaTaskRelatedRecord_;
import io.tesler.vanilla.entity.VanillaTask_;
import io.tesler.vanilla.service.action.VanillaPreActionCondition;
import io.tesler.vanilla.service.action.VanillaPreActionConditionHolder;
import io.tesler.vanilla.service.data.VanillaDocService;
import io.tesler.vanilla.service.meta.VanillaDocFieldMetaBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;

@Service
public class VanillaDocServiceImpl
extends VersionAwareResponseService<VanillaDocDTO, VanillaTask>
implements VanillaDocService {
    @Autowired
    private VanillaPreActionCondition condition;

    public VanillaDocServiceImpl() {
        super(VanillaDocDTO.class, VanillaTask.class, null, VanillaDocFieldMetaBuilder.class);
        this.preActionConditionHolderDataResponse = VanillaPreActionConditionHolder.class;
    }

    public ResultPage<VanillaDocDTO> getList(BusinessComponent bc) {
        QueryParameters params = bc.getParameters();
        if (VanillaServiceAssociation.bcPagination.isBc((BcIdentifier)bc)) {
            return this.entitiesToDtos(bc, this.baseDAO.getList(VanillaTask.class, VanillaDocDTO.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]), params));
        }
        ResultPage resultPage = this.entitiesToDtos(bc, this.baseDAO.getList(VanillaTask.class, VanillaDocDTO.class, (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]), params));
        resultPage.getResult().forEach(task -> task.setCreatedDate(params.getDateTo()));
        return resultPage;
    }

    private MultivalueField getMultivalue(VanillaDocDTO dto) {
        List relatedRecords = this.baseDAO.getList(VanillaTaskRelatedRecord.class, (Specification)Specifications.where((Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(VanillaTaskRelatedRecord_.parTaskId), (Object)NumberUtils.createLong((String)dto.getId()))));
        if (!relatedRecords.isEmpty()) {
            List relatedIds = relatedRecords.stream().map(VanillaTaskRelatedRecord::getChildId).collect(Collectors.toList());
            List vanillaTasks = this.baseDAO.getList(VanillaTask.class, (Specification)Specifications.where((Specification & Serializable)(root, cq, cb) -> root.get(VanillaTask_.id).in((Collection)relatedIds)));
            return (MultivalueField)vanillaTasks.stream().collect(MultivalueField.toMultivalueField(vanillaTask -> vanillaTask.getId().toString(), VanillaTask::getName, (Map)ImmutableMap.of((Object)MultivalueOptionType.HINT, vanillaTask -> vanillaTask.getId().toString(), (Object)MultivalueOptionType.DRILL_DOWN_TYPE, vanillaTask -> DrillDownType.INNER.getValue(), (Object)MultivalueOptionType.DRILL_DOWN_LINK, vanillaTask -> "screen/doc/view/docAssocListPopup/bcExample/" + dto.getId() + "/bcExampleRelatedRecords/" + vanillaTask.getId().toString())));
        }
        return new MultivalueField();
    }

    private void setMultivalue(VanillaTask task, MultivalueField multivalue) {
        if (multivalue == null) {
            return;
        }
        List relatedRecords = this.baseDAO.getList(VanillaTaskRelatedRecord.class, (Specification)Specifications.where((Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(VanillaTaskRelatedRecord_.parTaskId), (Object)task.getId())));
        List<Long> multivalueIds = multivalue.getValues().stream().map(MultivalueFieldSingleValue::getId).map(NumberUtils::createLong).collect(Collectors.toList());
        relatedRecords.forEach(relatedRecord -> {
            if (multivalueIds.contains(relatedRecord.getChildId())) {
                multivalueIds.remove(relatedRecord.getChildId());
            } else {
                this.baseDAO.delete((AbstractEntity)relatedRecord);
            }
        });
        multivalueIds.forEach(multivalueId -> {
            VanillaTaskRelatedRecord relRec = new VanillaTaskRelatedRecord();
            relRec.setChildId((Long)multivalueId);
            relRec.setParTaskId(task.getId());
            relRec.setChildType("\u0417\u0430\u0434\u0430\u0447\u0430");
            this.baseDAO.save((Object)relRec);
        });
    }

    protected ActionResultDTO<VanillaDocDTO> doUpdateEntity(VanillaTask task, VanillaDocDTO data, BusinessComponent bc) {
        Object fileEntity;
        Long testFileId;
        if (data.isFieldChanged(VanillaDocDTO_.testFileId)) {
            testFileId = NumberUtils.createLong((String)data.getTestFileId());
            if (testFileId != null) {
                fileEntity = (FileEntity)this.baseDAO.findById(FileEntity.class, testFileId);
                if (fileEntity != null) {
                    task.setFileEntity((FileEntity)fileEntity);
                }
            } else {
                task.setFileEntity(null);
            }
        }
        if (data.isFieldChanged(VanillaDocDTO_.testSourceFileId)) {
            testFileId = NumberUtils.createLong((String)data.getTestSourceFileId());
            if (testFileId != null) {
                fileEntity = (VanillaFileEntity)this.baseDAO.findById(VanillaFileEntity.class, testFileId);
                task.setVanillaFileEntity((VanillaFileEntity)((Object)fileEntity));
            } else {
                task.setVanillaFileEntity(null);
            }
        }
        if (data.isFieldChanged(VanillaDocDTO_.maskedPhone)) {
            task.setPhone(data.getMaskedPhone());
        }
        if (data.isFieldChanged(VanillaDocDTO_.testMultivalue)) {
            this.setMultivalue(task, data.getTestMultivalue());
        }
        if (data.isFieldChanged(VanillaDocDTO_.maskedPostalCode)) {
            task.setPostalCode(data.getMaskedPostalCode());
        }
        VanillaDocDTO updatedDto = this.entityToDto(bc, task);
        if (data.isFieldChanged(VanillaDocDTO_.forceTaskStatus)) {
            updatedDto.setForceTaskStatus(DictionaryType.TASK_STATUS.lookupName(data.getForceTaskStatus()).getKey());
            updatedDto.setForceName(data.getForceTaskStatus());
        }
        if (data.isFieldChanged(VanillaDocDTO_.errorType)) {
            throw new BusinessException().addPopup("\u041f\u0440\u0438\u043c\u0435\u0440 \u0431\u0438\u0437\u043d\u0435\u0441 \u043e\u0448\u0438\u0431\u043a\u0438");
        }
        if (data.isFieldChanged(VanillaDocDTO_.errorCategory)) {
            throw new NullPointerException();
        }
        updatedDto.setEphemeral(data.getEphemeral());
        return new ActionResultDTO((DataResponseDTO)updatedDto);
    }

    public Actions<VanillaDocDTO> getActions() {
        return Actions.builder().create().add().save().withPreAction(bc -> this.isBcPreAction(bc) ? PreAction.confirm((String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?") : null).withPreActionEvents(bc -> this.isBcPreAction(bc) ? Arrays.asList(PreActionEvent.confirm((String)"pre-save-1", (PreActionCondition)this.condition, (String)"\u0412\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438 \u043f\u043e\u043b\u0435 testDate, \u0432\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c?"), PreActionEvent.info((String)"pre-save-2", (PreActionCondition)this.condition, (String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f...")) : null).add().addGroup("messages", "\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", 1, Actions.builder().action("show-error", "Error MSG").available(this::notNullAndPreAction).invoker(this::actionShowError).add().action("show-warning", "Warning MSG").available(this::notNullAndPreAction).invoker(this::actionShowWarning).add().action("show-info", "Info MCG").available(this::notNullAndPreAction).invoker(this::actionShowInfo).add().action("business-exception-with-refresh", "Business Exception with Refresh BC").available(this::notNullAndPreAction).invoker(this::actionThrowBusinessExceptionWithPostActionRefresh).add().action("business-exception-pa", "Business Exception with Post Action").available(this::notNullAndPreAction).invoker(this::actionThrowBusinessExceptionWithPostAction).add().action("business-exception", "Business Exception").available(this::notNullAndPreAction).invoker(this::actionThrowBusinessException).add().build()).addGroup("drillDowns", "\u0434\u0440\u0438\u043b\u043b\u0434\u0430\u0443\u043d\u044b", 1, Actions.builder().action("open-url", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c Yandex").available(this::notNullAndPreAction).invoker(this::actionOpenUrl).withPreAction(PreAction.confirm()).add().action("open-url-new", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c Yandex \u0432 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0435").available(this::notNullAndPreAction).invoker(this::actionOpenUrlNew).withPreAction(PreAction.info()).add().build()).addGroup("updates-bc", "\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0411\u041a", 1, Actions.builder().action("refresh-bc", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0411\u041a").scope(ActionScope.RECORD).available(bc1 -> !this.isBcPreAction(bc1)).invoker(this::actionRefreshBC).add().action("delayed-refresh-bc", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0411\u041a \u0447\u0435\u0440\u0435\u0437 10 \u0441\u0435\u043a.").scope(ActionScope.RECORD).available(bc1 -> !this.isBcPreAction(bc1)).invoker(this::actionDelayedRefreshBC).add().build()).action("bars", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0438\u043a-\u043b\u0438\u0441\u0442").withIcon(ActionIcon.BARS, false).available(this::notNullAndPreAction).invoker(this::openPickList).add().delete().withPreAction(PreAction.error()).add().action("pre-invoke-confirm", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435").available(this::isBcPreAction).withPreAction(PreAction.confirm((String)"\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c?")).invoker(this::actionRefreshBC).add().action("pre-invoke-info", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435").available(this::isBcPreAction).withPreAction(PreAction.info((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435")).invoker(this::actionRefreshBC).add().action("pre-invoke-error", "\u041e\u0448\u0438\u0431\u043a\u0430").available(this::isBcPreAction).withPreAction(PreAction.error((String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c")).add().action("pre-invoke-custom", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044e").available(this::isBcPreAction).withPreActionEvents(new PreActionEvent[]{PreActionEvent.confirm((String)"dataChanged", (PreActionCondition)this.condition, (String)"\u0412\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438 \u043f\u043e\u043b\u0435 \u0414\u0430\u0442\u0430, \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f?"), PreActionEvent.info((String)"save_2", (PreActionCondition)this.condition, (String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f..."), PreActionEvent.info((String)"save_3", (PreActionCondition)this.condition, (String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f 2...")}).invoker(this::actionRefreshBC).add().build();
    }

    private boolean isBcPreAction(BusinessComponent bc) {
        return VanillaServiceAssociation.bcPreAction.isBc((BcIdentifier)bc);
    }

    private boolean notNullAndPreAction(BusinessComponent bc) {
        return bc.getId() != null && !this.isBcPreAction(bc);
    }

    private ActionResultDTO<VanillaDocDTO> actionRefreshBC(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    private ActionResultDTO<VanillaDocDTO> actionDelayedRefreshBC(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.delayedRefreshBC((BcIdentifier)bc, (Number)10));
    }

    private ActionResultDTO<VanillaDocDTO> actionOpenUrl(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.drillDown((DrillDownType)DrillDownType.EXTERNAL, (String)"https://ya.ru/"));
    }

    protected VanillaDocDTO entityToDto(BusinessComponent bc, VanillaTask entity) {
        VanillaDocDTO dto = (VanillaDocDTO)super.entityToDto(bc, (BaseEntity)entity);
        dto.setTestMultivalue(this.getMultivalue(dto));
        int multivalueCount = dto.getTestMultivalue().getValues().size();
        dto.setTestMultivalueCount("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0434\u0430\u0447: " + multivalueCount);
        return dto;
    }

    private ActionResultDTO<VanillaDocDTO> actionOpenUrlNew(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.drillDown((DrillDownType)DrillDownType.EXTERNAL_NEW, (String)"https://ya.ru/"));
    }

    private ActionResultDTO<VanillaDocDTO> actionShowError(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.showMessage((MessageType)MessageType.ERROR, (String)"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"));
    }

    private ActionResultDTO<VanillaDocDTO> actionShowWarning(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.showMessage((MessageType)MessageType.WARNING, (String)"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"));
    }

    private ActionResultDTO<VanillaDocDTO> actionShowInfo(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.showMessage((MessageType)MessageType.INFO, (String)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"));
    }

    private ActionResultDTO<VanillaDocDTO> actionThrowBusinessException(BusinessComponent bc, VanillaDocDTO data) {
        throw new BusinessException().addPopup("\u0411\u0438\u0437\u043d\u0435\u0441 \u043e\u0448\u0438\u0431\u043a\u0430");
    }

    private ActionResultDTO<VanillaDocDTO> actionThrowBusinessExceptionWithPostAction(BusinessComponent bc, VanillaDocDTO data) {
        throw new BusinessException().addPopup("\u0411\u0438\u0437\u043d\u0435\u0441 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u043c").addPostAction(PostAction.showMessage((MessageType)MessageType.INFO, (String)"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435"));
    }

    private ActionResultDTO<VanillaDocDTO> actionThrowBusinessExceptionWithPostActionRefresh(BusinessComponent bc, VanillaDocDTO data) {
        throw new BusinessException().addPopup("\u0411\u0438\u0437\u043d\u0435\u0441 \u043e\u0448\u0438\u0431\u043a\u0430 \u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0411\u041a").addPostAction(PostAction.refreshBc((BcIdentifier)VanillaServiceAssociation.bcExample));
    }

    private ActionResultDTO<VanillaDocDTO> openPickList(BusinessComponent bc, VanillaDocDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.openPickList((String)VanillaServiceAssociation.bcChildExample.name()));
    }

    public ActionResultDTO<VanillaDocDTO> deleteEntity(BusinessComponent businessComponent) {
        throw new UnsupportedOperationException();
    }

    protected CreateResult<VanillaDocDTO> doCreateEntity(VanillaTask entity, BusinessComponent bc) {
        return new CreateResult((DataResponseDTO)this.entityToDto(bc, entity)).setAction(PostAction.drillDown((DrillDownType)DrillDownType.INNER, (String)"screen/doc/view/errors"));
    }

    protected VanillaTask create(BusinessComponent bc) {
        return (VanillaTask)this.baseDAO.findById(VanillaTask.class, Long.valueOf(1L));
    }
}

