/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.service.data.impl;

import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.BusinessError;
import io.tesler.core.dto.DrillDownType;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.action.ActionAvailableChecker;
import io.tesler.core.service.action.Actions;
import io.tesler.core.util.DateTimeUtil;
import io.tesler.core.util.session.SessionService;
import io.tesler.model.core.entity.AbstractEntity;
import io.tesler.model.core.entity.FileEntity;
import io.tesler.model.core.entity.User;
import io.tesler.vanilla.VanillaServiceAssociation;
import io.tesler.vanilla.dto.VanillaTaskDTO;
import io.tesler.vanilla.dto.VanillaTaskDTO_;
import io.tesler.vanilla.entity.VanillaCounterparty;
import io.tesler.vanilla.entity.VanillaTask;
import io.tesler.vanilla.entity.VanillaTask_;
import io.tesler.vanilla.service.action.VanillaTaskActionDownloadFile;
import io.tesler.vanilla.service.action.VanillaTaskActionRandomName;
import io.tesler.vanilla.service.data.VanillaTaskService;
import io.tesler.vanilla.service.meta.VanillaTaskFieldMetaBuilder;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class VanillaTaskServiceImpl
extends VersionAwareResponseService<VanillaTaskDTO, VanillaTask>
implements VanillaTaskService {
    @Autowired
    private VanillaTaskActionDownloadFile actionDownloadFile;
    @Autowired
    private SessionService sessionService;

    public VanillaTaskServiceImpl() {
        super(VanillaTaskDTO.class, VanillaTask.class, VanillaTask_.superVisedOrg, VanillaTaskFieldMetaBuilder.class);
    }

    protected Specification<VanillaTask> getParentSpecification(BusinessComponent bc) {
        if (VanillaServiceAssociation.bcChildExample.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[0]);
        }
        return super.getParentSpecification(bc);
    }

    protected CreateResult<VanillaTaskDTO> doCreateEntity(VanillaTask entity, BusinessComponent bc) {
        entity.setSuperVisedOrg((VanillaCounterparty)this.baseDAO.findById(VanillaCounterparty.class, bc.getParentIdAsLong()));
        entity.setInitiator(this.sessionService.getSessionUser());
        entity.setExecutor(this.sessionService.getSessionUser());
        entity.setCreateDate(DateTimeUtil.now());
        entity.setPlanDate(DateTimeUtil.now().plusDays(1L));
        entity.setDayType(DictionaryType.DAY_TYPE.lookupName("\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0435"));
        entity.setTaskType(DictionaryType.TASK_TYPE.lookupName("\u0417\u0430\u0434\u0430\u0447\u0430"));
        return new CreateResult(this.entityToDto(bc, this.baseDAO.findById(VanillaTask.class, (Long)this.baseDAO.save((Object)entity))));
    }

    protected ActionResultDTO<VanillaTaskDTO> doUpdateEntity(VanillaTask task, VanillaTaskDTO data, BusinessComponent bc) {
        if (data.isFieldChanged(VanillaTaskDTO_.executorId)) {
            task.setExecutor((User)this.baseDAO.findById(User.class, data.getExecutorId()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.name)) {
            task.setName(data.getName());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.job)) {
            task.setJob(data.getJob());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.supervisedMonitor)) {
            task.setSupervisedMonitor(data.getSupervisedMonitor());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.result)) {
            task.setResult(data.getResult());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.reportPeriod)) {
            task.setReportPeriod(DictionaryType.REPORT_PERIOD.lookupName(data.getReportPeriod()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.taskType)) {
            task.setTaskType(DictionaryType.TASK_TYPE.lookupName(data.getTaskType()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.priority)) {
            task.setPriority(DictionaryType.TASK_PRIORITY.lookupName(data.getPriority()));
            if (task.getPriority() != null && task.getPriority().getKey() != null) {
                switch (task.getPriority().getKey()) {
                    case "LOW": {
                        task.setPlanDate(DateTimeUtil.now().plusDays(3L));
                        break;
                    }
                    case "MIDDLE": {
                        task.setPlanDate(DateTimeUtil.now().plusDays(2L));
                        break;
                    }
                    case "HIGH": {
                        task.setPlanDate(DateTimeUtil.now().plusDays(1L));
                        break;
                    }
                }
            }
        }
        if (data.isFieldChanged(VanillaTaskDTO_.activityType)) {
            task.setActivityType(DictionaryType.ACTIVITY_TYPE.lookupName(data.getActivityType()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.taskCategory)) {
            task.setTaskCategory(DictionaryType.TASK_CATEGORY.lookupName(data.getTaskCategory()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.periodicalType)) {
            task.setPeriodicalType(DictionaryType.PERIODICAL_TYPE.lookupName(data.getPeriodicalType()));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.createDate)) {
            Optional.of(data).map(VanillaTaskDTO::getCreateDate).ifPresent(task::setCreateDate);
        }
        if (data.isFieldChanged(VanillaTaskDTO_.reportDate)) {
            Optional.of(data).map(VanillaTaskDTO::getReportDate).ifPresent(task::setReportDate);
        }
        if (data.isFieldChanged(VanillaTaskDTO_.fileId)) {
            task.setFileEntity(data.getFileId() == null ? null : (FileEntity)this.baseDAO.findById(FileEntity.class, NumberUtils.createLong((String)data.getFileId())));
        }
        if (data.isFieldChanged(VanillaTaskDTO_.comboConditionTest)) {
            task.setComboConditionTest(data.getComboConditionTest());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.moneyInputTest)) {
            task.setMoneyInputTest(data.getMoneyInputTest());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.numberInputTest)) {
            task.setNumberInputTest(data.getNumberInputTest());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.decimalInputTest)) {
            task.setDecimalInputTest(data.getDecimalInputTest());
        }
        if (data.isFieldChanged(VanillaTaskDTO_.percentInputTest)) {
            task.setPercentInputTest(data.getPercentInputTest());
        }
        return new ActionResultDTO(this.entityToDto(bc, task)).setAction(PostAction.refreshBc((BcIdentifier)VanillaServiceAssociation.legalResidentVanilla));
    }

    public ActionResultDTO<VanillaTaskDTO> deleteEntity(BusinessComponent bc) {
        VanillaTask task = (VanillaTask)this.baseDAO.findById(VanillaTask.class, bc.getIdAsLong());
        if (task == null) {
            throw new IllegalArgumentException("\u0417\u0430\u0434\u0430\u0447\u0430 \u0441 id = " + bc.getId() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        this.baseDAO.delete((AbstractEntity)task);
        return new ActionResultDTO();
    }

    public Actions<VanillaTaskDTO> getActions() {
        return Actions.builder().create().add().save().add().delete().add().addGroup("vanilla-crud", "vanilla-crud", 2, Actions.builder().action("open-url", "Yandex").available(ActionAvailableChecker.NOT_NULL_ID).invoker(this::actionOpenUrl).add().action("download-file", "\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b").available(this.actionDownloadFile::fileExists).invoker(this.actionDownloadFile::downloadFile).add().action("error", "Test error").invoker(this::actionError).add().action("openPickList", "\u041d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044f").invoker(this::openPickList).add().build()).addGroup("vanilla-custom", "vanilla-custom", 2, Actions.builder().action("custom-action-1", "\u0412\u0437\u044f\u0442\u044c \u0432 \u0440\u0430\u0431\u043e\u0442\u0443").available(VanillaTaskActionRandomName::isAvailable1).invoker(this::actionRandomName).add().action("custom-action-2", "\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u0442\u044c").available(VanillaTaskActionRandomName::isAvailable2).invoker(this::actionRandomName).add().action("custom-action-3", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c").available(VanillaTaskActionRandomName::isAvailable3).invoker(this::actionRandomName).add().action("custom-action-4", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u044e\u044e \u0437\u0430\u0434\u0430\u0447\u0443").available(VanillaTaskActionRandomName::isAvailable4).invoker(this::actionRandomName).add().action("custom-action-5", "\u0421\u0432\u044f\u0437\u0430\u0442\u044c").available(VanillaTaskActionRandomName::isAvailable5).invoker(this::actionRandomName).add().action("custom-action-6", "\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u0442\u044c").invoker(this::calculate).add().build()).build();
    }

    private ActionResultDTO<VanillaTaskDTO> actionOpenUrl(BusinessComponent bc, VanillaTaskDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.drillDown((DrillDownType)DrillDownType.EXTERNAL, (String)"https://ya.ru/"));
    }

    private ActionResultDTO<VanillaTaskDTO> openPickList(BusinessComponent bc, VanillaTaskDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.openPickList((String)VanillaServiceAssociation.taskExecutorVanilla.name()));
    }

    private ActionResultDTO<VanillaTaskDTO> actionError(BusinessComponent bc, VanillaTaskDTO data) {
        throw new BusinessException().addPopup("\u0422\u0435\u0441\u0442 popup-error 1").addPopup("\u0422\u0435\u0441\u0442 popup-error 2").setEntity(new BusinessError.Entity(bc).addField("name", "\u0422\u0430\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442").addField("reportDate", "\u041f\u043e\u043b\u0435 %field% \u0437\u0430\u0434\u0430\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e"));
    }

    private ActionResultDTO<VanillaTaskDTO> actionRandomName(BusinessComponent bc, VanillaTaskDTO data) {
        data.setName(UUID.randomUUID().toString());
        data.addChangedField(VanillaTaskDTO_.name);
        return new ActionResultDTO(this.updateEntity(bc, data).getRecord()).setAction(PostAction.refreshBc((BcIdentifier)VanillaServiceAssociation.legalResidentVanilla));
    }

    private ActionResultDTO<VanillaTaskDTO> calculate(BusinessComponent bc, VanillaTaskDTO data) {
        return new ActionResultDTO((DataResponseDTO)data).setAction(PostAction.delayedRefreshBC((BcIdentifier)VanillaServiceAssociation.legalResidentVanilla, (Number)5));
    }
}

