/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.vanilla.service.meta;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dictionary.IDictionaryType;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.data.dto.rowmeta.IconCode;
import io.tesler.constgen.DtoField;
import io.tesler.core.crudma.bc.impl.InnerBcDescription;
import io.tesler.core.dto.DrillDownType;
import io.tesler.core.dto.rowmeta.FieldsMeta;
import io.tesler.core.dto.rowmeta.RowDependentFieldsMeta;
import io.tesler.core.service.rowmeta.FieldMetaBuilder;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.vanilla.dto.VanillaTaskDTO;
import io.tesler.vanilla.dto.VanillaTaskDTO_;
import io.tesler.vanilla.entity.VanillaTask;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class VanillaTaskFieldMetaBuilder
extends FieldMetaBuilder<VanillaTaskDTO> {
    private final JpaDao jpaDao;

    public void buildRowDependentMeta(RowDependentFieldsMeta<VanillaTaskDTO> fields, InnerBcDescription bcDescription, Long rowId, Long parRowId) {
        VanillaTask task = (VanillaTask)this.jpaDao.findById(VanillaTask.class, rowId);
        if (task.getPriority() != null && task.getPriority().getKey() != null) {
            switch (task.getPriority().getKey()) {
                case "LOW": {
                    fields.setDictionaryTypeWithConcreteValues(VanillaTaskDTO_.periodicalType, (IDictionaryType)DictionaryType.PERIODICAL_TYPE, new String[]{"NOT_PERIODICAL", "ONE_TIME_PER_YEAR"});
                    break;
                }
                case "MIDDLE": {
                    fields.setDictionaryTypeWithConcreteValues(VanillaTaskDTO_.periodicalType, (IDictionaryType)DictionaryType.PERIODICAL_TYPE, new String[]{"ONE_TIME_PER_HALF_YEAR", "ONE_TIME_PER_QUARTER"});
                    break;
                }
                case "HIGH": {
                    fields.setDictionaryTypeWithConcreteValues(VanillaTaskDTO_.periodicalType, (IDictionaryType)DictionaryType.PERIODICAL_TYPE, new String[]{"ONE_TIME_PER_MONTH", "DAILY"});
                    break;
                }
            }
        }
        fields.setRequired(new DtoField[]{VanillaTaskDTO_.taskCategory, VanillaTaskDTO_.taskType});
        fields.setDictionaryTypeWithAllValues(VanillaTaskDTO_.activityType, (IDictionaryType)DictionaryType.ACTIVITY_TYPE);
        fields.setDictionaryTypeWithAllValues(VanillaTaskDTO_.taskCategory, (IDictionaryType)DictionaryType.TASK_CATEGORY);
        fields.setDictionaryTypeWithAllValues(VanillaTaskDTO_.taskType, (IDictionaryType)DictionaryType.TASK_TYPE);
        fields.setDictionaryValuesWithIcons(VanillaTaskDTO_.priority, (IDictionaryType)DictionaryType.TASK_PRIORITY, (Map)ImmutableMap.of((Object)new LOV("LOW"), (Object)IconCode.ARROW_DOWN_GREEN, (Object)new LOV("MIDDLE"), (Object)IconCode.ARROW_UP_ORANGE, (Object)new LOV("HIGH"), (Object)IconCode.ARROW_UP_RED));
        fields.setDictionaryTypeWithAllValues(VanillaTaskDTO_.reportPeriod, (IDictionaryType)DictionaryType.REPORT_PERIOD);
        fields.setDrilldown(VanillaTaskDTO_.name, DrillDownType.INNER, "screen/vanilla/view/vanilla3/legalResidentVanilla/" + parRowId + "/taskVanilla/" + rowId);
        fields.setDrilldown(VanillaTaskDTO_.legalPersonName, DrillDownType.INNER, "screen/counterparty/view/counterparty/counterparty/" + parRowId);
    }

    public void buildIndependentMeta(FieldsMeta<VanillaTaskDTO> fields, InnerBcDescription bcDescription, Long parRowId) {
        fields.setEnabled(new DtoField[]{VanillaTaskDTO_.activityType, VanillaTaskDTO_.taskCategory, VanillaTaskDTO_.taskType, VanillaTaskDTO_.createDate, VanillaTaskDTO_.name, VanillaTaskDTO_.priority, VanillaTaskDTO_.job, VanillaTaskDTO_.reportPeriod, VanillaTaskDTO_.reportDate, VanillaTaskDTO_.supervisedMonitor, VanillaTaskDTO_.result, VanillaTaskDTO_.periodicalType, VanillaTaskDTO_.executor, VanillaTaskDTO_.executorId, VanillaTaskDTO_.executorName, VanillaTaskDTO_.fileId, VanillaTaskDTO_.fileName, VanillaTaskDTO_.taskStatus, VanillaTaskDTO_.comboConditionTest, VanillaTaskDTO_.moneyInputTest, VanillaTaskDTO_.numberInputTest, VanillaTaskDTO_.decimalInputTest, VanillaTaskDTO_.percentInputTest, VanillaTaskDTO_.editor});
        fields.enableFilter(new DtoField[]{VanillaTaskDTO_.name, VanillaTaskDTO_.legalPersonName, VanillaTaskDTO_.taskType, VanillaTaskDTO_.planDate, VanillaTaskDTO_.createDate});
        fields.setAllFilterValuesByLovType(VanillaTaskDTO_.taskType, (IDictionaryType)DictionaryType.TASK_TYPE);
        fields.setForceActive(new DtoField[]{VanillaTaskDTO_.priority});
    }

    public VanillaTaskFieldMetaBuilder(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

