/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.listeners;

import com.google.common.eventbus.Subscribe;
import eu.tsystems.mms.tic.testframework.annotations.Fails;
import eu.tsystems.mms.tic.testframework.annotations.TestClassContext;
import eu.tsystems.mms.tic.testframework.events.FinalizeExecutionEvent;
import eu.tsystems.mms.tic.testframework.events.MethodEndEvent;
import eu.tsystems.mms.tic.testframework.exceptions.TestFailureException;
import eu.tsystems.mms.tic.testframework.info.ReportInfo;
import eu.tsystems.mms.tic.testframework.internal.Flags;
import eu.tsystems.mms.tic.testframework.logging.Loggable;
import eu.tsystems.mms.tic.testframework.monitor.JVMMonitor;
import eu.tsystems.mms.tic.testframework.report.FailureCorridor;
import eu.tsystems.mms.tic.testframework.report.ReportingData;
import eu.tsystems.mms.tic.testframework.report.TestStatusController;
import eu.tsystems.mms.tic.testframework.report.model.context.ClassContext;
import eu.tsystems.mms.tic.testframework.report.model.context.MethodContext;
import eu.tsystems.mms.tic.testframework.report.perf.PerfTestReportUtils;
import eu.tsystems.mms.tic.testframework.report.threadvisualizer.DataSet;
import eu.tsystems.mms.tic.testframework.report.threadvisualizer.DataStorage;
import eu.tsystems.mms.tic.testframework.report.utils.ExecutionContextController;
import eu.tsystems.mms.tic.testframework.report.utils.FailsAnnotationFilter;
import eu.tsystems.mms.tic.testframework.utils.DateUtils;
import eu.tsystems.mms.tic.testframework.utils.ReportUtils;
import eu.tsystems.mms.tic.testframework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class GenerateHtmlReportListener
implements Loggable,
MethodEndEvent.Listener,
FinalizeExecutionEvent.Listener {
    @Subscribe
    public void onMethodEnd(MethodEndEvent event) {
        try {
            ReportUtils.createMethodDetailsStepsView(event.getMethodContext());
            this.addThreadVisualizerDataSet(event.getMethodContext());
        }
        catch (Throwable e) {
            this.log().error("FATAL: Could not create html", e);
        }
    }

    private void addThreadVisualizerDataSet(MethodContext methodContext) {
        long startTimeTime = methodContext.getStartTime().getTime();
        long endTimeTime = methodContext.getEndTime().getTime();
        if (endTimeTime - startTimeTime <= 10L) {
            endTimeTime = startTimeTime + 10L;
        }
        DataSet dataSet = new DataSet(methodContext, startTimeTime, endTimeTime);
        DataStorage.addDataSet(dataSet);
    }

    private static void printTestsList() {
        System.out.println("");
        System.out.println(" ## List of all test methods in this steps ##");
        System.out.println("");
        AtomicReference<Integer> testMethodsCount = new AtomicReference<Integer>();
        testMethodsCount.set(0);
        ExecutionContextController.getCurrentExecutionContext().readSuiteContexts().forEach(suiteContext -> {
            System.out.println("Suite: " + suiteContext.getName());
            suiteContext.readTestContexts().forEach(testContext -> {
                System.out.println("Test: " + testContext.getName());
                testContext.readClassContexts().forEach(classContext -> {
                    System.out.println("Class: " + classContext.getName());
                    classContext.readMethodContexts().filter(methodContext -> methodContext.getStatus() == TestStatusController.Status.PASSED).forEach(methodContext -> {
                        System.out.println("Method: " + methodContext.getName());
                        testMethodsCount.set((Integer)testMethodsCount.get() + 1);
                    });
                });
            });
        });
        System.out.println("");
        System.out.println("Number of tests: " + testMethodsCount.get());
        System.out.println("");
    }

    private static Map<String, List<MethodContext>> sortTestMethodContainerMap(Map<String, List<MethodContext>> inputMap) {
        HashMap<List, String> reverseOrigMap = new HashMap<List, String>();
        LinkedList<List> listOfLists = new LinkedList<List>();
        for (String key : inputMap.keySet()) {
            List list = inputMap.get(key);
            listOfLists.add(list);
            reverseOrigMap.put(list, key);
        }
        listOfLists.sort((o1, o2) -> o2.size() - o1.size());
        LinkedHashMap<String, List<MethodContext>> newMap = new LinkedHashMap<String, List<MethodContext>>();
        for (List list : listOfLists) {
            newMap.put((String)reverseOrigMap.get(list), list);
        }
        return newMap;
    }

    private static void addMatchingExpectedFailedMessage(Map<String, List<MethodContext>> failureAspects) {
        failureAspects.values().stream().flatMap(Collection::stream).filter(methodContext -> !methodContext.isExpectedFailed()).forEach(methodContext -> {
            Stream<MethodContext> expectedFailedMethodContexts = failureAspects.values().stream().map(e -> (MethodContext)e.get(0)).filter(MethodContext::isExpectedFailed);
            Optional<MethodContext> optionalMethodContext = GenerateHtmlReportListener.findMethodContextMatchingThrowableOfMethodContexts(methodContext, expectedFailedMethodContexts);
            optionalMethodContext.flatMap(MethodContext::getTestNgResult).ifPresent(testResult -> {
                Fails failsAnnotation = testResult.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Fails.class);
                String additionalErrorMessage = "Failure aspect matches known issue:";
                if (StringUtils.isNotBlank((CharSequence)failsAnnotation.description())) {
                    additionalErrorMessage = additionalErrorMessage + " Description: " + failsAnnotation.description();
                    methodContext.getErrorContext().setDescription(failsAnnotation.description());
                }
                if (failsAnnotation.ticketId() > 0) {
                    additionalErrorMessage = additionalErrorMessage + " Ticket: " + failsAnnotation.ticketId();
                    methodContext.getErrorContext().setTicketId((Object)failsAnnotation.ticketId());
                }
                if (!failsAnnotation.ticketString().isEmpty()) {
                    methodContext.getErrorContext().setTicketId((Object)failsAnnotation.ticketString());
                }
                methodContext.getErrorContext().additionalErrorMessage = additionalErrorMessage;
            });
        });
    }

    private static Optional<MethodContext> findMethodContextMatchingThrowableOfMethodContexts(MethodContext needle, Stream<MethodContext> haystack) {
        return haystack.filter(haystackMethodContext -> {
            Throwable needleThrowable = needle.getErrorContext().getThrowable();
            String needleMessage = needleThrowable.getMessage();
            if (needleMessage == null) {
                return false;
            }
            for (Throwable haystackThrowable = haystackMethodContext.getErrorContext().getThrowable(); haystackThrowable != null; haystackThrowable = haystackThrowable.getCause()) {
                String hayStackMessage = haystackThrowable.getMessage();
                if (hayStackMessage == null) {
                    return false;
                }
                if (!hayStackMessage.equals(needleMessage)) continue;
                return true;
            }
            return false;
        }).findFirst();
    }

    public void addMethodStats(ReportingData reportingData, ClassContext classContext) {
        Map methodStats = classContext.createStats();
        Map configMethodStats = classContext.createStats();
        classContext.readMethodContexts().forEach(methodContext -> {
            this.handleAnnotations((MethodContext)methodContext);
            if (methodContext.isTestMethod()) {
                classContext.addToStats(methodStats, methodContext);
            } else if (methodContext.isConfigMethod()) {
                classContext.addToStats(configMethodStats, methodContext);
            }
        });
        reportingData.methodStatsPerClass.put(classContext, methodStats);
        reportingData.configMethodStatsPerClass.put(classContext, configMethodStats);
    }

    public void createMethodStatsPerClass(ReportingData reportingData) {
        HashMap mergedClassContexts = new HashMap();
        HashMap multiContextualClassContexts = new HashMap();
        reportingData.executionContext.readSuiteContexts().forEach(suiteContext -> suiteContext.readTestContexts().forEach(testContext -> testContext.readClassContexts().forEach(classContext -> {
            Optional optionalTestClassContext = classContext.getTestClassContext();
            if (optionalTestClassContext.isPresent()) {
                ClassContext mergedClassContext;
                TestClassContext testClassContext = (TestClassContext)optionalTestClassContext.get();
                if (!mergedClassContexts.containsKey(testClassContext.name())) {
                    mergedClassContext = new ClassContext(classContext.getTestClass(), testContext);
                    mergedClassContext.setTestClassContext(testClassContext);
                    mergedClassContexts.put(testClassContext.name(), mergedClassContext);
                } else {
                    mergedClassContext = (ClassContext)mergedClassContexts.get(testClassContext.name());
                }
                mergedClassContext.methodContexts.addAll(classContext.readMethodContexts().collect(Collectors.toList()));
            } else {
                String classContextName = classContext.getName();
                if (multiContextualClassContexts.containsKey(classContextName)) {
                    ((ClassContext)multiContextualClassContexts.get(classContextName)).updateMultiContextualName();
                    classContext.updateMultiContextualName();
                }
                multiContextualClassContexts.put(classContextName, classContext);
                this.addMethodStats(reportingData, (ClassContext)classContext);
            }
        })));
        mergedClassContexts.values().forEach(classContext -> this.addMethodStats(reportingData, (ClassContext)classContext));
        AtomicReference i1 = new AtomicReference();
        AtomicReference i2 = new AtomicReference();
        Comparator comp = (m1, m2) -> {
            i1.set(0);
            m1.keySet().forEach(status -> i1.set((Integer)i1.get() + (Integer)m1.get(status)));
            i2.set(0);
            m2.keySet().forEach(status -> i2.set((Integer)i2.get() + (Integer)m2.get(status)));
            return (Integer)i2.get() - (Integer)i1.get();
        };
        reportingData.methodStatsPerClass = reportingData.methodStatsPerClass.entrySet().stream().sorted(Map.Entry.comparingByValue(comp)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private void handleAnnotations(MethodContext methodContext) {
        methodContext.readAnnotations().forEach(annotation -> {
            if (annotation instanceof Test) {
                if (!((Test)annotation).dataProvider().isEmpty()) {
                    methodContext.addPriorityMessage("@Fails and @DataProvider should not be used together. Please remove @Fails from this test method.");
                }
            } else if (annotation instanceof Fails) {
                methodContext.getTestNgResult().ifPresent(testResult -> {
                    if (testResult.isSuccess()) {
                        ReportInfo.getDashboardInfo().addInfo(Integer.valueOf(0), "Repaired >" + methodContext.getName() + "< marked @Fails", "methods/" + methodContext.methodRunIndex + ".html");
                        methodContext.addPriorityMessage("@Fails annotation can be removed: " + annotation);
                    } else if (testResult.getStatus() != 3 && testResult.getThrowable() != null) {
                        Fails fails = (Fails)annotation;
                        Throwable throwable = testResult.getThrowable();
                        if (FailsAnnotationFilter.isFailsAnnotationValid((Fails)fails)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Failing of test expected.");
                            if (fails.ticketId() != 0) {
                                stringBuilder.append(" TicketID: ").append(fails.ticketId()).append(".");
                            }
                            if (!"".equals(fails.ticketString())) {
                                stringBuilder.append(" Ticket: ").append(fails.ticketString()).append(".");
                            }
                            if (!"".equals(fails.description())) {
                                stringBuilder.append(" Description: ").append(fails.description()).append(".");
                            }
                            String message = stringBuilder.toString();
                            TestFailureException testFailureException = new TestFailureException(message, throwable);
                            testResult.setThrowable((Throwable)testFailureException);
                            methodContext.getErrorContext().setThrowable(null, throwable, true);
                            String formerReadableMessage = methodContext.getErrorContext().getReadableErrorMessage();
                            methodContext.addPriorityMessage(formerReadableMessage);
                            methodContext.getErrorContext().setThrowable(message, throwable, true);
                        }
                    }
                });
            }
        });
    }

    @Subscribe
    public void onFinalizeExecution(FinalizeExecutionEvent event) {
        long start = System.currentTimeMillis();
        ReportingData reportingData = new ReportingData();
        reportingData.executionContext = event.getExecutionContext();
        this.createMethodStatsPerClass(reportingData);
        ArrayList<ClassContext> allClassContexts = new ArrayList<ClassContext>(reportingData.methodStatsPerClass.keySet());
        this.log().trace("Build maps for exit points and failure aspects...");
        Map<String, List<MethodContext>> exitPoints = new TreeMap<String, List<MethodContext>>();
        Map<String, List<MethodContext>> failureAspects = new TreeMap<String, List<MethodContext>>();
        int unknownCounter = 0;
        for (ClassContext classContext : allClassContexts) {
            for (MethodContext methodContext : classContext.methodContexts) {
                if (!methodContext.isFailed() || methodContext.isConfigMethod() || methodContext.isRetry()) continue;
                String fingerprint = methodContext.getErrorContext().getExitFingerprint();
                String failuresMapKey = StringUtils.isStringEmpty((String)fingerprint) ? "unknown exit #" + ++unknownCounter : fingerprint;
                if (!exitPoints.containsKey(failuresMapKey)) {
                    exitPoints.put(failuresMapKey, new LinkedList());
                }
                exitPoints.get(failuresMapKey).add(methodContext);
                String readableMessage = methodContext.getErrorContext().getReadableErrorMessage();
                if (!failureAspects.containsKey(readableMessage)) {
                    failureAspects.put(readableMessage, new LinkedList());
                }
                failureAspects.get(readableMessage).add(methodContext);
            }
        }
        exitPoints = GenerateHtmlReportListener.sortTestMethodContainerMap(exitPoints);
        failureAspects = GenerateHtmlReportListener.sortTestMethodContainerMap(failureAspects);
        GenerateHtmlReportListener.addMatchingExpectedFailedMessage(failureAspects);
        reportingData.exitPoints = exitPoints;
        reportingData.failureAspects = failureAspects;
        PerfTestReportUtils.prepareMeasurementsForReport();
        JVMMonitor.label((String)"Report");
        reportingData.failureCorridorMatched = FailureCorridor.isCorridorMatched();
        reportingData.classContexts = allClassContexts;
        if (Flags.LIST_TESTS) {
            GenerateHtmlReportListener.printTestsList();
            System.exit(0);
        }
        ReportUtils.createReport(reportingData);
        long stop = System.currentTimeMillis();
        String formattedDuration = DateUtils.getFormattedDuration((long)(stop - start), (boolean)false);
        this.log().debug("Took " + formattedDuration + " to create the report.");
    }
}

