/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report;

import eu.tsystems.mms.tic.testframework.report.TesterraListener;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public final class GraphGenerator {
    private GraphGenerator() {
    }

    public static JFreeChart createLineChart(XYDataset xyDataset, String title, String xLabel, String yLabel, DataType dataTypeXAxis) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)xyDataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setBaseShapesFilled(true);
        renderer.setDrawSeriesLineAsPath(true);
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis yAxis = new NumberAxis(yLabel);
        yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis((ValueAxis)yAxis);
        switch (dataTypeXAxis) {
            case DATE: {
                DateAxis xAxis = new DateAxis(xLabel);
                xAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm:ss"));
                plot.setDomainAxis((ValueAxis)xAxis);
                break;
            }
            case NUMBER: {
                NumberAxis xAxis = new NumberAxis(xLabel);
                xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                xAxis.setAutoRangeIncludesZero(false);
                xAxis.setAutoRange(true);
                plot.setDomainAxis((ValueAxis)xAxis);
            }
        }
        return chart;
    }

    public static File saveGraphAsJPEG(JFreeChart chart, String relativeFileName, int width, int height) throws IOException {
        File graphFile = TesterraListener.getReport().getReportDirectory(relativeFileName);
        File dir = graphFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ChartUtilities.saveChartAsJPEG((File)graphFile, (JFreeChart)chart, (int)width, (int)height);
        return graphFile;
    }

    public static enum DataType {
        DATE,
        NUMBER;

    }
}

