/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report.perf;

import eu.tsystems.mms.tic.testframework.exceptions.SystemException;
import eu.tsystems.mms.tic.testframework.internal.TimingInfo;
import eu.tsystems.mms.tic.testframework.report.GraphGenerator;
import eu.tsystems.mms.tic.testframework.report.perf.CustomRenderer;
import eu.tsystems.mms.tic.testframework.report.perf.LayeredBarChartRenderer;
import eu.tsystems.mms.tic.testframework.report.perf.MetricType;
import eu.tsystems.mms.tic.testframework.report.perf.PerfTestReportUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestGraphGenerator {
    private final int widthOfImage = 800;
    private int widthOfRepetitionCharts = 800;
    private int numberOfTestExecutions = 1;
    private final int heightOfImage = 600;
    private final String subFolderForGraphs = "Graphs_Of_PerfTest";
    private final Logger logger = LoggerFactory.getLogger(PerfTestGraphGenerator.class);
    private long tickRateForStackedBarChart = 200L;
    private long tickRateForMaxBarChart = 200L;
    private long tickRateForMinBarChart = 200L;
    private long tickRateForAvgBarChart = 200L;
    private long tickRateForAvgRepetitionBarChart = 200L;
    private long tickRateForMaxRepetitionBarChart = 200L;
    private long tickRateForMinRepetitionBarChart = 200L;
    private long tickRateForLayeredBarChart = 200L;
    private int fontSizeForStackeResponseTimeBarChart = 18;
    private int fontSizeForMinResponseTimeBarChart = 18;
    private int fontSizeForMaxResponseTimeBarChart = 18;
    private int fontSizeForAvgResponseTimeBarChart = 18;
    private int fontSizeForLayeredRepetitionBarChart = 12;
    private int fontSizeForAvgRepetitionBarCharts = 12;
    private int fontSizeForMinRepetitionBarCharts = 12;
    private int fontSizeForMaxRepetitionBarCharts = 12;

    private void createGraphsForLoadTestReport(String methodName) throws IOException {
        DefaultCategoryDataset defaultCategoryDataset = this.createDataSetForBarCharts("Responsetimes", MetricType.STACKED_RESPONSETIMES_PER_TESTSTEP);
        DefaultCategoryDataset layeredDataSet = this.createDataSetForBarCharts("LayeredChart", MetricType.LAYERED_RESPONSETIMES_PER_REPETITION);
        DefaultCategoryDataset avgPerRepetitionDataSet = this.createDataSetForBarCharts("Responsetimes_avg", MetricType.AVERAGE_RESPONSETIMES_PER_REPETITION);
        DefaultCategoryDataset minPerRepetitionDataSet = this.createDataSetForBarCharts("Responsetimes_min", MetricType.MIN_RESPONSETIME_PER_REPETITION);
        DefaultCategoryDataset maxPerRepetitionDataSet = this.createDataSetForBarCharts("Responsetimes_max", MetricType.MAX_RESPONSETIME_PER_REPETITION);
        DefaultCategoryDataset dataSet1 = this.createDataSetForBarCharts("Responsetimes", MetricType.AVERAGE_RESPONSETIMES_PER_TESTSTEP);
        DefaultCategoryDataset dataSet2 = this.createDataSetForBarCharts("Responsetimes", MetricType.MAX_RESPONSETIME_PER_TESTSTEP);
        DefaultCategoryDataset dataSetMinTimes = this.createDataSetForBarCharts("Responsetimes_min", MetricType.MIN_RESPONSETIME_PER_TESTSTEP);
        DefaultCategoryDataset dataSet4 = this.createDataSetForBarCharts("Transactionstatus", MetricType.TRANSACTION_STATUS);
        XYDataset dataSet5 = this.createDataSetForLineChart("Responsetimehistory", MetricType.RESPONSETIMES_PER_TEST);
        XYDataset dataSetTransActionsPerSecond = this.createDataSetForLineChart(methodName, MetricType.TRANSACTIONS_PER_SECOND);
        XYDataset dataSetTransActionsPerMinute = this.createDataSetForLineChart(methodName, MetricType.TRANSACTIONS_PER_MINUTE);
        XYDataset dataSetTransActionsPerHour = this.createDataSetForLineChart(methodName, MetricType.TRANSACTIONS_PER_HOUR);
        XYDataset dataSetRequestsPerSecond = this.createDataSetForLineChart(methodName, MetricType.REQUESTS_PER_SECOND);
        XYDataset dataSetRequestsPerMinute = this.createDataSetForLineChart(methodName, MetricType.REQUESTS_PER_MINUTE);
        XYDataset dataSetRequestsPerHour = this.createDataSetForLineChart(methodName, MetricType.REQUESTS_PER_HOUR);
        XYDataset dataSetRequestsPerTransaction = this.createDataSetForLineChart(methodName, MetricType.RESPONSETIMES_PER_TESTSTEP);
        JFreeChart barChart1 = this.createBarChart(dataSet1, "Average ResponseTimes per Teststep", "Teststep", "Response Time [ms]", methodName, "Responsetimes_Per_Teststep_Avg", MetricType.AVERAGE_RESPONSETIMES_PER_TESTSTEP);
        JFreeChart barChart2 = this.createBarChart(dataSet2, "Max ResponseTimes per Teststep", "Teststep", "Response Time [ms]", methodName, "Responsetimes_Per_Teststep_Max", MetricType.MAX_RESPONSETIME_PER_TESTSTEP);
        JFreeChart barChart3 = this.createBarChart(dataSet4, "Status of Transactions", "Transactionstatus", "Amount", methodName, "Number_Of_Transactionstatus_Bar", MetricType.TRANSACTION_STATUS);
        JFreeChart barChart4 = this.createBarChart(dataSetMinTimes, "Min ResponseTimes per Teststep", "Teststep", "Response Time [ms]", methodName, "Responsetimes_Per_Teststep_Min", MetricType.MIN_RESPONSETIME_PER_TESTSTEP);
        JFreeChart stackBarChart = this.createStackedBarChart((CategoryDataset)defaultCategoryDataset, "Responsetime_Overview", "Teststeps", "Response Time [ms]", methodName, "Responsetimes_Per_Teststep_All", MetricType.STACKED_RESPONSETIMES_PER_TESTSTEP);
        JFreeChart layeredBarChart = this.createLayeredBarChart((CategoryDataset)layeredDataSet, "All Responsetimes per Repetition", "Repetition", "Response Time [ms]", methodName, "Responsetimes_Per_Repetition_All", MetricType.LAYERED_RESPONSETIMES_PER_REPETITION);
        JFreeChart avgPerRepetitionBarChart = this.createBarChart(avgPerRepetitionDataSet, " Average Responsetimes Per Repetition", "Repetition", "Response Time [ms]", methodName, "Responsetimes_Per_Repetition_Avg", MetricType.AVERAGE_RESPONSETIMES_PER_REPETITION);
        JFreeChart maxPerRepetitionBarChart = this.createBarChart(maxPerRepetitionDataSet, "Max Responsetimes Per Repetition", "Repetition", "Response Time [ms]", methodName, "Responsetimes_Per_Repetition_Max", MetricType.MAX_RESPONSETIME_PER_REPETITION);
        JFreeChart minPerRepetitionBarChart = this.createBarChart(minPerRepetitionDataSet, " Min Responsetimes Per Repetition", "Repetition", "Response Time [ms]", methodName, "Responsetimes_Per_Repetition_Min", MetricType.MIN_RESPONSETIME_PER_REPETITION);
        JFreeChart lineChart = this.createLineChart(dataSet5, "Responsetime History", "Time", "Responsetime", methodName, "ResponseTime_History", MetricType.RESPONSETIMES_PER_TEST);
        JFreeChart lineChartTransactionsPerSecond = this.createLineChart(dataSetTransActionsPerSecond, "Transaction Throughput Per Second", "Date", "Transactions/s", methodName, "Transaction_Throughput_Per_Second", MetricType.TRANSACTIONS_PER_SECOND);
        JFreeChart lineChartTransactionsPerMinute = this.createLineChart(dataSetTransActionsPerMinute, "Transaction Throughput Per Minute", "Date", "Transactions/min", methodName, "Transaction_Throughput_Per_Minute", MetricType.TRANSACTIONS_PER_MINUTE);
        JFreeChart lineChartTransactionsPerHour = this.createLineChart(dataSetTransActionsPerHour, "Transaction Throughput Per Hour", "Date", "Transactions/h", methodName, "Transaction_Throughput_Per_Hour", MetricType.TRANSACTIONS_PER_HOUR);
        JFreeChart lineChartRequestPerSecond = this.createLineChart(dataSetRequestsPerSecond, "Request Throughput Per Second", "Date", "Requests/s", methodName, "Request_Throughput_Per_Second", MetricType.REQUESTS_PER_SECOND);
        JFreeChart lineChartRequestPerMinute = this.createLineChart(dataSetRequestsPerMinute, "Request Throughput Per Minute", "Date", "Requests/min", methodName, "Request_Throughput_Per_Minute", MetricType.REQUESTS_PER_MINUTE);
        JFreeChart lineChartRequestPerHour = this.createLineChart(dataSetRequestsPerHour, "Request Throughput Per Hour", "Date", "Requests/h", methodName, "Request_Throughput_Per_Hour", MetricType.REQUESTS_PER_HOUR);
        JFreeChart lineChartResponseTimePerTeststep = this.createLineChart(dataSetRequestsPerTransaction, "Response Time Per Step", "Date", "Response Time [ms]", methodName, "Responsetime_History_Per_Teststep", MetricType.RESPONSETIMES_PER_TESTSTEP);
    }

    private JFreeChart createBarChart(DefaultCategoryDataset dataSet, String title, String xLabel, String yLabel, String methodName, String saveName, MetricType metricType) throws IOException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart barChart = ChartFactory.createBarChart3D((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        barChart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = barChart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.blue);
        plot.setRangeGridlinePaint((Paint)Color.blue);
        CustomRenderer renderer = new CustomRenderer();
        renderer.setShadowVisible(false);
        DecimalFormat format = new DecimalFormat("#####.#####");
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)format));
        renderer.setDrawBarOutline(false);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setBaseItemLabelPaint(Color.black);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        CategoryAxis xAxis = plot.getDomainAxis();
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        if (dataSet.getColumnCount() > 0) {
            Comparable comp = dataSet.getColumnKey(0);
            Class<?> classOfComparable = comp.getClass();
            if (classOfComparable == String.class) {
                String columnKey = (String)((Object)dataSet.getColumnKey(0));
                LegendItemCollection legendItemCollection = renderer.getLegendItems();
                if (columnKey.equals("Success") || columnKey.equals("Fail") || columnKey.equals("Skip")) {
                    legendItemCollection.add(new LegendItem(new AttributedString("Success"), "description 0", "tooltip 0", "url 0", (Shape)new Rectangle(10, 10), (Paint)Color.green));
                    legendItemCollection.add(new LegendItem(new AttributedString("Fail"), "description 1", "tooltip 1", "url 1", (Shape)new Rectangle(10, 10), (Paint)Color.red));
                    legendItemCollection.add(new LegendItem(new AttributedString("Skip"), "description 2", "tooltip 2", "url 2", (Shape)new Rectangle(10, 10), (Paint)Color.yellow));
                    plot.setFixedLegendItems(legendItemCollection);
                } else {
                    renderer.setSeriesPaint(0, Color.cyan);
                }
            } else {
                renderer.setSeriesPaint(0, Color.cyan);
            }
        }
        this.setFontSizeAndTickRateOfBarCharts(metricType, (BarRenderer)renderer, yAxis);
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.saveGraphAsJPEG(barChart, saveName, methodName, metricType);
        return barChart;
    }

    private JFreeChart createStackedBarChart(CategoryDataset categoryDataset, String title, String xLabel, String yLabel, String methodName, String saveName, MetricType metricType) throws IOException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.blue);
        plot.setRangeGridlinePaint((Paint)Color.blue);
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setDrawBarOutline(false);
        renderer.setShadowVisible(false);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setBaseItemLabelPaint((Paint)Color.black);
        Paint[] array = ChartColor.createDefaultPaintArray();
        renderer.setSeriesPaint(0, array[17]);
        renderer.setSeriesPaint(1, array[20]);
        renderer.setSeriesPaint(2, array[15]);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        CategoryAxis xAxis = plot.getDomainAxis();
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        this.setFontSizeAndTickRateOfBarCharts(metricType, (BarRenderer)renderer, yAxis);
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.saveGraphAsJPEG(chart, saveName, methodName, metricType);
        return chart;
    }

    private JFreeChart createLayeredBarChart(CategoryDataset categoryDataset, String title, String xLabel, String yLabel, String methodName, String saveName, MetricType metricType) throws IOException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart chart = ChartFactory.createBarChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.blue);
        plot.setRangeGridlinePaint((Paint)Color.blue);
        LayeredBarChartRenderer renderer = new LayeredBarChartRenderer();
        StandardCategoryItemLabelGenerator categoryLabel = new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("###.##"));
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)categoryLabel);
        renderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.TOP_CENTER));
        renderer.setBaseItemLabelsVisible(true);
        renderer.setBaseItemLabelPaint(Color.black);
        Paint[] array = ChartColor.createDefaultPaintArray();
        renderer.setSeriesPaint(2, array[17]);
        renderer.setSeriesPaint(1, array[20]);
        renderer.setSeriesPaint(0, array[15]);
        renderer.setSeriesBarWidth(0, 1.0);
        renderer.setSeriesBarWidth(1, 1.0);
        renderer.setSeriesBarWidth(2, 1.0);
        renderer.setDrawBarOutline(false);
        renderer.setShadowVisible(false);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        CategoryAxis xAxis = plot.getDomainAxis();
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        this.setFontSizeAndTickRateOfBarCharts(metricType, (BarRenderer)renderer, yAxis);
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.saveGraphAsJPEG(chart, saveName, methodName, metricType);
        return chart;
    }

    private JFreeChart createLineChart(XYDataset xyDataset, String title, String xLabel, String yLabel, String methodName, String saveName, MetricType metricType) throws IOException {
        JFreeChart chart = GraphGenerator.createLineChart(xyDataset, title, xLabel, yLabel, GraphGenerator.DataType.NUMBER);
        this.saveGraphAsJPEG(chart, saveName, methodName, metricType);
        return chart;
    }

    private XYDataset createDataSetForLineChart(String title, MetricType metricType) {
        TimeSeriesCollection dataSet = new TimeSeriesCollection();
        TimeSeries series = new TimeSeries((Comparable)((Object)title));
        String nameOfMetricType = metricType.name();
        boolean dataSetIsEmpty = true;
        switch (metricType) {
            case RESPONSETIMES_PER_TEST: {
                Map<Integer, List<TimingInfo>> allResponseTimes = PerfTestReportUtils.getAllResponseTimesPerTestStep();
                Set<Integer> keys = allResponseTimes.keySet();
                for (Integer key : keys) {
                    List<TimingInfo> timingInfos = allResponseTimes.get(key);
                    for (TimingInfo timingInfo : timingInfos) {
                        long timeStamp = timingInfo.getTimeStamp();
                        Date dateOfMeasurement = new Date(timeStamp);
                        long loadDuration = timingInfo.getLoadDuration();
                        series.addOrUpdate((RegularTimePeriod)new Millisecond(dateOfMeasurement), (double)loadDuration);
                    }
                }
                dataSet.addSeries(series);
                break;
            }
            case RESPONSETIMES_PER_TESTSTEP: {
                Map<Integer, List<TimingInfo>> allResponseTimes1 = PerfTestReportUtils.getAllResponseTimesPerTestStep();
                Set<Integer> keys1 = allResponseTimes1.keySet();
                for (Integer key : keys1) {
                    series = new TimeSeries((Comparable)((Object)("Teststep " + key)));
                    List<TimingInfo> timingInfos = allResponseTimes1.get(key);
                    for (TimingInfo timingInfo : timingInfos) {
                        long timeStamp = timingInfo.getTimeStamp();
                        Date dateOfMeasurement = new Date(timeStamp);
                        long loadDuration = timingInfo.getLoadDuration();
                        series.addOrUpdate((RegularTimePeriod)new Millisecond(dateOfMeasurement), (double)loadDuration);
                    }
                    dataSet.addSeries(series);
                    if (series.getItemCount() == 0) {
                        dataSetIsEmpty = true;
                        continue;
                    }
                    dataSetIsEmpty = false;
                }
                break;
            }
            case REQUESTS_PER_SECOND: {
                Map<Long, Integer> requestsPerSecond2 = PerfTestReportUtils.getRequestsPerSecond();
                Set<Long> datesOfRequestsPerSecond2 = requestsPerSecond2.keySet();
                for (Long timeStamp : datesOfRequestsPerSecond2) {
                    int amount = requestsPerSecond2.get(timeStamp);
                    series.add((RegularTimePeriod)new Second(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            case REQUESTS_PER_MINUTE: {
                Map<Long, Integer> requestsPerMinute2 = PerfTestReportUtils.getRequestsPerMinute();
                Set<Long> datesOfRequestsPerMinute2 = requestsPerMinute2.keySet();
                for (Long timeStamp : datesOfRequestsPerMinute2) {
                    int amount = requestsPerMinute2.get(timeStamp);
                    series.add((RegularTimePeriod)new Minute(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            case REQUESTS_PER_HOUR: {
                Map<Long, Integer> requestsPerHour2 = PerfTestReportUtils.getRequestsPerHour();
                Set<Long> datesOfRequestsPerHour2 = requestsPerHour2.keySet();
                for (Long timeStamp : datesOfRequestsPerHour2) {
                    int amount = requestsPerHour2.get(timeStamp);
                    series.add((RegularTimePeriod)new Hour(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            case TRANSACTIONS_PER_SECOND: {
                Map<Long, Integer> transactionsPerSecond2 = PerfTestReportUtils.getTransactionsPerSecond();
                Set<Long> datesOfTransactionsPerSecond2 = transactionsPerSecond2.keySet();
                for (Long timeStamp : datesOfTransactionsPerSecond2) {
                    int amount = transactionsPerSecond2.get(timeStamp);
                    series.add((RegularTimePeriod)new Second(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            case TRANSACTIONS_PER_HOUR: {
                Map<Long, Integer> transactionsPerHour2 = PerfTestReportUtils.getTransactionsPerHour();
                Set<Long> datesOfTransactionsPerHour2 = transactionsPerHour2.keySet();
                for (Long timeStamp : datesOfTransactionsPerHour2) {
                    int amount = transactionsPerHour2.get(timeStamp);
                    series.add((RegularTimePeriod)new Hour(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            case TRANSACTIONS_PER_MINUTE: {
                Map<Long, Integer> transactionsPerMinute2 = PerfTestReportUtils.getTransactionsPerMinute();
                Set<Long> datesOfTransactionsPerMinute2 = transactionsPerMinute2.keySet();
                for (Long timeStamp : datesOfTransactionsPerMinute2) {
                    int amount = transactionsPerMinute2.get(timeStamp);
                    series.add((RegularTimePeriod)new Minute(new Date(timeStamp)), (double)amount);
                }
                dataSet.addSeries(series);
                break;
            }
            default: {
                throw new RuntimeException("Metric Type \"" + nameOfMetricType + "\" is not supported for a Line Chart Data Set");
            }
        }
        if (series.getItemCount() == 0 && dataSetIsEmpty) {
            this.logger.info("given DataSet is empty, Line Chart for " + nameOfMetricType + " has nothing to show");
        }
        return dataSet;
    }

    private CategoryDataset fillDataSet(DefaultCategoryDataset dataSet, Map<Integer, Long> responseTimes, String title) {
        Set<Integer> mapIds = responseTimes.keySet();
        for (Integer mapId : mapIds) {
            long responseTime = responseTimes.get(mapId);
            dataSet.addValue((double)responseTime, (Comparable)((Object)title), (Comparable)mapId);
        }
        return dataSet;
    }

    private DefaultCategoryDataset createDataSetForBarCharts(String title, MetricType metricType) {
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
        String nameOfMetricType = metricType.name();
        switch (metricType) {
            case AVERAGE_RESPONSETIMES_PER_REPETITION: {
                Map<Integer, Long> averageResponseTimesPerRepetition = PerfTestReportUtils.getAverageResponseTimePerTestRepetition();
                this.fillDataSet(dataSet, averageResponseTimesPerRepetition, title);
                long highestValue4 = this.getMaxValueOfMap(averageResponseTimesPerRepetition);
                this.setDefaultFontSizeAndTickRateForRepetitionBarCharts(highestValue4, metricType);
                break;
            }
            case MAX_RESPONSETIME_PER_REPETITION: {
                Map<Integer, Long> maxResponseTimesPerRepetition = PerfTestReportUtils.getMaxResponseTimePerTestRepetition();
                this.fillDataSet(dataSet, maxResponseTimesPerRepetition, title);
                long highestValue5 = this.getMaxValueOfMap(maxResponseTimesPerRepetition);
                this.setDefaultFontSizeAndTickRateForRepetitionBarCharts(highestValue5, metricType);
                break;
            }
            case MIN_RESPONSETIME_PER_REPETITION: {
                Map<Integer, Long> minResponseTimesPerRepetition = PerfTestReportUtils.getMinResponseTimePerTestRepetition();
                this.fillDataSet(dataSet, minResponseTimesPerRepetition, title);
                long maxValueOfMap1 = this.getMaxValueOfMap(minResponseTimesPerRepetition);
                this.setDefaultFontSizeAndTickRateForRepetitionBarCharts(maxValueOfMap1, metricType);
                break;
            }
            case AVERAGE_RESPONSETIMES_PER_TESTSTEP: {
                Map<Integer, Long> averageResponseTimesPerTestStep = PerfTestReportUtils.getAverageResponseTimePerTestStep();
                this.fillDataSet(dataSet, averageResponseTimesPerTestStep, title);
                long highestValue2 = this.getMaxValueOfMap(averageResponseTimesPerTestStep);
                this.setDefaultFontSizeAndTickRateForTestStepBarChart(highestValue2, metricType);
                break;
            }
            case MAX_RESPONSETIME_PER_TESTSTEP: {
                Map<Integer, Long> maxResponseTimesPerTestStep = PerfTestReportUtils.getMaxResponseTimePerTestStep();
                this.fillDataSet(dataSet, maxResponseTimesPerTestStep, title);
                long highestValue = this.getMaxValueOfMap(maxResponseTimesPerTestStep);
                this.setDefaultFontSizeAndTickRateForTestStepBarChart(highestValue, metricType);
                break;
            }
            case MIN_RESPONSETIME_PER_TESTSTEP: {
                Map<Integer, Long> minResponseTimesPerTestStep = PerfTestReportUtils.getMinResponseTimePerTestStep();
                this.fillDataSet(dataSet, minResponseTimesPerTestStep, title);
                long maxValueOfMap = this.getMaxValueOfMap(minResponseTimesPerTestStep);
                this.setDefaultFontSizeAndTickRateForTestStepBarChart(maxValueOfMap, metricType);
                break;
            }
            case STACKED_RESPONSETIMES_PER_TESTSTEP: {
                Map<Integer, Long> averageResponseTimePerTestStep = PerfTestReportUtils.getAverageResponseTimePerTestStep();
                Map<Integer, Long> maxResponseTimePerTestStep = PerfTestReportUtils.getMaxResponseTimePerTestStep();
                Map<Integer, Long> minResponseTimePerTestStep = PerfTestReportUtils.getMinResponseTimePerTestStep();
                int numberOfTestSteps = PerfTestReportUtils.getNumberOfTestSteps();
                long highestValue3 = 0L;
                for (int i = 1; i <= numberOfTestSteps; ++i) {
                    long minResponseTimeOfTestStep = minResponseTimePerTestStep.get(i);
                    dataSet.addValue((double)minResponseTimeOfTestStep, (Comparable)((Object)"Min Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    Long averageResponseTimeOfTestStep = averageResponseTimePerTestStep.get(i);
                    dataSet.addValue((Number)averageResponseTimeOfTestStep, (Comparable)((Object)"Avg Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    Long maxResponseTimeOfTestStep = maxResponseTimePerTestStep.get(i);
                    dataSet.addValue((Number)maxResponseTimeOfTestStep, (Comparable)((Object)"Max Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    highestValue3 = this.getMaxValueOfMap(maxResponseTimePerTestStep);
                }
                this.setDefaultFontSizeAndTickRateForTestStepBarChart(highestValue3, metricType);
                break;
            }
            case TRANSACTION_STATUS: {
                Map<String, Integer> transactionStatus = PerfTestReportUtils.getTransactionStatus();
                Set<String> statusKeys = transactionStatus.keySet();
                for (String statusKey : statusKeys) {
                    dataSet.addValue(transactionStatus.get(statusKey).doubleValue(), (Comparable)((Object)title), (Comparable)((Object)statusKey));
                }
                break;
            }
            case LAYERED_RESPONSETIMES_PER_REPETITION: {
                Map<Integer, Long> averageResponseTimePerTestRepetition = PerfTestReportUtils.getAverageResponseTimePerTestRepetition();
                Map<Integer, Long> maxResponseTimePerTestRepetition = PerfTestReportUtils.getMaxResponseTimePerTestRepetition();
                Map<Integer, Long> minResponseTimePerTestRepetition = PerfTestReportUtils.getMinResponseTimePerTestRepetition();
                Long highestValue7 = 0L;
                for (int i = 1; i <= this.numberOfTestExecutions; ++i) {
                    Long maxResponseTimeOfTestStep = maxResponseTimePerTestRepetition.get(i);
                    dataSet.addValue((Number)maxResponseTimeOfTestStep, (Comparable)((Object)"Max Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    Long averageResponseTimeOfTestStep = averageResponseTimePerTestRepetition.get(i);
                    dataSet.addValue((Number)averageResponseTimeOfTestStep, (Comparable)((Object)"Avg Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    Long minResponseTimeOfTestStep = minResponseTimePerTestRepetition.get(i);
                    dataSet.addValue((Number)minResponseTimeOfTestStep, (Comparable)((Object)"Min Responsetime"), (Comparable)((Object)String.valueOf(i)));
                    highestValue7 = this.getMaxValueOfMap(maxResponseTimePerTestRepetition);
                }
                this.setDefaultFontSizeAndTickRateForRepetitionBarCharts(highestValue7, metricType);
                break;
            }
            default: {
                throw new RuntimeException("Metric Type \"" + nameOfMetricType + "\" is not supported for a Bar Chart Data Set");
            }
        }
        if (dataSet.getColumnCount() == 0) {
            this.logger.info("given DataSet is empty, Line Chart for " + nameOfMetricType + " has nothing to show");
        }
        return dataSet;
    }

    private void setFontSizeAndTickRateOfBarCharts(MetricType metricType, BarRenderer renderer, NumberAxis rangeAxis) {
        Font font = renderer.getItemLabelFont(0, 0);
        switch (metricType) {
            case AVERAGE_RESPONSETIMES_PER_TESTSTEP: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForAvgResponseTimeBarChart));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForAvgBarChart));
                break;
            }
            case MAX_RESPONSETIME_PER_TESTSTEP: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForMaxResponseTimeBarChart));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForMaxBarChart));
                break;
            }
            case AVERAGE_RESPONSETIMES_PER_REPETITION: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForAvgRepetitionBarCharts));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForAvgRepetitionBarChart));
                break;
            }
            case MAX_RESPONSETIME_PER_REPETITION: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForMaxRepetitionBarCharts));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForMaxRepetitionBarChart));
                break;
            }
            case MIN_RESPONSETIME_PER_REPETITION: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForMinRepetitionBarCharts));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForMinRepetitionBarChart));
                break;
            }
            case LAYERED_RESPONSETIMES_PER_REPETITION: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForLayeredRepetitionBarChart));
                renderer.setBaseLegendTextFont(new Font(font.getName(), 1, this.fontSizeForLayeredRepetitionBarChart));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForLayeredBarChart));
                break;
            }
            case MIN_RESPONSETIME_PER_TESTSTEP: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForMinResponseTimeBarChart));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForMinBarChart));
                break;
            }
            case TRANSACTION_STATUS: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, 12));
                rangeAxis.setTickUnit(new NumberTickUnit(200.0));
                break;
            }
            case STACKED_RESPONSETIMES_PER_TESTSTEP: {
                renderer.setBaseItemLabelFont(new Font(font.getName(), 1, this.fontSizeForStackeResponseTimeBarChart));
                rangeAxis.setTickUnit(new NumberTickUnit((double)this.tickRateForStackedBarChart));
                break;
            }
            default: {
                throw new RuntimeException("Metric Type \"" + metricType.name() + "\" is not supported for Fontsetting and TickRate of BarCharts");
            }
        }
    }

    private void setDefaultFontSizeAndTickRateForRepetitionBarCharts(long highestValue, MetricType metricType) {
        String stringOfHighestValue = String.valueOf(highestValue);
        int numberOfDigits = stringOfHighestValue.length();
        int divisor = 10;
        int adjustedFontSize = 10;
        long adjustedTickRate = highestValue / (long)divisor;
        switch (metricType) {
            case LAYERED_RESPONSETIMES_PER_REPETITION: {
                if (numberOfDigits > 3 && this.numberOfTestExecutions > 20) {
                    this.fontSizeForLayeredRepetitionBarChart = adjustedFontSize;
                }
                if (highestValue <= 10000L) break;
                this.tickRateForLayeredBarChart = adjustedTickRate;
                break;
            }
            case MAX_RESPONSETIME_PER_REPETITION: {
                if (highestValue > 10000L) {
                    this.tickRateForMaxRepetitionBarChart = adjustedTickRate;
                }
                if (numberOfDigits <= 3 || this.numberOfTestExecutions <= 20) break;
                this.fontSizeForMaxRepetitionBarCharts = adjustedFontSize;
                break;
            }
            case AVERAGE_RESPONSETIMES_PER_REPETITION: {
                if (highestValue > 10000L) {
                    this.tickRateForAvgRepetitionBarChart = adjustedTickRate;
                }
                if (numberOfDigits <= 3 || this.numberOfTestExecutions <= 20) break;
                this.fontSizeForAvgRepetitionBarCharts = adjustedFontSize;
                break;
            }
            case MIN_RESPONSETIME_PER_REPETITION: {
                if (highestValue > 10000L) {
                    this.tickRateForMinRepetitionBarChart = adjustedTickRate;
                }
                if (numberOfDigits <= 3 || this.numberOfTestExecutions <= 20) break;
                this.fontSizeForMinRepetitionBarCharts = adjustedFontSize;
                break;
            }
            default: {
                throw new RuntimeException("Metric Type \"" + metricType.name() + "\" is not supported for Fontsetting and TickRate of Charts based on Testexecutions");
            }
        }
    }

    private void setDefaultFontSizeAndTickRateForTestStepBarChart(long highestValue, MetricType metricType) {
        String stringOfHighestValue = String.valueOf(highestValue);
        int numberOfDigits = stringOfHighestValue.length();
        int adjustedFontSize = 10;
        int divisor = 10;
        int numberOfTestSteps = PerfTestReportUtils.getNumberOfTestSteps();
        long adjustedTickRate = highestValue / (long)divisor;
        switch (metricType) {
            case AVERAGE_RESPONSETIMES_PER_TESTSTEP: {
                if (numberOfDigits > 4 && numberOfTestSteps > 15) {
                    this.fontSizeForAvgResponseTimeBarChart = adjustedFontSize;
                }
                if (highestValue <= 10000L) break;
                this.tickRateForAvgBarChart = adjustedTickRate;
                break;
            }
            case MAX_RESPONSETIME_PER_TESTSTEP: {
                if (numberOfDigits > 4 && numberOfTestSteps > 15) {
                    this.fontSizeForMaxResponseTimeBarChart = adjustedFontSize;
                }
                if (highestValue <= 10000L) break;
                this.tickRateForMaxBarChart = adjustedTickRate;
                break;
            }
            case MIN_RESPONSETIME_PER_TESTSTEP: {
                if (numberOfDigits > 4 && numberOfTestSteps > 15) {
                    this.fontSizeForMinResponseTimeBarChart = adjustedFontSize;
                }
                if (highestValue <= 10000L) break;
                this.tickRateForMinBarChart = adjustedTickRate;
                break;
            }
            case STACKED_RESPONSETIMES_PER_TESTSTEP: {
                if (numberOfDigits > 4 && numberOfTestSteps > 15) {
                    this.fontSizeForStackeResponseTimeBarChart = adjustedFontSize;
                }
                if (highestValue * 3L <= 10000L) break;
                this.tickRateForStackedBarChart = highestValue * 3L / (long)divisor;
                break;
            }
            default: {
                throw new RuntimeException("Metric Type \"" + metricType.name() + "\" is not supported for Fontsetting and TickRate of Charts based on Testrepetition");
            }
        }
    }

    private void adjustFontSizesToNumberOfTestSteps() {
        int numberOfTestSteps = PerfTestReportUtils.getNumberOfTestSteps();
        if (numberOfTestSteps > 5) {
            this.fontSizeForAvgResponseTimeBarChart = 12;
            this.fontSizeForStackeResponseTimeBarChart = 12;
            this.fontSizeForMinResponseTimeBarChart = 12;
            this.fontSizeForMaxResponseTimeBarChart = 12;
        }
        if (numberOfTestSteps > 18) {
            this.fontSizeForStackeResponseTimeBarChart = 10;
            this.fontSizeForMaxResponseTimeBarChart = 10;
        }
        if (numberOfTestSteps > 20) {
            this.fontSizeForAvgResponseTimeBarChart = 10;
            this.fontSizeForMinResponseTimeBarChart = 10;
        }
    }

    private void adjustFontSizesAndImageWidthToNumberOfRepetitions() {
        if (this.numberOfTestExecutions > 14) {
            this.widthOfRepetitionCharts = 1600;
        }
        if (this.numberOfTestExecutions > 35) {
            this.fontSizeForLayeredRepetitionBarChart = 10;
            this.fontSizeForAvgRepetitionBarCharts = 10;
            this.fontSizeForMinRepetitionBarCharts = 10;
            this.fontSizeForMaxRepetitionBarCharts = 10;
        }
    }

    private void makeSubDirectoryForTestMethod(String testMethod) {
        File resultsSubFolder = new File(PerfTestReportUtils.getDestinationFolder() + testMethod.concat("\\") + "Graphs_Of_PerfTest");
        if (!resultsSubFolder.exists()) {
            resultsSubFolder.mkdirs();
        }
    }

    private void saveGraphAsJPEG(JFreeChart chart, String chartName, String methodName, MetricType metricType) throws IOException {
        File lineChart = new File(PerfTestReportUtils.getDestinationFolder() + methodName.concat("\\") + "Graphs_Of_PerfTest".concat("\\") + chartName + ".jpeg");
        switch (metricType) {
            case AVERAGE_RESPONSETIMES_PER_REPETITION: 
            case MAX_RESPONSETIME_PER_REPETITION: 
            case MIN_RESPONSETIME_PER_REPETITION: 
            case LAYERED_RESPONSETIMES_PER_REPETITION: {
                ChartUtilities.saveChartAsJPEG((File)lineChart, (JFreeChart)chart, (int)this.widthOfRepetitionCharts, (int)600);
                break;
            }
            case RESPONSETIMES_PER_TEST: 
            case RESPONSETIMES_PER_TESTSTEP: 
            case REQUESTS_PER_SECOND: 
            case REQUESTS_PER_MINUTE: 
            case REQUESTS_PER_HOUR: 
            case TRANSACTIONS_PER_SECOND: 
            case TRANSACTIONS_PER_HOUR: 
            case TRANSACTIONS_PER_MINUTE: 
            case AVERAGE_RESPONSETIMES_PER_TESTSTEP: 
            case MAX_RESPONSETIME_PER_TESTSTEP: 
            case MIN_RESPONSETIME_PER_TESTSTEP: 
            case STACKED_RESPONSETIMES_PER_TESTSTEP: 
            case TRANSACTION_STATUS: {
                ChartUtilities.saveChartAsJPEG((File)lineChart, (JFreeChart)chart, (int)800, (int)600);
                break;
            }
            default: {
                ChartUtilities.saveChartAsJPEG((File)lineChart, (JFreeChart)chart, (int)800, (int)600);
                this.logger.warn("No specific dimensions for the saving of the given MetricType: \"" + metricType.name() + "\" are supported yet. Using default values.");
            }
        }
    }

    private void generateMetrics(Map<Long, List<TimingInfo>> pageLoadInfos) {
        PerfTestReportUtils.initializeDataForGraphGeneration(pageLoadInfos);
        PerfTestReportUtils.generateMinMaxAvgResponseTimePerMethodExecution();
        PerfTestReportUtils.generateMinMaxAvgResponseTimePerTestStep();
        PerfTestReportUtils.generateTransactionStatus();
        PerfTestReportUtils.generateResponseTimeHistory();
        PerfTestReportUtils.generateTransactionThroughput(13);
        PerfTestReportUtils.generateTransactionThroughput(12);
        PerfTestReportUtils.generateTransactionThroughput(11);
        PerfTestReportUtils.generateRequestThroughput(13);
        PerfTestReportUtils.generateRequestThroughput(12);
        PerfTestReportUtils.generateRequestThroughput(11);
    }

    private long getMaxValueOfMap(Map<Integer, Long> responseTimeMap) {
        if (responseTimeMap == null) {
            throw new SystemException("Map is null");
        }
        int size = responseTimeMap.size();
        if (size == 0) {
            return 0L;
        }
        long highestValue = 0L;
        Set<Integer> mapKeys = responseTimeMap.keySet();
        for (Integer mapKey : mapKeys) {
            long maxResponseTimeOfTestStep = responseTimeMap.get(mapKey);
            if (maxResponseTimeOfTestStep <= highestValue) continue;
            highestValue = maxResponseTimeOfTestStep;
        }
        return highestValue;
    }

    private long getMinValueOfMap(Map<Integer, Long> responseTimeMap) {
        if (responseTimeMap == null) {
            throw new SystemException("Map is null");
        }
        int size = responseTimeMap.size();
        if (size == 0) {
            return 0L;
        }
        long lowestValue = 100000L;
        Set<Integer> mapKeys = responseTimeMap.keySet();
        for (Integer mapKey : mapKeys) {
            long minResponseTimeOfTestStep = responseTimeMap.get(mapKey);
            if (lowestValue <= minResponseTimeOfTestStep) continue;
            lowestValue = minResponseTimeOfTestStep;
        }
        return lowestValue;
    }
}

