/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report.perf;

import eu.tsystems.mms.tic.testframework.internal.TimingInfo;
import eu.tsystems.mms.tic.testframework.report.perf.PerfTestContainer;
import eu.tsystems.mms.tic.testframework.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.testng.ITestResult;

public final class PerfTestReportUtils {
    private static Map<String, List<TimingInfo>> pageLoadInfosPerTestStepAction = new HashMap<String, List<TimingInfo>>();
    private static Map<String, List<List<TimingInfo>>> allPageLoadInfosPerVU = new HashMap<String, List<List<TimingInfo>>>();
    private static Map<Long, List<TimingInfo>> pageLoadInfosPerTestMethodInvocation = new HashMap<Long, List<TimingInfo>>();
    private static Map<Integer, Long> averageResponseTimePerTestRepetition = new HashMap<Integer, Long>();
    private static Map<Integer, Long> maxResponseTimePerTestRepetition = new HashMap<Integer, Long>();
    private static Map<Integer, Long> minResponseTimePerTestRepetition = new HashMap<Integer, Long>();
    private static Map<Integer, Long> averageResponseTimePerTestStep = new HashMap<Integer, Long>();
    private static Map<Integer, Long> maxResponseTimePerTestStep = new HashMap<Integer, Long>();
    private static Map<Integer, Long> minResponseTimePerTestStep = new HashMap<Integer, Long>();
    private static Map<String, Long> averageResponseTimePerTestStepAction = new HashMap<String, Long>();
    private static Map<String, Long> maxResponseTimePerTestStepAction = new HashMap<String, Long>();
    private static Map<String, Long> minResponseTimePerTestStepAction = new HashMap<String, Long>();
    private static Map<Integer, List<TimingInfo>> allResponseTimesPerTestStep = new HashMap<Integer, List<TimingInfo>>();
    private static Map<String, Integer> transactionStatus = new TreeMap<String, Integer>();
    private static Map<Long, Integer> transactionsPerSecond = new HashMap<Long, Integer>();
    private static Map<Long, Integer> transactionsPerMinute = new HashMap<Long, Integer>();
    private static Map<Long, Integer> transactionsPerHour = new HashMap<Long, Integer>();
    private static Map<Long, Integer> requestsPerSecond = new HashMap<Long, Integer>();
    private static Map<Long, Integer> requestsPerMinute = new HashMap<Long, Integer>();
    private static Map<Long, Integer> requestsPerHour = new HashMap<Long, Integer>();
    public static final String TEST_END = "Test_End";
    public static final String TEXT_TEST_SUCCESS = "Success";
    public static final String TEXT_TEST_FAIL = "Fail";
    public static final String TEXT_TEST_SKIP = "Skip";
    private static String destinationFolder = "unknown";
    private static final String SUB_FOLDER_OF_CSV = "csv_per_vu\\";
    private static final String SUB_FOLDER_TEST_CONFIG = "testconfig\\";
    private static int numberOfTestSteps = 0;

    private PerfTestReportUtils() {
    }

    public static void initializeDataForGraphGeneration(Map<Long, List<TimingInfo>> pageLoadInfos) {
        PerfTestReportUtils.initializeAllPageLoadInfosPerVU(pageLoadInfos);
        PerfTestReportUtils.generateNumberOfTestSteps();
    }

    private static void initializeAllPageLoadInfosPerVU(Map<Long, List<TimingInfo>> pageLoadInfos) {
        Set<Long> idSet = pageLoadInfos.keySet();
        pageLoadInfosPerTestMethodInvocation = pageLoadInfos;
        allPageLoadInfosPerVU.clear();
        for (Long threadId : idSet) {
            String threadName = PerfTestContainer.getThreadNameByID((Long)threadId);
            ITestResult iTestResult = PerfTestContainer.getTestResult((Long)threadId);
            ArrayList<TimingInfo> timingInfosToUpdate = new ArrayList<TimingInfo>();
            List<Object> pageLoadInfosPerRepetition = null;
            pageLoadInfosPerRepetition = allPageLoadInfosPerVU.get(threadName) == null ? new ArrayList() : allPageLoadInfosPerVU.get(threadName);
            List<TimingInfo> timingInfoOfTestRunOfUser = pageLoadInfos.get(threadId);
            for (TimingInfo timingInfoOfTest : timingInfoOfTestRunOfUser) {
                timingInfosToUpdate.add(timingInfoOfTest);
            }
            if (iTestResult.getStatus() == 1) {
                TimingInfo testEnd = new TimingInfo(null, "no url", 0L, iTestResult.getEndMillis());
                timingInfosToUpdate.add(testEnd);
            }
            pageLoadInfosPerRepetition.add(timingInfosToUpdate);
            allPageLoadInfosPerVU.put(threadName, pageLoadInfosPerRepetition);
        }
    }

    private static void generateNumberOfTestSteps() {
        int maxNumberOfTestStepsOfTestMethod = 0;
        Set<Long> threadIDs = pageLoadInfosPerTestMethodInvocation.keySet();
        for (long threadID : threadIDs) {
            int testStepsOfTestMethodRepetition = pageLoadInfosPerTestMethodInvocation.get(threadID).size();
            if (testStepsOfTestMethodRepetition <= maxNumberOfTestStepsOfTestMethod) continue;
            maxNumberOfTestStepsOfTestMethod = testStepsOfTestMethodRepetition;
        }
        numberOfTestSteps = maxNumberOfTestStepsOfTestMethod;
    }

    public static void generateMinMaxAvgResponseTimePerMethodExecution() {
        HashMap loadTimesPerInvocation = new HashMap();
        for (String user : allPageLoadInfosPerVU.keySet()) {
            List<List<TimingInfo>> pageLoadInfosPerInvocation = allPageLoadInfosPerVU.get(user);
            int i = 0;
            for (List<TimingInfo> timingInfos : pageLoadInfosPerInvocation) {
                ++i;
                ArrayList<Long> loadTimes = new ArrayList<Long>();
                for (TimingInfo timingInfo : timingInfos) {
                    String context;
                    if (timingInfo == null || (context = timingInfo.getContext()) == null) continue;
                    Long loadDuration = timingInfo.getLoadDuration();
                    loadTimes.add(loadDuration);
                }
                if (loadTimesPerInvocation.containsKey(i)) {
                    List existingLoadTimes = (List)loadTimesPerInvocation.get(i);
                    existingLoadTimes.addAll(loadTimes);
                    continue;
                }
                loadTimesPerInvocation.put(i, loadTimes);
            }
        }
        for (Integer invocationNumber : loadTimesPerInvocation.keySet()) {
            List loadTimesOfInvocation = (List)loadTimesPerInvocation.get(invocationNumber);
            Long averageResponseTimeOfTestInvocation = NumberUtils.getAverageValue((List)loadTimesOfInvocation);
            Long minResponseTimeOfTestInvocation = (Long)NumberUtils.getMinValue((List)loadTimesOfInvocation);
            Long maxResponseTimeOfTestInvocation = (Long)NumberUtils.getMaxValue((List)loadTimesOfInvocation);
            averageResponseTimePerTestRepetition.put(invocationNumber, averageResponseTimeOfTestInvocation);
            maxResponseTimePerTestRepetition.put(invocationNumber, maxResponseTimeOfTestInvocation);
            minResponseTimePerTestRepetition.put(invocationNumber, minResponseTimeOfTestInvocation);
        }
    }

    public static void generateMinMaxAvgResponseTimePerTestStep() {
        HashMap loadTimesPerTestStep = new HashMap();
        for (Number invocationNumber : pageLoadInfosPerTestMethodInvocation.keySet()) {
            List<TimingInfo> timingInfos = pageLoadInfosPerTestMethodInvocation.get(invocationNumber);
            int i = 0;
            for (TimingInfo timingInfo : timingInfos) {
                ++i;
                if (timingInfo == null) continue;
                Long loadDuration = timingInfo.getLoadDuration();
                if (loadTimesPerTestStep.containsKey(i)) {
                    List existingLoadTimes = (List)loadTimesPerTestStep.get(i);
                    existingLoadTimes.add(loadDuration);
                    continue;
                }
                ArrayList<Long> loadTimes = new ArrayList<Long>();
                loadTimes.add(loadDuration);
                loadTimesPerTestStep.put(i, loadTimes);
            }
        }
        for (Number invocationNumber : loadTimesPerTestStep.keySet()) {
            List loadTimesOfTestStep = (List)loadTimesPerTestStep.get(invocationNumber);
            Long averageResponseTimeOfTestStep = NumberUtils.getAverageValue((List)loadTimesOfTestStep);
            Long minResponseTimeOfTestStep = (Long)NumberUtils.getMinValue((List)loadTimesOfTestStep);
            Long maxResponseTimeOfTestStep = (Long)NumberUtils.getMaxValue((List)loadTimesOfTestStep);
            averageResponseTimePerTestStep.put((Integer)invocationNumber, averageResponseTimeOfTestStep);
            maxResponseTimePerTestStep.put((Integer)invocationNumber, maxResponseTimeOfTestStep);
            minResponseTimePerTestStep.put((Integer)invocationNumber, minResponseTimeOfTestStep);
        }
    }

    public static void generateTransactionStatus() {
        if (pageLoadInfosPerTestMethodInvocation != null) {
            Set<Long> testMethodRepetitionNumbers = pageLoadInfosPerTestMethodInvocation.keySet();
            int successfulTransactions = 0;
            int failedTransactions = 0;
            int skippedTransactions = 0;
            for (Long repetitionNumber : testMethodRepetitionNumbers) {
                ITestResult iTestResult = PerfTestContainer.getTestResult((Long)repetitionNumber);
                int testStatus = iTestResult.getStatus();
                if (testStatus == 1) {
                    ++successfulTransactions;
                }
                if (testStatus == 3) {
                    ++skippedTransactions;
                }
                if (testStatus != 2) continue;
                ++failedTransactions;
            }
            transactionStatus.put(TEXT_TEST_SUCCESS, successfulTransactions);
            transactionStatus.put(TEXT_TEST_FAIL, failedTransactions);
            transactionStatus.put(TEXT_TEST_SKIP, skippedTransactions);
        }
    }

    public static void generateResponseTimeHistory() {
        if (pageLoadInfosPerTestMethodInvocation != null) {
            Set<Long> testMethodRepetitionNumbers = pageLoadInfosPerTestMethodInvocation.keySet();
            for (int i = 0; i < numberOfTestSteps; ++i) {
                ArrayList<TimingInfo> timingInfos = new ArrayList<TimingInfo>();
                for (Long repetitionNumber : testMethodRepetitionNumbers) {
                    List<TimingInfo> timingInfoPerTransaction = pageLoadInfosPerTestMethodInvocation.get(repetitionNumber);
                    if (timingInfoPerTransaction.size() <= i) continue;
                    TimingInfo timingInfo = timingInfoPerTransaction.get(i);
                    timingInfos.add(timingInfo);
                }
                allResponseTimesPerTestStep.put(i, timingInfos);
            }
        }
    }

    public static void generateTransactionThroughput(int timeUnit) {
        if (allPageLoadInfosPerVU != null) {
            Set<String> userNames = allPageLoadInfosPerVU.keySet();
            for (String userName : userNames) {
                List<List<TimingInfo>> responseTimesOfUser = allPageLoadInfosPerVU.get(userName);
                if (responseTimesOfUser == null) continue;
                for (List<TimingInfo> timingInfosOfRepetition : responseTimesOfUser) {
                    block7: for (TimingInfo timingInfoOfVU : timingInfosOfRepetition) {
                        String context = timingInfoOfVU.getContext();
                        if (context != null) continue;
                        Long timeStampOfExecution = timingInfoOfVU.getTimeStamp();
                        switch (timeUnit) {
                            case 13: {
                                PerfTestReportUtils.sumUpTransactionThroughputPerTimeUnit(timeStampOfExecution, timeUnit, transactionsPerSecond);
                                continue block7;
                            }
                            case 12: {
                                PerfTestReportUtils.sumUpTransactionThroughputPerTimeUnit(timeStampOfExecution, timeUnit, transactionsPerMinute);
                                continue block7;
                            }
                            case 11: {
                                PerfTestReportUtils.sumUpTransactionThroughputPerTimeUnit(timeStampOfExecution, timeUnit, transactionsPerHour);
                                continue block7;
                            }
                        }
                        throw new RuntimeException("TransactionThroughput is not supported for the given timeUnit");
                    }
                }
            }
        }
    }

    private static void sumUpTransactionThroughputPerTimeUnit(Long timeStampOfMeasurement, int timeUnit, Map<Long, Integer> transactionsPerTimeUnit) {
        Set<Long> timeStamps = transactionsPerTimeUnit.keySet();
        boolean alreadyExisting = false;
        for (Long timeStamp : timeStamps) {
            if (!PerfTestReportUtils.compareTimeStamps(timeStampOfMeasurement, timeStamp, timeUnit)) continue;
            int amount = transactionsPerTimeUnit.get(timeStamp);
            transactionsPerTimeUnit.put(timeStamp, ++amount);
            alreadyExisting = true;
            break;
        }
        if (!alreadyExisting) {
            transactionsPerTimeUnit.put(timeStampOfMeasurement, 1);
        }
    }

    public static boolean compareTimeStamps(Long timeStampOfMeasurement, Long timeStampInTransactionMap, int timeUnit) {
        switch (timeUnit) {
            case 13: {
                timeStampOfMeasurement = TimeUnit.MILLISECONDS.toSeconds(timeStampOfMeasurement);
                timeStampInTransactionMap = TimeUnit.MILLISECONDS.toSeconds(timeStampInTransactionMap);
                break;
            }
            case 12: {
                timeStampOfMeasurement = TimeUnit.MILLISECONDS.toMinutes(timeStampOfMeasurement);
                timeStampInTransactionMap = TimeUnit.MILLISECONDS.toMinutes(timeStampInTransactionMap);
                break;
            }
            case 11: {
                timeStampOfMeasurement = TimeUnit.MILLISECONDS.toHours(timeStampOfMeasurement);
                timeStampInTransactionMap = TimeUnit.MILLISECONDS.toHours(timeStampInTransactionMap);
                break;
            }
            default: {
                throw new RuntimeException("Camparison not supported for the given timeUnit");
            }
        }
        return timeStampOfMeasurement.equals(timeStampInTransactionMap);
    }

    public static void generateRequestThroughput(int timeUnit) {
        if (pageLoadInfosPerTestMethodInvocation != null) {
            Set<Long> testMethodRepetitionNumbers = pageLoadInfosPerTestMethodInvocation.keySet();
            for (Long repetitionNumber : testMethodRepetitionNumbers) {
                List<TimingInfo> timingInfoPerTransaction = pageLoadInfosPerTestMethodInvocation.get(repetitionNumber);
                block6: for (TimingInfo timingInfoOfTransaction : timingInfoPerTransaction) {
                    Long timeStampOfMeasurement = timingInfoOfTransaction.getTimeStamp();
                    switch (timeUnit) {
                        case 13: {
                            PerfTestReportUtils.sumUpRequestThroughputPerTimeUnit(timeStampOfMeasurement, timeUnit, requestsPerSecond);
                            continue block6;
                        }
                        case 12: {
                            PerfTestReportUtils.sumUpRequestThroughputPerTimeUnit(timeStampOfMeasurement, timeUnit, requestsPerMinute);
                            continue block6;
                        }
                        case 11: {
                            PerfTestReportUtils.sumUpRequestThroughputPerTimeUnit(timeStampOfMeasurement, timeUnit, requestsPerHour);
                            continue block6;
                        }
                    }
                    throw new RuntimeException("RequestThroughput is not supported for the given timeUnit");
                }
            }
        }
    }

    private static void sumUpRequestThroughputPerTimeUnit(Long timeStampOfMeasurement, int timeUnit, Map<Long, Integer> requestsPerTimeUnit) {
        Set<Long> timeStamps = requestsPerTimeUnit.keySet();
        boolean alreadyExisting = false;
        for (Long timeStamp : timeStamps) {
            if (!PerfTestReportUtils.compareTimeStamps(timeStampOfMeasurement, timeStamp, timeUnit)) continue;
            int amount = requestsPerTimeUnit.get(timeStamp);
            requestsPerTimeUnit.put(timeStamp, ++amount);
            alreadyExisting = true;
            break;
        }
        if (!alreadyExisting) {
            requestsPerTimeUnit.put(timeStampOfMeasurement, 1);
        }
    }

    public static Map<Long, List<TimingInfo>> sortMap(Map<Long, List<TimingInfo>> map) {
        LinkedList<Map.Entry<Long, List<TimingInfo>>> list = new LinkedList<Map.Entry<Long, List<TimingInfo>>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> {
            List valueOfEntryObject1 = (List)o1.getValue();
            Long timeStampFirstEntry = ((TimingInfo)valueOfEntryObject1.get(0)).getTimeStamp();
            List valueOfEntryObject2 = (List)o2.getValue();
            Long timeStampSecondEntry = ((TimingInfo)valueOfEntryObject2.get(0)).getTimeStamp();
            int result = timeStampFirstEntry.compareTo(timeStampSecondEntry);
            return result;
        });
        LinkedHashMap<Long, List<TimingInfo>> sortedHashMap = new LinkedHashMap<Long, List<TimingInfo>>();
        for (Map.Entry entry : list) {
            sortedHashMap.put((Long)entry.getKey(), (List<TimingInfo>)entry.getValue());
        }
        return sortedHashMap;
    }

    public static Map<Long, List<TimingInfo>> createPageLoadInfosOfAllThreads(Map<String, Map<Long, List<TimingInfo>>> pageLoadInfosPerTestMethod) {
        Set<String> keys = pageLoadInfosPerTestMethod.keySet();
        HashMap<Long, List<TimingInfo>> pageLoadInfos = new HashMap<Long, List<TimingInfo>>();
        for (String testMethodName : keys) {
            pageLoadInfos.putAll(pageLoadInfosPerTestMethod.get(testMethodName));
        }
        return pageLoadInfos;
    }

    public static void createPageLoadInfosOfAllActions(Map<String, Map<Long, List<TimingInfo>>> pageLoadInfosPerTestMethod) {
        Set<String> testMethodNames = pageLoadInfosPerTestMethod.keySet();
        HashMap<String, List<TimingInfo>> pageLoadInfosOfAllActions = new HashMap<String, List<TimingInfo>>();
        for (String testMethodName : testMethodNames) {
            Map<Long, List<TimingInfo>> pageLoadInfosPerThreadMap = pageLoadInfosPerTestMethod.get(testMethodName);
            Set<Long> threadIDs = pageLoadInfosPerThreadMap.keySet();
            for (Long threadID : threadIDs) {
                List<TimingInfo> timingInfosOfThread = pageLoadInfosPerThreadMap.get(threadID);
                for (TimingInfo timingInfo : timingInfosOfThread) {
                    ArrayList<TimingInfo> pageLoadOfSpecificAction;
                    String actionName = timingInfo.getContext();
                    if (actionName == null) {
                        actionName = "Call Of startURL";
                    }
                    if ((pageLoadOfSpecificAction = (ArrayList<TimingInfo>)pageLoadInfosOfAllActions.get(actionName)) == null) {
                        pageLoadOfSpecificAction = new ArrayList<TimingInfo>();
                        pageLoadOfSpecificAction.add(timingInfo);
                    } else {
                        pageLoadOfSpecificAction.add(timingInfo);
                    }
                    pageLoadInfosOfAllActions.put(actionName, pageLoadOfSpecificAction);
                }
            }
        }
        pageLoadInfosPerTestStepAction = pageLoadInfosOfAllActions;
    }

    public static void prepareMeasurementsForReport() {
        Map pageLoadInfosPerTestMethod = PerfTestContainer.getPageLoadInfosPerTestMethod();
        Set testMethodNames = pageLoadInfosPerTestMethod.keySet();
        for (String testMethodName : testMethodNames) {
            Map pageLoadInfoPerTestMethod = (Map)pageLoadInfosPerTestMethod.get(testMethodName);
            Map<Long, List<TimingInfo>> sortedPageLoadInfos = PerfTestReportUtils.sortMap(pageLoadInfoPerTestMethod);
            pageLoadInfosPerTestMethod.put(testMethodName, sortedPageLoadInfos);
        }
        PerfTestReportUtils.createPageLoadInfosOfAllActions(pageLoadInfosPerTestMethod);
        PerfTestReportUtils.generateAverageMinMaxPerAction();
    }

    public static void generateAverageMinMaxPerAction() {
        HashMap loadTimesPerTestStepAction = new HashMap();
        Set<String> actionNames = pageLoadInfosPerTestStepAction.keySet();
        for (String actionName : actionNames) {
            List<TimingInfo> measurementsOfSpecificiAction = pageLoadInfosPerTestStepAction.get(actionName);
            for (TimingInfo measurement : measurementsOfSpecificiAction) {
                if (measurement == null) continue;
                Long loadDuration = measurement.getLoadDuration();
                if (loadTimesPerTestStepAction.containsKey(actionName)) {
                    List existingLoadTimes = (List)loadTimesPerTestStepAction.get(actionName);
                    existingLoadTimes.add(loadDuration);
                    continue;
                }
                ArrayList<Long> loadTimes = new ArrayList<Long>();
                loadTimes.add(loadDuration);
                loadTimesPerTestStepAction.put(actionName, loadTimes);
            }
        }
        for (String actionName : loadTimesPerTestStepAction.keySet()) {
            List loadTimesOfTestStep = (List)loadTimesPerTestStepAction.get(actionName);
            Long averageResponseTimeOfTestStep = NumberUtils.getAverageValue((List)loadTimesOfTestStep);
            Long minResponseTimeOfTestStep = (Long)NumberUtils.getMinValue((List)loadTimesOfTestStep);
            Long maxResponseTimeOfTestStep = (Long)NumberUtils.getMaxValue((List)loadTimesOfTestStep);
            averageResponseTimePerTestStepAction.put(actionName, averageResponseTimeOfTestStep);
            maxResponseTimePerTestStepAction.put(actionName, maxResponseTimeOfTestStep);
            minResponseTimePerTestStepAction.put(actionName, minResponseTimeOfTestStep);
        }
    }

    public static Map<Long, Integer> getRequestsPerSecond() {
        return requestsPerSecond;
    }

    public static Map<Long, Integer> getRequestsPerMinute() {
        return requestsPerMinute;
    }

    public static Map<Long, Integer> getRequestsPerHour() {
        return requestsPerHour;
    }

    public static Map<Long, Integer> getTransactionsPerSecond() {
        return transactionsPerSecond;
    }

    public static Map<Long, Integer> getTransactionsPerMinute() {
        return transactionsPerMinute;
    }

    public static Map<Long, Integer> getTransactionsPerHour() {
        return transactionsPerHour;
    }

    public static Map<String, List<List<TimingInfo>>> getAllPageLoadInfosPerVU() {
        return allPageLoadInfosPerVU;
    }

    public static Map<Long, List<TimingInfo>> getPageLoadInfosPerTestMethodInvocation() {
        return pageLoadInfosPerTestMethodInvocation;
    }

    public static Map<Integer, Long> getAverageResponseTimePerTestStep() {
        return averageResponseTimePerTestStep;
    }

    public static Map<Integer, Long> getMaxResponseTimePerTestStep() {
        return maxResponseTimePerTestStep;
    }

    public static Map<Integer, Long> getMinResponseTimePerTestStep() {
        return minResponseTimePerTestStep;
    }

    public static Map<String, Integer> getTransactionStatus() {
        return transactionStatus;
    }

    public static Map<Integer, List<TimingInfo>> getAllResponseTimesPerTestStep() {
        return allResponseTimesPerTestStep;
    }

    public static Map<Integer, Long> getAverageResponseTimePerTestRepetition() {
        return averageResponseTimePerTestRepetition;
    }

    public static Map<Integer, Long> getMaxResponseTimePerTestRepetition() {
        return maxResponseTimePerTestRepetition;
    }

    public static Map<Integer, Long> getMinResponseTimePerTestRepetition() {
        return minResponseTimePerTestRepetition;
    }

    public static String getDestinationFolder() {
        return destinationFolder;
    }

    public static String getTestName(Map<Long, List<TimingInfo>> pageLoadInfosRaw) {
        Long firstThreadId = pageLoadInfosRaw.entrySet().iterator().next().getKey();
        String testName = PerfTestContainer.getTestResult((Long)firstThreadId).getName();
        return testName;
    }

    public static Map<String, List<TimingInfo>> getPageLoadInfosPerTestStepAction() {
        return pageLoadInfosPerTestStepAction;
    }

    public static Map<String, Long> getAverageResponseTimePerTestStepAction() {
        return averageResponseTimePerTestStepAction;
    }

    public static Map<String, Long> getMaxResponseTimePerTestStepAction() {
        return maxResponseTimePerTestStepAction;
    }

    public static Map<String, Long> getMinResponseTimePerTestStepAction() {
        return minResponseTimePerTestStepAction;
    }

    public static int getNumberOfTestSteps() {
        return numberOfTestSteps;
    }
}

