/*
 * Decompiled with CFR 0.152.
 */
package eu.tsystems.mms.tic.testframework.report.perf;

import eu.tsystems.mms.tic.testframework.internal.Timings;
import eu.tsystems.mms.tic.testframework.report.GraphGenerator;
import java.io.File;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimingsGraphGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimingsGraphGenerator.class);

    private static File createGraph(String title, String filename, Map<Integer, Long> map) {
        try {
            XYSeriesCollection collection = new XYSeriesCollection();
            XYSeries series = new XYSeries((Comparable)((Object)"find()s"));
            for (Integer integer : map.keySet()) {
                series.add((Number)integer, (Number)map.get(integer));
            }
            collection.addSeries(series);
            JFreeChart chart = GraphGenerator.createLineChart((XYDataset)collection, title, "#", "ms", GraphGenerator.DataType.NUMBER);
            File file = GraphGenerator.saveGraphAsJPEG(chart, "graph/" + filename + ".jpg", 800, 400);
            return file;
        }
        catch (Exception e) {
            LOGGER.error("Could not save graph", (Throwable)e);
            return null;
        }
    }

    public static File createGuiElementFindTimingsGraph() {
        return TimingsGraphGenerator.createGraph("find()s", "timingsFind", Timings.TIMING_GUIELEMENT_FIND);
    }

    public static File createGuiElementFindWithParentTimingsGraph() {
        return TimingsGraphGenerator.createGraph("find()s with parent", "timingsFindParent", Timings.TIMING_GUIELEMENT_FIND_WITH_PARENT);
    }
}

